/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.mvc.plugins.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.util.GrailsUtils;
import org.jetbrains.plugins.groovy.mvc.MvcConsole;
import org.jetbrains.plugins.groovy.mvc.plugins.MvcPluginsMain;

public class ReloadMvcPluginListAction
extends AnAction
implements DumbAware {
    private final MvcPluginsMain myMvcPluginsMain;

    public ReloadMvcPluginListAction(MvcPluginsMain mvcPluginsMain) {
        super("Reload plugin list", "Reload plugin list", AllIcons.Actions.Refresh);
        this.myMvcPluginsMain = mvcPluginsMain;
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = this.myMvcPluginsMain.getModule().getProject();
        if (MvcConsole.getInstance((Project)project).isExecuting()) {
            String frameworkName = this.myMvcPluginsMain.getFramework().getDisplayName();
            Messages.showErrorDialog((Project)project, (String)("Failed to reload plugin list: " + frameworkName + " Console is busy"), (String)("Can't execute " + frameworkName + " command"));
            return;
        }
        ReloadMvcPluginListAction.doReloadPluginList(this.myMvcPluginsMain);
    }

    public static void doReloadPluginList(final @NotNull MvcPluginsMain myMvcPluginsMain) {
        if (myMvcPluginsMain == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "myMvcPluginsMain", "org/jetbrains/plugins/groovy/mvc/plugins/actions/ReloadMvcPluginListAction", "doReloadPluginList"));
        }
        assert (!MvcConsole.getInstance((Project)myMvcPluginsMain.getModule().getProject()).isExecuting());
        GrailsUtils.runCommandInModal(myMvcPluginsMain.getModule(), myMvcPluginsMain.getFramework(), "Updating plugin list...", new Runnable(){

            @Override
            public void run() {
                myMvcPluginsMain.reloadPlugins();
            }
        }, true, "list-plugins", new String[0]);
    }
}

