/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dsm.actions;

import com.intellij.analysis.AnalysisScope;
import com.intellij.dsm.actions.DsmUIUtil;
import com.intellij.dsm.model.DsmModel;
import com.intellij.dsm.model.classes.ClassNode;
import com.intellij.dsm.model.classes.ClassesDsmModelBuilder;
import com.intellij.dsm.ui.DsmView;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import javax.swing.SwingUtilities;

class DsmAnalysisHandler {
    private final Project myProject;
    private final AnalysisScope myScope;

    public DsmAnalysisHandler(Project project, AnalysisScope scope) {
        this.myProject = project;
        this.myScope = scope;
    }

    public void execute(ProgressIndicator indicator) {
        DsmModel<ClassNode> model = new ClassesDsmModelBuilder(this.myProject, this.myScope, indicator).buildDsmModel();
        if (model == null || model.getSize() == 0) {
            return;
        }
        final DsmView<ClassNode> view = new DsmView<ClassNode>(model);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!DsmAnalysisHandler.this.myProject.isDisposed()) {
                    DsmUIUtil.showView(DsmAnalysisHandler.this.myProject, view, DsmAnalysisHandler.this.myScope.getShortenName());
                }
            }
        });
    }
}

