/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dsm.model.classes;

import com.intellij.dsm.model.classes.And;
import com.intellij.dsm.model.classes.ClassNode;
import com.intellij.dsm.model.classes.TopToBottomTreeStructure;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.Pair;
import com.intellij.util.ArrayUtil;
import com.intellij.util.BooleanFunction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.gga.graph.maps.DataGraph;

class ModuleSplitter
implements TopToBottomTreeStructure.TreeSplitter<ClassNode> {
    ModuleSplitter() {
    }

    @Override
    public List<Pair<BooleanFunction<ClassNode>, TopToBottomTreeStructure.NodeData>> split(DataGraph<ClassNode, Integer> dataGraph, BooleanFunction<ClassNode> memberFunction, TopToBottomTreeStructure.NodeData parentData) {
        ArrayList<Pair<BooleanFunction<ClassNode>, TopToBottomTreeStructure.NodeData>> result = new ArrayList<Pair<BooleanFunction<ClassNode>, TopToBottomTreeStructure.NodeData>>();
        if (parentData instanceof MyNodeData) {
            result.add(new Pair(memberFunction, null));
            return result;
        }
        final HashSet<ClassNode> globalClasses = new HashSet<ClassNode>();
        HashSet<String> moduleNamesSet = new HashSet<String>();
        for (int i = 0; i < dataGraph.V(); ++i) {
            ClassNode classNode = dataGraph.getNode(i);
            if (!memberFunction.fun((Object)classNode)) continue;
            if (classNode.module != null) {
                moduleNamesSet.add(classNode.module.getName());
                continue;
            }
            globalClasses.add(classNode);
        }
        Object[] moduleNames = ArrayUtil.toStringArray(moduleNamesSet);
        Arrays.sort(moduleNames);
        for (Object moduleName : moduleNames) {
            result.add((Pair<BooleanFunction<ClassNode>, TopToBottomTreeStructure.NodeData>)new Pair(new And<ClassNode>(memberFunction, new BooleanFunction<ClassNode>((String)moduleName){
                final /* synthetic */ String val$moduleName;
                {
                    this.val$moduleName = string;
                }

                public boolean fun(ClassNode classNode) {
                    return classNode.getModuleName().equals(this.val$moduleName);
                }
            }), (Object)new MyNodeData((String)moduleName)));
        }
        if (!globalClasses.isEmpty()) {
            result.add((Pair<BooleanFunction<ClassNode>, TopToBottomTreeStructure.NodeData>)new Pair((Object)new BooleanFunction<ClassNode>(){

                public boolean fun(ClassNode classNode) {
                    return globalClasses.contains(classNode);
                }
            }, null));
        }
        return result;
    }

    private static class MyNodeData
    extends TopToBottomTreeStructure.NodeData {
        public MyNodeData(String moduleName) {
            super(moduleName, moduleName, AllIcons.Nodes.Module);
        }
    }
}

