/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dsm.ui;

import com.intellij.dsm.DsmBundle;
import com.intellij.dsm.ui.DsmTableConstants;
import com.intellij.dsm.ui.DsmTableUtil;
import com.intellij.ide.ui.UISettings;
import com.intellij.ui.ColorUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;

public class DsmLegend
extends JComponent {
    @NonNls
    private static final String DEPS = DsmBundle.message("legend.deps", new Object[0]);
    @NonNls
    private static final String CYCLES = DsmBundle.message("legend.cycles", new Object[0]);
    @NonNls
    private static final String USES = DsmBundle.message("legend.uses", new Object[0]);
    private final JComponent myFocusComponent;

    public DsmLegend(JComponent focusComponent) {
        this.myFocusComponent = focusComponent;
        this.setFocusable(false);
    }

    @Override
    public void paintComponent(Graphics g) {
        UISettings.setupAntialiasing((Graphics)g);
        FontMetrics metrics = this.getFontMetrics(this.getFont());
        g.setColor(DsmTableConstants.COLOR_DEP);
        int x = 40;
        g.fillRect(x, 6, 14, 14);
        g.setColor(ColorUtil.toAlpha((Color)DsmTableConstants.COLOR_DEP, (int)DsmTableUtil.calculateAlpha(6)));
        g.fillRect(x += 16, 6, 14, 14);
        g.setColor(ColorUtil.toAlpha((Color)DsmTableConstants.COLOR_DEP, (int)DsmTableUtil.calculateAlpha(2)));
        g.fillRect(x += 16, 6, 14, 14);
        g.setColor(this.getForeground());
        g.drawString(DEPS, x += 17, 18);
        g.setColor(DsmTableConstants.COLOR_CYCLE);
        g.fillRect(x += metrics.stringWidth(DEPS) + 22, 6, 14, 14);
        g.setColor(ColorUtil.toAlpha((Color)DsmTableConstants.COLOR_CYCLE, (int)DsmTableUtil.calculateAlpha(4)));
        g.fillRect(x += 16, 6, 14, 14);
        g.setColor(this.getForeground());
        g.drawString(CYCLES, x += 17, 18);
        g.setColor(DsmTableConstants.COLOR_FWD_DEP);
        g.fillRect(x += metrics.stringWidth(CYCLES) + 22, 6, 14, 14);
        x += 17;
        x = this.drawUses(g, metrics, x);
        g.drawPolyline(new int[]{x + 2, x, x, x + 2}, new int[]{4, 4, 21, 21}, 4);
        g.setColor(UIUtil.getTreeSelectionBackground((boolean)this.myFocusComponent.hasFocus()));
        g.fillRect(x += 3, 6, 14, 14);
        g.setColor(this.getForeground());
        g.drawPolyline(new int[]{x += 14, x + 2, x + 2, x}, new int[]{4, 4, 21, 21}, 4);
        x += 6;
        x = this.drawUses(g, metrics, x);
        g.setColor(DsmTableConstants.COLOR_BCK_DEP);
        g.fillRect(x, 6, 14, 14);
    }

    private int drawUses(Graphics g, FontMetrics metrics, int x) {
        g.setColor(this.getForeground());
        g.drawLine(x, 13, x + 5, 13);
        g.drawString(USES, x += 7, 17);
        DsmLegend.drawArrow(g, (x += metrics.stringWidth(USES)) + 1, 13, x + 12, 13);
        return x + 16;
    }

    private static void drawArrow(Graphics g1, int sourceX, int sourceY, int targetX, int targetY) {
        Graphics2D g = (Graphics2D)g1.create();
        double dx = targetX - sourceX;
        double dy = targetY - sourceY;
        double angle = Math.atan2(dy, dx);
        int len = (int)Math.sqrt(dx * dx + dy * dy);
        AffineTransform t = AffineTransform.getTranslateInstance(sourceX, sourceY);
        t.concatenate(AffineTransform.getRotateInstance(angle));
        g.transform(t);
        g.drawLine(0, 0, len - 8, 0);
        g.fillPolygon(new int[]{len, len - 8, len - 8, len}, new int[]{0, -4, 4, 0}, 4);
    }

    @Override
    public Dimension getPreferredSize() {
        return JBUI.size((int)400, (int)20);
    }
}

