/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ognl;

import com.intellij.lang.Language;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.lang.ognl.OgnlLanguage;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiLanguageInjectionHost;

public class OgnlLanguageInjector {
    private final MultiHostRegistrar registrar;
    private final PsiLanguageInjectionHost element;
    private boolean addPrefixSuffix;

    private OgnlLanguageInjector(MultiHostRegistrar registrar, PsiLanguageInjectionHost element) {
        this.registrar = registrar;
        this.element = element;
    }

    public OgnlLanguageInjector addPrefixSuffix() {
        this.addPrefixSuffix = true;
        return this;
    }

    public static void injectElementWithPrefixSuffix(MultiHostRegistrar registrar, PsiLanguageInjectionHost element) {
        new OgnlLanguageInjector(registrar, element).addPrefixSuffix().injectWholeXmlAttributeValue();
    }

    public static void injectOccurrences(MultiHostRegistrar registrar, PsiLanguageInjectionHost element) {
        new OgnlLanguageInjector(registrar, element).injectOccurrences();
    }

    private void injectWholeXmlAttributeValue() {
        int textLength = this.element.getTextLength();
        if (textLength < 2) {
            return;
        }
        TextRange range = new TextRange(1, textLength - 1);
        this.registrar.startInjecting((Language)OgnlLanguage.INSTANCE).addPlace(this.addPrefixSuffix ? "%{" : null, this.addPrefixSuffix ? "}" : null, this.element, range).doneInjecting();
    }

    private void injectOccurrences() {
        int length;
        this.registrar.startInjecting((Language)OgnlLanguage.INSTANCE);
        String text = this.element.getText();
        int textLength = text.length() - 1;
        int lastStartPosition = Math.max(textLength, text.lastIndexOf("}"));
        for (int startOffset = 0; startOffset < lastStartPosition && (startOffset = text.indexOf("%{", startOffset)) != -1; startOffset += length) {
            int nextStartOffset = text.indexOf("%{", startOffset + "%{".length());
            int searchClosingBraceIdx = nextStartOffset != -1 ? nextStartOffset : textLength;
            int closingBraceIdx = text.lastIndexOf("}", searchClosingBraceIdx);
            length = (closingBraceIdx != -1 && closingBraceIdx > nextStartOffset ? closingBraceIdx + 1 : textLength) - startOffset;
            TextRange range = TextRange.from((int)startOffset, (int)length);
            this.registrar.addPlace(null, null, this.element, range);
        }
        this.registrar.doneInjecting();
    }
}

