/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ognl;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.lang.ognl.OgnlFileType;
import com.intellij.lang.ognl.OgnlLanguage;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import org.jetbrains.annotations.NotNull;

public class OgnlTypedHandler
extends TypedHandlerDelegate {
    public TypedHandlerDelegate.Result charTyped(char c, Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        int offset;
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/lang/ognl/OgnlTypedHandler", "charTyped"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/ognl/OgnlTypedHandler", "charTyped"));
        }
        if (c != '{') {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        if (!CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        if (file.getFileType() != OgnlFileType.INSTANCE) {
            PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
            offset = editor.getCaretModel().getOffset();
            PsiElement elementAtCursor = InjectedLanguageUtil.findElementAtNoCommit((PsiFile)file, (int)offset);
            if (elementAtCursor == null) {
                return TypedHandlerDelegate.Result.CONTINUE;
            }
            if (elementAtCursor.getLanguage() != OgnlLanguage.INSTANCE) {
                return TypedHandlerDelegate.Result.CONTINUE;
            }
        }
        if ((offset = editor.getCaretModel().getOffset()) < "%{".length()) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        if (this.handleExpressionPrefix(editor, offset)) {
            return TypedHandlerDelegate.Result.STOP;
        }
        if (this.handleOpeningBrace(editor, offset)) {
            return TypedHandlerDelegate.Result.STOP;
        }
        return TypedHandlerDelegate.Result.CONTINUE;
    }

    private boolean handleExpressionPrefix(Editor editor, int offset) {
        CharSequence sequence = editor.getDocument().getCharsSequence();
        CharSequence before = sequence.subSequence(offset - "%{".length(), offset);
        if (!"%{".equals(before.toString())) {
            return false;
        }
        editor.getDocument().insertString(offset, (CharSequence)"}");
        return true;
    }

    private boolean handleOpeningBrace(Editor editor, int offset) {
        if (offset < "%{".length()) {
            return false;
        }
        editor.getDocument().insertString(editor.getCaretModel().getOffset(), (CharSequence)"}");
        return true;
    }
}

