/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ognl.psi.impl;

import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ognl.psi.impl.OgnlExpressionImpl;
import com.intellij.lang.ognl.psi.resolve.OgnlResolveUtil;
import com.intellij.lang.ognl.psi.resolve.variable.OgnlVariableReference;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class OgnlVariableExpressionBase
extends OgnlExpressionImpl {
    protected OgnlVariableExpressionBase(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/ognl/psi/impl/OgnlVariableExpressionBase", "<init>"));
        }
        super(node);
    }

    @Nullable
    public PsiReference getReference() {
        return new OgnlVariableReferencePsiReference(this);
    }

    private static class OgnlVariableReferencePsiReference
    extends PsiReferenceBase.Poly<PsiElement> {
        private static final Function<OgnlVariableReference, PsiElementResolveResult> RESOLVE_FUNCTION = new Function<OgnlVariableReference, PsiElementResolveResult>(){

            public PsiElementResolveResult fun(OgnlVariableReference reference) {
                return new PsiElementResolveResult(reference.getNavigationElement());
            }
        };
        private static final Function<OgnlVariableReference, Object> VARIANT_FUNCTION = new Function<OgnlVariableReference, Object>(){

            public Object fun(OgnlVariableReference element) {
                return LookupElementBuilder.create((Object)element.getNavigationElement(), (String)element.getName()).withIcon(element.getIcon(0)).withTailText(" (" + element.getOriginInfo() + ")", true).withTypeText(element.getType().getPresentableText());
            }
        };

        private OgnlVariableReferencePsiReference(OgnlVariableExpressionBase element) {
            super((PsiElement)element, TextRange.from((int)1, (int)(element.getTextLength() - 1)), true);
        }

        @NotNull
        public ResolveResult[] multiResolve(boolean incompleteCode) {
            final String name = this.getValue();
            CommonProcessors.CollectProcessor<OgnlVariableReference> processor = new CommonProcessors.CollectProcessor<OgnlVariableReference>(){

                protected boolean accept(OgnlVariableReference reference) {
                    return reference.getName().equals(name);
                }
            };
            OgnlResolveUtil.processVariables(this.getElement(), (Processor<OgnlVariableReference>)processor);
            ResolveResult[] resolveResultArray = (ResolveResult[])ContainerUtil.map2Array((Collection)processor.getResults(), PsiElementResolveResult.class, RESOLVE_FUNCTION);
            if (resolveResultArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ognl/psi/impl/OgnlVariableExpressionBase$OgnlVariableReferencePsiReference", "multiResolve"));
            }
            return resolveResultArray;
        }

        @NotNull
        public Object[] getVariants() {
            CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor();
            OgnlResolveUtil.processVariables(this.getElement(), (Processor<OgnlVariableReference>)processor);
            Object[] objectArray = ContainerUtil.map2Array((Collection)processor.getResults(), VARIANT_FUNCTION);
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ognl/psi/impl/OgnlVariableExpressionBase$OgnlVariableReferencePsiReference", "getVariants"));
            }
            return objectArray;
        }
    }
}

