/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css3;

import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssLength;
import org.w3c.css.values.CssPercentage;
import org.w3c.css.values.CssValue;

public class CssFlexBasis
extends org.w3c.css.properties.css.CssFlexBasis {
    public static final CssIdent auto = CssIdent.getIdent("auto");

    public static final CssIdent getAllowedIdent(CssIdent ident) {
        if (auto.equals(ident)) {
            return auto;
        }
        return null;
    }

    public CssFlexBasis() {
        this.value = initial;
    }

    public CssFlexBasis(ApplContext ac, CssExpression expression, boolean check2) throws InvalidParamException {
        if (check2 && expression.getCount() > 1) {
            throw new InvalidParamException("unrecognize", ac);
        }
        CssValue val = expression.getValue();
        this.setByUser();
        switch (val.getType()) {
            case 0: {
                CssIdent ident = (CssIdent)val;
                if (inherit.equals(val)) {
                    this.value = inherit;
                    break;
                }
                if (auto.equals(val)) {
                    this.value = auto;
                    break;
                }
                throw new InvalidParamException("unrecognize", ac);
            }
            case 5: 
            case 6: {
                CssLength l = val.getLength();
                l.checkPositiveness(ac, this);
                this.value = l;
                break;
            }
            case 4: {
                CssPercentage p = val.getPercentage();
                p.checkPositiveness(ac, this);
                this.value = p;
                break;
            }
            default: {
                throw new InvalidParamException("value", val, this.getPropertyName(), ac);
            }
        }
        expression.next();
    }

    public CssFlexBasis(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    @Override
    public boolean isDefault() {
        return this.value == auto || this.value == initial;
    }
}

