/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.flex;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.javascript.flex.FlexApplicationComponent;
import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.BasicAttributeValueReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileBasedUserDataCache;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.text.StringTokenizer;
import com.intellij.xml.util.XmlTagUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlexReferenceContributor {
    static final String TRANSITION_TAG_NAME = "Transition";
    public static final String SOURCE_ATTR_NAME = "source";
    public static final String DESTINATION_ATTR_NAME = "destination";
    static final String DELIMS = ", ";
    public static final String CLASS_REFERENCE = "ClassReference";

    public static boolean isClassReferenceType(String type) {
        return "Class".equals(type) || "mx.core.IFactory".equals(type);
    }

    public static class StateReference
    extends BasicAttributeValueReference
    implements EmptyResolveMessageProvider,
    PsiPolyVariantReference {
        private static final String DUMMY_STATE_GROUP_TAG = "DummyStateGroupTag";
        private static FileBasedUserDataCache<Map<String, XmlTag>> statesCache = new FileBasedUserDataCache<Map<String, XmlTag>>(){
            public Key<CachedValue<Map<String, XmlTag>>> ourDataKey = Key.create((String)"mx.states");

            protected Map<String, XmlTag> doCompute(PsiFile file) {
                THashMap tags = new THashMap();
                file.getOriginalFile().accept((PsiElementVisitor)new XmlRecursiveElementVisitor((Map)tags){
                    final /* synthetic */ Map val$tags;
                    {
                        this.val$tags = map;
                    }

                    public void visitXmlTag(XmlTag tag) {
                        super.visitXmlTag(tag);
                        if ("State".equals(tag.getLocalName())) {
                            String groups;
                            String name = tag.getAttributeValue("name");
                            if (name != null) {
                                this.val$tags.put(name, tag);
                            }
                            if ((groups = tag.getAttributeValue("stateGroups")) != null) {
                                StringTokenizer tokenizer = new StringTokenizer(groups, FlexReferenceContributor.DELIMS);
                                while (tokenizer.hasMoreElements()) {
                                    String s = tokenizer.nextElement();
                                    XmlTag cachedTag = (XmlTag)this.val$tags.get(s);
                                    if (cachedTag != null) continue;
                                    PsiFile fromText = PsiFileFactory.getInstance((Project)tag.getProject()).createFileFromText("dummy.mxml", (FileType)FlexApplicationComponent.MXML, (CharSequence)("<DummyStateGroupTag name=\"" + s + "\" />"));
                                    cachedTag = ((XmlFile)fromText).getDocument().getRootTag();
                                    this.val$tags.put(s, cachedTag);
                                }
                            }
                        }
                    }
                });
                return tags;
            }

            protected Key<CachedValue<Map<String, XmlTag>>> getKey() {
                return this.ourDataKey;
            }
        };
        private final boolean myStateGroupsOnly;

        public StateReference(PsiElement element) {
            super(element);
            this.myStateGroupsOnly = false;
        }

        public StateReference(PsiElement element, TextRange range) {
            this(element, range, false);
        }

        public StateReference(PsiElement element, TextRange range, boolean stateGroupsOnly) {
            super(element, range);
            this.myStateGroupsOnly = stateGroupsOnly;
        }

        public PsiElement resolve() {
            ResolveResult[] results = this.multiResolve(false);
            return results.length == 1 ? results[0].getElement() : null;
        }

        @NotNull
        public ResolveResult[] multiResolve(boolean incompleteCode) {
            final ArrayList result = new ArrayList(1);
            this.process(new StateProcessor(){

                @Override
                public boolean process(final @NotNull XmlTag t, @NotNull String name) {
                    if (t == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/javascript/flex/FlexReferenceContributor$StateReference$2", "process"));
                    }
                    if (name == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/javascript/flex/FlexReferenceContributor$StateReference$2", "process"));
                    }
                    result.add(new ResolveResult(){

                        public PsiElement getElement() {
                            return t.getAttribute("name").getValueElement();
                        }

                        public boolean isValidResult() {
                            return true;
                        }
                    });
                    return true;
                }

                @Override
                public String getHint() {
                    return StateReference.this.getCanonicalText();
                }
            });
            ResolveResult[] resolveResultArray = result.toArray(new ResolveResult[result.size()]);
            if (resolveResultArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/FlexReferenceContributor$StateReference", "multiResolve"));
            }
            return resolveResultArray;
        }

        @NotNull
        public Object[] getVariants() {
            PsiElement tag;
            THashSet list = new THashSet();
            this.process(new StateProcessor((Set)list){
                final /* synthetic */ Set val$list;
                {
                    this.val$list = set;
                }

                @Override
                public boolean process(@NotNull XmlTag t, @NotNull String name) {
                    if (t == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/javascript/flex/FlexReferenceContributor$StateReference$3", "process"));
                    }
                    if (name == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/javascript/flex/FlexReferenceContributor$StateReference$3", "process"));
                    }
                    this.val$list.add(name);
                    return true;
                }

                @Override
                public String getHint() {
                    return null;
                }
            });
            PsiElement parent = this.myElement instanceof XmlAttributeValue ? this.myElement.getParent() : null;
            PsiElement psiElement = tag = parent instanceof XmlAttribute ? parent.getParent() : null;
            if (tag instanceof XmlTag && FlexReferenceContributor.TRANSITION_TAG_NAME.equals(((XmlTag)tag).getLocalName())) {
                list.add("*");
            }
            Object[] objectArray = ArrayUtil.toObjectArray((Collection)list);
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/FlexReferenceContributor$StateReference", "getVariants"));
            }
            return objectArray;
        }

        public boolean isReferenceTo(PsiElement element) {
            for (ResolveResult r : this.multiResolve(false)) {
                if (!this.myElement.getManager().areElementsEquivalent(element, r.getElement())) continue;
                return true;
            }
            return false;
        }

        private boolean process(StateProcessor processor) {
            String s = processor.getHint();
            Map map = (Map)statesCache.compute(this.getElement().getContainingFile());
            if (s == null) {
                for (Map.Entry t : map.entrySet()) {
                    XmlTag tag = (XmlTag)t.getValue();
                    if (this.myStateGroupsOnly && !DUMMY_STATE_GROUP_TAG.equals(tag.getName()) || processor.process(tag, (String)t.getKey())) continue;
                    return false;
                }
            } else {
                XmlTag tag = (XmlTag)map.get(s);
                if (this.myStateGroupsOnly && !DUMMY_STATE_GROUP_TAG.equals(tag.getName())) {
                    return true;
                }
                if (tag != null) {
                    return processor.process(tag, s);
                }
            }
            return true;
        }

        public boolean isSoft() {
            return false;
        }

        @NotNull
        public String getUnresolvedMessagePattern() {
            String string = FlexBundle.message("cannot.resolve.state", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/FlexReferenceContributor$StateReference", "getUnresolvedMessagePattern"));
            }
            return string;
        }

        public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
            if (this.myElement instanceof XmlTag) {
                XmlToken startTagNameElement = XmlTagUtil.getStartTagNameElement((XmlTag)((XmlTag)this.myElement));
                if (startTagNameElement != null) {
                    TextRange rangeInTagNameElement = this.myRange.shiftRight(-(startTagNameElement.getTextOffset() - this.myElement.getTextOffset()));
                    TextRange startTagNameElementRange = startTagNameElement.getTextRange().shiftRight(-this.myElement.getTextRange().getStartOffset());
                    if (startTagNameElementRange.contains(rangeInTagNameElement)) {
                        StringBuilder newName = new StringBuilder(startTagNameElement.getText());
                        newName.replace(rangeInTagNameElement.getStartOffset(), rangeInTagNameElement.getEndOffset(), newElementName);
                        ((XmlTag)this.myElement).setName(newName.toString());
                    }
                }
                return this.myElement;
            }
            return super.handleElementRename(newElementName);
        }

        static interface StateProcessor {
            public boolean process(@NotNull XmlTag var1, @NotNull String var2);

            @Nullable
            public String getHint();
        }
    }
}

