/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.flex;

import com.intellij.lang.javascript.findUsages.SuperMethodUtil;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.refactoring.RenameMoveUtils;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.SearchScope;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlexRenameHandler
extends RenamePsiElementProcessor {
    public boolean canProcessElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/javascript/flex/FlexRenameHandler", "canProcessElement"));
        }
        return (element instanceof JSFunction || element instanceof JSFile) && JSResolveUtil.isActionScript((PsiFile)element.getContainingFile());
    }

    public void renameElement(PsiElement element, String newName, UsageInfo[] usages, @Nullable RefactoringElementListener listener) throws IncorrectOperationException {
        PsiFile file;
        super.renameElement(element, newName, usages, listener);
        if (element instanceof JSFile && (file = element.getManager().findFile(element.getContainingFile().getVirtualFile())) instanceof JSFile) {
            RenameMoveUtils.updateFileWithChangedName((JSFile)((JSFile)file));
        }
    }

    public PsiElement substituteElementToRename(PsiElement element, Editor editor) {
        if (element instanceof JSFunction) {
            return SuperMethodUtil.checkSuperMethod((JSFunction)((JSFunction)element), (String)RefactoringBundle.message((String)"rename.title"), (String)RefactoringBundle.message((String)"to.rename"));
        }
        return super.substituteElementToRename(element, editor);
    }

    public void prepareRenaming(PsiElement element, final String newName, final Map<PsiElement, String> allRenames, SearchScope scope) {
        if (!(element instanceof JSFunction)) {
            return;
        }
        JSInheritanceUtil.iterateMethodsDown((JSFunction)((JSFunction)element), (Processor)new Processor<JSFunction>(){

            public synchronized boolean process(JSFunction jsFunction) {
                allRenames.put(jsFunction, newName);
                return true;
            }
        }, (boolean)true);
    }
}

