/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.flex.css;

import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.javascript.flex.css.FlexCssColorValue;
import com.intellij.javascript.flex.css.FlexCssPropertyValue;
import com.intellij.javascript.flex.css.FlexCssUtil;
import com.intellij.javascript.flex.css.FlexStringPropertyValue;
import com.intellij.javascript.flex.css.FlexStyleIndexInfo;
import com.intellij.javascript.flex.resolve.ActionScriptClassResolver;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.lang.javascript.flex.FlexUtils;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.ecmal4.JSAttribute;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeNameValuePair;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSQualifiedElementIndex;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssPropertyValue;
import com.intellij.psi.css.CssTermType;
import com.intellij.psi.css.descriptor.BrowserVersion;
import com.intellij.psi.css.descriptor.CssContextType;
import com.intellij.psi.css.descriptor.CssElementDescriptor;
import com.intellij.psi.css.descriptor.value.CssValueDescriptor;
import com.intellij.psi.css.impl.CssTermTypes;
import com.intellij.psi.css.impl.descriptor.CssCommonDescriptorData;
import com.intellij.psi.css.impl.descriptor.value.CssColorValue;
import com.intellij.psi.css.impl.descriptor.value.CssGroupValue;
import com.intellij.psi.css.impl.descriptor.value.CssLengthValue;
import com.intellij.psi.css.impl.descriptor.value.CssNumberValue;
import com.intellij.psi.css.impl.descriptor.value.CssValueDescriptorData;
import com.intellij.psi.css.impl.util.completion.CssUserLookupBase;
import com.intellij.psi.css.impl.util.completion.LengthUserLookup;
import com.intellij.psi.css.impl.util.scheme.CssElementDescriptorFactory2;
import com.intellij.psi.css.impl.util.scheme.CssValueDescriptorModificator;
import com.intellij.psi.css.impl.util.table.AbstractCssPropertyDescriptor;
import com.intellij.psi.css.impl.util.table.CssLookupValue;
import com.intellij.psi.css.impl.util.table.CssPropertyValueImpl;
import com.intellij.psi.css.impl.util.table.CssTableValue;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlexCssPropertyDescriptor
extends AbstractCssPropertyDescriptor {
    @NotNull
    private final String myInherit;
    private final boolean myShorthand;
    @NotNull
    private final String myPropertyName;
    @NotNull
    private final CssPropertyValue myValue;
    @NotNull
    private final Set<String> myClassNames;
    @NotNull
    private final Set<String> myFileNames;
    private final FlexStyleIndexInfo myStyleInfo;
    public static final String COLOR_FORMAT = "Color";
    private static final String LENGTH_FORMAT = "Length";
    @NotNull
    private final CssValueDescriptor myValueDescriptor;

    public FlexCssPropertyDescriptor(@NotNull Collection<FlexStyleIndexInfo> infos) {
        FlexStyleIndexInfo firstInfo;
        if (infos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "infos", "com/intellij/javascript/flex/css/FlexCssPropertyDescriptor", "<init>"));
        }
        this.myStyleInfo = firstInfo = infos.iterator().next();
        this.myPropertyName = firstInfo.getAttributeName();
        this.myInherit = firstInfo.getInherit();
        this.myShorthand = FlexCssPropertyDescriptor.containsShorthand(infos);
        this.myValue = FlexCssPropertyDescriptor.createPropertyValue(infos, this.myShorthand);
        this.myValueDescriptor = FlexCssPropertyDescriptor.createPropertyValueDescriptor(infos, this.myShorthand);
        this.myClassNames = ContainerUtil.newLinkedHashSet();
        this.myFileNames = ContainerUtil.newLinkedHashSet();
        for (FlexStyleIndexInfo info : infos) {
            if (info.isInClass()) {
                this.myClassNames.add(info.getClassOrFileName());
                continue;
            }
            this.myFileNames.add(info.getClassOrFileName());
        }
    }

    private static boolean containsShorthand(@NotNull Collection<FlexStyleIndexInfo> infos) {
        if (infos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "infos", "com/intellij/javascript/flex/css/FlexCssPropertyDescriptor", "containsShorthand"));
        }
        for (FlexStyleIndexInfo info : infos) {
            if (!FlexCssPropertyDescriptor.isShorthand(info)) continue;
            return true;
        }
        return false;
    }

    private static boolean isShorthand(@NotNull FlexStyleIndexInfo info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/javascript/flex/css/FlexCssPropertyDescriptor", "isShorthand"));
        }
        return "Array".equals(info.getType());
    }

    private static void addValuesFromEnumerations2(@NotNull Collection<FlexStyleIndexInfo> infos, @NotNull Collection<CssValueDescriptor> children) {
        if (infos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "infos", "com/intellij/javascript/flex/css/FlexCssPropertyDescriptor", "addValuesFromEnumerations2"));
        }
        if (children == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "children", "com/intellij/javascript/flex/css/FlexCssPropertyDescriptor", "addValuesFromEnumerations2"));
        }
        LinkedHashSet constantSet = ContainerUtil.newLinkedHashSet();
        for (FlexStyleIndexInfo info : infos) {
            String enumeration = info.getEnumeration();
            if (enumeration == null) continue;
            String[] constants = enumeration.split(",");
            Collections.addAll(constantSet, constants);
        }
        if (constantSet.size() > 0) {
            for (String constant : constantSet) {
                children.add((CssValueDescriptor)CssElementDescriptorFactory2.getInstance().createNameValueDescriptor(constant.trim(), 1, 1, null));
            }
        }
    }

    private static void addValuesFromEnumerations(@NotNull Collection<FlexStyleIndexInfo> infos, @NotNull Collection<CssPropertyValue> children) {
        if (infos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "infos", "com/intellij/javascript/flex/css/FlexCssPropertyDescriptor", "addValuesFromEnumerations"));
        }
        if (children == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "children", "com/intellij/javascript/flex/css/FlexCssPropertyDescriptor", "addValuesFromEnumerations"));
        }
        LinkedHashSet constantSet = ContainerUtil.newLinkedHashSet();
        for (FlexStyleIndexInfo info : infos) {
            String enumeration = info.getEnumeration();
            if (enumeration == null) continue;
            String[] constants = enumeration.split(",");
            Collections.addAll(constantSet, constants);
        }
        if (constantSet.size() > 0) {
            for (String constant : constantSet) {
                children.add((CssPropertyValue)new FlexCssPropertyValue(constant.trim()));
            }
        }
    }

    @NotNull
    public FlexStyleIndexInfo getStyleInfo() {
        FlexStyleIndexInfo flexStyleIndexInfo = this.myStyleInfo;
        if (flexStyleIndexInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/css/FlexCssPropertyDescriptor", "getStyleInfo"));
        }
        return flexStyleIndexInfo;
    }

    @NotNull
    private static Set<String> addValuesFromFormats(@NotNull List<CssValueDescriptor> children, @NotNull Collection<FlexStyleIndexInfo> infos) {
        if (children == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "children", "com/intellij/javascript/flex/css/FlexCssPropertyDescriptor", "addValuesFromFormats"));
        }
        if (infos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "infos", "com/intellij/javascript/flex/css/FlexCssPropertyDescriptor", "addValuesFromFormats"));
        }
        LinkedHashSet formats = ContainerUtil.newLinkedHashSet();
        for (FlexStyleIndexInfo info : infos) {
            ContainerUtil.addIfNotNull((Object)info.getFormat(), (Collection)formats);
        }
        if (formats.contains(COLOR_FORMAT)) {
            children.add((CssValueDescriptor)FlexCssPropertyDescriptor.createCssColorValue());
        }
        if (formats.contains(LENGTH_FORMAT)) {
            children.add((CssValueDescriptor)FlexCssPropertyDescriptor.createCssLengthValue());
        }
        LinkedHashSet linkedHashSet = formats;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/css/FlexCssPropertyDescriptor", "addValuesFromFormats"));
        }
        return linkedHashSet;
    }

    @NotNull
    private static Set<String> addValuesFromFormats(@NotNull Collection<FlexStyleIndexInfo> infos, @NotNull List<CssPropertyValue> children) {
        if (infos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "infos", "com/intellij/javascript/flex/css/FlexCssPropertyDescriptor", "addValuesFromFormats"));
        }
        if (children == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "children", "com/intellij/javascript/flex/css/FlexCssPropertyDescriptor", "addValuesFromFormats"));
        }
        LinkedHashSet formats = ContainerUtil.newLinkedHashSet();
        for (FlexStyleIndexInfo info : infos) {
            String format = info.getFormat();
            if (format == null) continue;
            formats.add(format);
        }
        if (formats.contains(COLOR_FORMAT)) {
            children.add((CssPropertyValue)new FlexCssColorValue());
        }
        if (formats.contains(LENGTH_FORMAT)) {
            children.add((CssPropertyValue)new CssLookupValue((CssUserLookupBase)new LengthUserLookup(), new CssTermType[]{CssTermTypes.LENGTH, CssTermTypes.NUMBER, CssTermTypes.NEGATIVE_NUMBER, CssTermTypes.NEGATIVE_LENGTH}));
        }
        LinkedHashSet linkedHashSet = formats;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/css/FlexCssPropertyDescriptor", "addValuesFromFormats"));
        }
        return linkedHashSet;
    }

    private static void addValuesFromTypes2(@NotNull Collection<FlexStyleIndexInfo> infos, @NotNull Set<String> formats, @NotNull List<CssValueDescriptor> children) {
        if (infos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "infos", "com/intellij/javascript/flex/css/FlexCssPropertyDescriptor", "addValuesFromTypes2"));
        }
        if (formats == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formats", "com/intellij/javascript/flex/css/FlexCssPropertyDescriptor", "addValuesFromTypes2"));
        }
        if (children == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "children", "com/intellij/javascript/flex/css/FlexCssPropertyDescriptor", "addValuesFromTypes2"));
        }
        HashSet types = ContainerUtil.newHashSet();
        for (FlexStyleIndexInfo info : infos) {
            ContainerUtil.addIfNotNull((Object)info.getType(), (Collection)types);
        }
        if (types.contains("Number") && !formats.contains(LENGTH_FORMAT)) {
            children.add((CssValueDescriptor)FlexCssPropertyDescriptor.createCssNumberValue());
        }
        if (types.contains("Class")) {
            children.add((CssValueDescriptor)CssElementDescriptorFactory2.getInstance().createFunctionInvocationValueDescriptor("ClassReference", 1, 1, null));
        }
    }

    private static void addValuesFromTypes(@NotNull Collection<FlexStyleIndexInfo> infos, @NotNull Set<String> formats, @NotNull List<CssPropertyValue> children) {
        if (infos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "infos", "com/intellij/javascript/flex/css/FlexCssPropertyDescriptor", "addValuesFromTypes"));
        }
        if (formats == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formats", "com/intellij/javascript/flex/css/FlexCssPropertyDescriptor", "addValuesFromTypes"));
        }
        if (children == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "children", "com/intellij/javascript/flex/css/FlexCssPropertyDescriptor", "addValuesFromTypes"));
        }
        LinkedHashSet types = ContainerUtil.newLinkedHashSet();
        for (FlexStyleIndexInfo info : infos) {
            String type = info.getType();
            if (type == null) continue;
            types.add(type);
        }
        if (types.contains("Number") && !formats.contains(LENGTH_FORMAT)) {
            children.add((CssPropertyValue)new CssLookupValue(CssTableValue.Type.OR, new CssTermType[]{CssTermTypes.NUMBER, CssTermTypes.NEGATIVE_NUMBER}));
        }
    }

    @NotNull
    private static CssValueDescriptor createPropertyValueDescriptor(@NotNull Collection<FlexStyleIndexInfo> infos, boolean shorthand) {
        if (infos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "infos", "com/intellij/javascript/flex/css/FlexCssPropertyDescriptor", "createPropertyValueDescriptor"));
        }
        ArrayList children = ContainerUtil.newArrayList();
        Set<String> formats = FlexCssPropertyDescriptor.addValuesFromFormats(children, infos);
        FlexCssPropertyDescriptor.addValuesFromEnumerations2(infos, children);
        FlexCssPropertyDescriptor.addValuesFromTypes2(infos, formats, children);
        CssGroupValue result = CssElementDescriptorFactory2.getInstance().createGroupValue(CssGroupValue.Type.OR, -1, 1, null, null);
        if (!children.isEmpty()) {
            for (CssValueDescriptor child : children) {
                result.addChild(CssValueDescriptorModificator.withParent((CssValueDescriptor)child, (CssValueDescriptor)result));
            }
            if (!formats.contains(COLOR_FORMAT)) {
                result.addChild((CssValueDescriptor)CssElementDescriptorFactory2.getInstance().createStringValueDescriptor(null, 1, 1, (CssValueDescriptor)result));
            }
        } else {
            result.addChild((CssValueDescriptor)CssElementDescriptorFactory2.getInstance().createAnyValueDescriptor(1, 1, (CssValueDescriptor)result));
        }
        result.addChild((CssValueDescriptor)CssElementDescriptorFactory2.getInstance().createNameValueDescriptor("undefined", 1, 1, (CssValueDescriptor)result));
        result.addChild((CssValueDescriptor)CssElementDescriptorFactory2.getInstance().createFunctionInvocationValueDescriptor("PropertyReference", 1, 1, (CssValueDescriptor)result));
        result.addChild((CssValueDescriptor)CssElementDescriptorFactory2.getInstance().createFunctionInvocationValueDescriptor("Embed", 1, 1, (CssValueDescriptor)result));
        CssGroupValue cssGroupValue = result;
        if (cssGroupValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/css/FlexCssPropertyDescriptor", "createPropertyValueDescriptor"));
        }
        return cssGroupValue;
    }

    private static CssColorValue createCssColorValue() {
        String id = CssBundle.message((String)"color.value.presentable.name", (Object[])new Object[0]);
        CssCommonDescriptorData commonDescriptorData = new CssCommonDescriptorData(id, id, CssContextType.EMPTY_ARRAY, BrowserVersion.EMPTY_ARRAY, CssElementDescriptor.CssVersion.UNKNOWN, null, "");
        CssValueDescriptorData valueDescriptorData = new CssValueDescriptorData(true, 1, 1, null, null, null, null, false);
        return new CssColorValue(commonDescriptorData, valueDescriptorData);
    }

    private static CssLengthValue createCssLengthValue() {
        String id = CssBundle.message((String)"length.value.presentable.name", (Object[])new Object[0]);
        CssCommonDescriptorData commonDescriptorData = new CssCommonDescriptorData(id, id, CssContextType.EMPTY_ARRAY, BrowserVersion.EMPTY_ARRAY, CssElementDescriptor.CssVersion.UNKNOWN, null, "");
        CssValueDescriptorData valueDescriptorData = new CssValueDescriptorData(true, 1, 1, null, null, null, null, false);
        return new CssLengthValue(commonDescriptorData, valueDescriptorData);
    }

    private static CssNumberValue createCssNumberValue() {
        String id = CssBundle.message((String)"number.value.presentable.name", (Object[])new Object[0]);
        CssCommonDescriptorData commonDescriptorData = new CssCommonDescriptorData(id, id, CssContextType.EMPTY_ARRAY, BrowserVersion.EMPTY_ARRAY, CssElementDescriptor.CssVersion.UNKNOWN, null, "");
        CssValueDescriptorData valueDescriptorData = new CssValueDescriptorData(true, 1, 1, null, null, null, null, false);
        return new CssNumberValue(commonDescriptorData, valueDescriptorData);
    }

    @NotNull
    private static CssPropertyValueImpl createPropertyValue(@NotNull Collection<FlexStyleIndexInfo> infos, boolean shorthand) {
        if (infos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "infos", "com/intellij/javascript/flex/css/FlexCssPropertyDescriptor", "createPropertyValue"));
        }
        ArrayList<CssPropertyValue> children = new ArrayList<CssPropertyValue>();
        Set<String> formats = FlexCssPropertyDescriptor.addValuesFromFormats(infos, children);
        FlexCssPropertyDescriptor.addValuesFromEnumerations(infos, children);
        FlexCssPropertyDescriptor.addValuesFromTypes(infos, formats, children);
        FlexCssPropertyValue value = null;
        if (children.size() >= 1) {
            value = new FlexCssPropertyValue(shorthand, false);
            for (CssPropertyValue child : children) {
                value.addChild((CssTableValue)child);
            }
        }
        if (value == null) {
            value = new FlexCssPropertyValue(shorthand, true);
        } else if (!formats.contains(COLOR_FORMAT)) {
            value.addChild((CssTableValue)new FlexStringPropertyValue());
        }
        value.addChild((CssTableValue)new FlexCssPropertyValue("undefined"));
        FlexCssPropertyValue flexCssPropertyValue = value;
        if (flexCssPropertyValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/css/FlexCssPropertyDescriptor", "createPropertyValue"));
        }
        return flexCssPropertyValue;
    }

    @Nullable
    public String getDocumentationString(@Nullable PsiElement context) {
        if (context == null) {
            return null;
        }
        PsiElement[] declarations = this.getDeclarations(context);
        ArrayList<DocumentationElement> docElements = new ArrayList<DocumentationElement>();
        for (PsiElement declaration : declarations) {
            DocumentationProvider provider;
            String docForDeclaration;
            PsiFile file = declaration.getContainingFile();
            if (file == null || (docForDeclaration = (provider = DocumentationManager.getProviderFromElement((PsiElement)declaration)).generateDoc(declaration, declaration)) == null) continue;
            JSClass jsClass = (JSClass)PsiTreeUtil.getParentOfType((PsiElement)declaration, JSClass.class);
            String header = jsClass != null ? jsClass.getQualifiedName() : file.getName();
            docElements.add(new DocumentationElement(header, docForDeclaration));
        }
        Collections.sort(docElements, new Comparator<DocumentationElement>(){

            @Override
            public int compare(@NotNull DocumentationElement e1, @NotNull DocumentationElement e2) {
                if (e1 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e1", "com/intellij/javascript/flex/css/FlexCssPropertyDescriptor$1", "compare"));
                }
                if (e2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e2", "com/intellij/javascript/flex/css/FlexCssPropertyDescriptor$1", "compare"));
                }
                return Comparing.compare((Comparable)((Object)e1.header), (Comparable)((Object)e2.header));
            }
        });
        StringBuilder builder = new StringBuilder();
        int n = docElements.size();
        for (int i = 0; i < n; ++i) {
            DocumentationElement docElement = (DocumentationElement)docElements.get(i);
            builder.append("<b>").append(docElement.header).append("</b>").append("<br>\n");
            builder.append(docElement.documentation);
            if (i == n - 1) continue;
            builder.append("<br><br>\n\n");
        }
        return builder.toString();
    }

    @NotNull
    public CssPropertyValue getValue() {
        CssPropertyValue cssPropertyValue = this.myValue;
        if (cssPropertyValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/css/FlexCssPropertyDescriptor", "getValue"));
        }
        return cssPropertyValue;
    }

    private boolean checkIncludes(JSClass c) {
        LinkedHashSet includes = ContainerUtil.newLinkedHashSet();
        FlexCssUtil.collectAllIncludes((PsiElement)c, includes);
        for (String name : this.myFileNames) {
            if (!includes.contains(name)) continue;
            return true;
        }
        return false;
    }

    private boolean findStyleAttributesInFile(@NotNull JSFile jsFile, @NotNull Set<JSFile> visited, @NotNull Map<PsiElement, PairInfo> navElement2pair) {
        PsiElement navElement;
        if (jsFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsFile", "com/intellij/javascript/flex/css/FlexCssPropertyDescriptor", "findStyleAttributesInFile"));
        }
        if (visited == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visited", "com/intellij/javascript/flex/css/FlexCssPropertyDescriptor", "findStyleAttributesInFile"));
        }
        if (navElement2pair == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "navElement2pair", "com/intellij/javascript/flex/css/FlexCssPropertyDescriptor", "findStyleAttributesInFile"));
        }
        if (!visited.add(jsFile)) {
            return false;
        }
        JSAttributeNameValuePair result = null;
        String fileName = jsFile.getName();
        if (this.myFileNames.contains(fileName)) {
            MyMetaDataProcessor processor = new MyMetaDataProcessor();
            FlexUtils.processMetaAttributesForClass((PsiElement)jsFile, processor);
            result = processor.myResult;
        }
        PsiElement psiElement = navElement = result != null ? result.getNavigationElement() : null;
        if (result != null) {
            navElement2pair.put((PsiElement)(navElement != null ? navElement : result), new PairInfo((PsiElement)result, fileName));
            return true;
        }
        return false;
    }

    private boolean findStyleAttributesInClassOrSuper(@NotNull JSClass c, @NotNull Set<JSClass> visited, @NotNull Map<PsiElement, PairInfo> navElement2pair) {
        PsiElement navElement;
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/javascript/flex/css/FlexCssPropertyDescriptor", "findStyleAttributesInClassOrSuper"));
        }
        if (visited == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visited", "com/intellij/javascript/flex/css/FlexCssPropertyDescriptor", "findStyleAttributesInClassOrSuper"));
        }
        if (navElement2pair == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "navElement2pair", "com/intellij/javascript/flex/css/FlexCssPropertyDescriptor", "findStyleAttributesInClassOrSuper"));
        }
        if (!visited.add(c)) {
            return false;
        }
        JSAttributeNameValuePair result = null;
        String qName = c.getQualifiedName();
        if (this.myClassNames.contains(qName) || this.checkIncludes(c)) {
            MyMetaDataProcessor processor = new MyMetaDataProcessor();
            FlexUtils.processMetaAttributesForClass((PsiElement)c, processor);
            result = processor.myResult;
        }
        PsiElement psiElement = navElement = result != null ? result.getNavigationElement() : null;
        if (result == null || navElement == null) {
            boolean found = false;
            for (JSClass superClass : c.getSupers()) {
                found = found || this.findStyleAttributesInClassOrSuper(superClass, visited, navElement2pair);
            }
            if (found) {
                return true;
            }
        }
        if (result != null) {
            navElement2pair.put((PsiElement)(navElement != null ? navElement : result), new PairInfo((PsiElement)result, qName));
            return true;
        }
        return false;
    }

    private void findStyleAttributes(@NotNull Collection<JSQualifiedNamedElement> elements, @NotNull Set<JSClass> visited, @NotNull Map<PsiElement, PairInfo> navElement2pair) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/javascript/flex/css/FlexCssPropertyDescriptor", "findStyleAttributes"));
        }
        if (visited == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visited", "com/intellij/javascript/flex/css/FlexCssPropertyDescriptor", "findStyleAttributes"));
        }
        if (navElement2pair == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "navElement2pair", "com/intellij/javascript/flex/css/FlexCssPropertyDescriptor", "findStyleAttributes"));
        }
        for (JSQualifiedNamedElement element : elements) {
            if (!(element instanceof JSClass)) continue;
            this.findStyleAttributesInClassOrSuper((JSClass)element, visited, navElement2pair);
        }
    }

    @NotNull
    public PsiElement[] getDeclarations(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/flex/css/FlexCssPropertyDescriptor", "getDeclarations"));
        }
        HashMap navElement2pairInfo = new HashMap();
        final Project project = context.getProject();
        GlobalSearchScope scope = FlexCssUtil.getResolveScope(context);
        LinkedHashSet visited = ContainerUtil.newLinkedHashSet();
        for (String string : this.myClassNames) {
            Collection candidates = StubIndex.getElements((StubIndexKey)JSQualifiedElementIndex.KEY, (Object)string.hashCode(), (Project)project, (GlobalSearchScope)scope, JSQualifiedNamedElement.class);
            this.findStyleAttributes(candidates, visited, (Map<PsiElement, PairInfo>)navElement2pairInfo);
            PsiElement jsClass = ActionScriptClassResolver.findClassByQNameStatic(string, scope);
            if (!(jsClass instanceof JSClass)) continue;
            this.findStyleAttributesInClassOrSuper((JSClass)jsClass, visited, (Map<PsiElement, PairInfo>)navElement2pairInfo);
        }
        LinkedHashSet visitedFiles = ContainerUtil.newLinkedHashSet();
        for (String fileName : this.myFileNames) {
            Collection files = FilenameIndex.getVirtualFilesByName((Project)project, (String)fileName, (GlobalSearchScope)scope);
            Iterator iterator = files.iterator();
            while (iterator.hasNext()) {
                final VirtualFile file = (VirtualFile)iterator.next();
                PsiFile psiFile = (PsiFile)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiFile>(){

                    @Nullable
                    public PsiFile compute() {
                        return PsiManager.getInstance((Project)project).findFile(file);
                    }
                });
                if (!(psiFile instanceof JSFile)) continue;
                this.findStyleAttributesInFile((JSFile)psiFile, visitedFiles, (Map<PsiElement, PairInfo>)navElement2pairInfo);
            }
        }
        Set set = navElement2pairInfo.keySet();
        HashMap qName2ResultElement = new HashMap();
        for (PsiElement navPair : set) {
            PsiElement navPairInOtherClassWithSameQName;
            PairInfo pairInfo = (PairInfo)navElement2pairInfo.get(navPair);
            String jsClassQName = pairInfo.myJsClassQName;
            PsiElement psiElement = navPairInOtherClassWithSameQName = jsClassQName != null ? (PsiElement)qName2ResultElement.get(jsClassQName) : null;
            if (navPairInOtherClassWithSameQName != null && (navPairInOtherClassWithSameQName != navElement2pairInfo.get(navPairInOtherClassWithSameQName) || pairInfo.myPair == navPair)) continue;
            qName2ResultElement.put(jsClassQName, navPair);
        }
        Collection result = qName2ResultElement.values();
        PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(result);
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/css/FlexCssPropertyDescriptor", "getDeclarations"));
        }
        return psiElementArray;
    }

    public boolean isShorthandValue() {
        return this.myShorthand;
    }

    @NotNull
    public String getPropertyName() {
        String string = this.myPropertyName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/css/FlexCssPropertyDescriptor", "getPropertyName"));
        }
        return string;
    }

    public boolean getInherited() {
        return "yes".equalsIgnoreCase(this.myInherit) || "true".equals(this.myInherit);
    }

    @NotNull
    public CssValueDescriptor getValueDescriptor() {
        CssValueDescriptor cssValueDescriptor = this.myValueDescriptor;
        if (cssValueDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/css/FlexCssPropertyDescriptor", "getValueDescriptor"));
        }
        return cssValueDescriptor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FlexCssPropertyDescriptor)) {
            return false;
        }
        FlexCssPropertyDescriptor that = (FlexCssPropertyDescriptor)((Object)o);
        if (this.myShorthand != that.myShorthand) {
            return false;
        }
        if (!this.myClassNames.equals(that.myClassNames)) {
            return false;
        }
        if (!this.myFileNames.equals(that.myFileNames)) {
            return false;
        }
        if (!this.myInherit.equals(that.myInherit)) {
            return false;
        }
        if (!this.myPropertyName.equals(that.myPropertyName)) {
            return false;
        }
        if (!this.myStyleInfo.equals(that.myStyleInfo)) {
            return false;
        }
        if (!this.myValue.equals(that.myValue)) {
            return false;
        }
        return this.myValueDescriptor.equals(that.myValueDescriptor);
    }

    public int hashCode() {
        int result = this.myInherit.hashCode();
        result = 31 * result + (this.myShorthand ? 1 : 0);
        result = 31 * result + this.myPropertyName.hashCode();
        result = 31 * result + this.myValue.hashCode();
        result = 31 * result + this.myValueDescriptor.hashCode();
        result = 31 * result + this.myClassNames.hashCode();
        result = 31 * result + this.myFileNames.hashCode();
        result = 31 * result + this.myStyleInfo.hashCode();
        return result;
    }

    private class MyMetaDataProcessor
    implements JSResolveUtil.MetaDataProcessor {
        private JSAttributeNameValuePair myResult;

        private MyMetaDataProcessor() {
        }

        public boolean process(@NotNull JSAttribute jsAttribute) {
            JSAttributeNameValuePair pair;
            if (jsAttribute == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsAttribute", "com/intellij/javascript/flex/css/FlexCssPropertyDescriptor$MyMetaDataProcessor", "process"));
            }
            if ("Style".equals(jsAttribute.getName()) && (pair = jsAttribute.getValueByName("name")) != null && FlexCssPropertyDescriptor.this.myPropertyName.equals(pair.getSimpleValue())) {
                this.myResult = pair;
                return false;
            }
            return true;
        }

        public boolean handleOtherElement(PsiElement el, PsiElement context, @Nullable Ref<PsiElement> continuePassElement) {
            return true;
        }
    }

    private static class PairInfo {
        final PsiElement myPair;
        final String myJsClassQName;

        private PairInfo(PsiElement pair, String jsClassQName) {
            this.myPair = pair;
            this.myJsClassQName = jsClassQName;
        }
    }

    private static class DocumentationElement {
        String header;
        String documentation;

        private DocumentationElement(@NotNull String header, @NotNull String documentation) {
            if (header == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "header", "com/intellij/javascript/flex/css/FlexCssPropertyDescriptor$DocumentationElement", "<init>"));
            }
            if (documentation == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "documentation", "com/intellij/javascript/flex/css/FlexCssPropertyDescriptor$DocumentationElement", "<init>"));
            }
            this.header = header;
            this.documentation = documentation;
        }
    }
}

