/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.flex.css;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.VfsRootAccess;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.IndexableSetContributor;
import java.net.URL;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class FlexStylesIndexableSetContributor
extends IndexableSetContributor {
    private static final Logger LOG;
    private static final Set<VirtualFile> FILES;

    @NotNull
    public Set<VirtualFile> getAdditionalRootsToIndex() {
        Set<VirtualFile> set = FILES;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/css/FlexStylesIndexableSetContributor", "getAdditionalRootsToIndex"));
        }
        return set;
    }

    public static GlobalSearchScope enlarge(final GlobalSearchScope scope) {
        return scope.union((SearchScope)new GlobalSearchScope(){

            public boolean contains(@NotNull VirtualFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/javascript/flex/css/FlexStylesIndexableSetContributor$1", "contains"));
                }
                return FILES.contains(file);
            }

            public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
                if (file1 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file1", "com/intellij/javascript/flex/css/FlexStylesIndexableSetContributor$1", "compare"));
                }
                if (file2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file2", "com/intellij/javascript/flex/css/FlexStylesIndexableSetContributor$1", "compare"));
                }
                return scope.compare(file1, file2);
            }

            public boolean isSearchInModuleContent(@NotNull Module aModule) {
                if (aModule == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aModule", "com/intellij/javascript/flex/css/FlexStylesIndexableSetContributor$1", "isSearchInModuleContent"));
                }
                return scope.isSearchInModuleContent(aModule);
            }

            public boolean isSearchInLibraries() {
                return scope.isSearchInLibraries();
            }
        });
    }

    static {
        VirtualFile file;
        LOG = Logger.getInstance(FlexStylesIndexableSetContributor.class);
        URL libFileUrl = FlexStylesIndexableSetContributor.class.getResource("FlexStyles.as");
        if ("file".equals(libFileUrl.getProtocol())) {
            VfsRootAccess.allowRootAccess((String[])new String[]{VfsUtilCore.urlToPath((String)VfsUtilCore.convertFromUrl((URL)libFileUrl))});
        }
        if ((file = VfsUtil.findFileByURL((URL)libFileUrl)) == null) {
            LOG.error("Cannot find FlexStyles.as file by url " + VfsUtilCore.convertFromUrl((URL)libFileUrl));
        }
        FILES = ContainerUtil.createMaybeSingletonSet((Object)file);
    }
}

