/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.flex.mxml;

import com.intellij.javascript.flex.mxml.MxmlJSClass;
import com.intellij.javascript.flex.mxml.MxmlJSClassProvider;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.flex.XmlBackedJSClassImpl;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClass;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClassFactory;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClassProvider;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.structureView.JSStructureItemPresentation;
import com.intellij.lang.javascript.types.JSFileElementType;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.navigation.PsiElementNavigationItem;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Consumer;
import com.intellij.util.containers.HashMap;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.ScalarIndexExtension;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlexXmlBackedMembersIndex
extends ScalarIndexExtension<String> {
    private static final int INDEX_VERSION = 1;
    public static final ID<String, Void> NAME = ID.create((String)"FlexXmlBackedMembersIndex");
    private final EnumeratorStringDescriptor myKeyDescriptor = new EnumeratorStringDescriptor();

    @NotNull
    public ID<String, Void> getName() {
        ID<String, Void> iD = NAME;
        if (iD == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/mxml/FlexXmlBackedMembersIndex", "getName"));
        }
        return iD;
    }

    @NotNull
    public DataIndexer<String, Void, FileContent> getIndexer() {
        DataIndexer<String, Void, FileContent> dataIndexer = new DataIndexer<String, Void, FileContent>(){

            @NotNull
            public Map<String, Void> map(@NotNull FileContent inputData) {
                if (inputData == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputData", "com/intellij/javascript/flex/mxml/FlexXmlBackedMembersIndex$1", "map"));
                }
                XmlFile file = (XmlFile)inputData.getPsiFile();
                HashMap result = new HashMap();
                FlexXmlBackedMembersIndex.process(file, (Consumer<PsiElement>)((Consumer)new Consumer<PsiElement>((Map)result){
                    final /* synthetic */ Map val$result;
                    {
                        this.val$result = map;
                    }

                    public void consume(PsiElement element) {
                        String name = FlexXmlBackedMembersIndex.getName(element);
                        if (name != null) {
                            this.val$result.put(name, null);
                        }
                    }
                }), false);
                HashMap hashMap = result;
                if (hashMap == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/mxml/FlexXmlBackedMembersIndex$1", "map"));
                }
                return hashMap;
            }
        };
        if (dataIndexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/mxml/FlexXmlBackedMembersIndex", "getIndexer"));
        }
        return dataIndexer;
    }

    private static void process(XmlFile file, final Consumer<PsiElement> consumer, boolean isPhysical) {
        FlexXmlBackedMembersIndex.visitScriptTagInjectedFilesForIndexing(file, (XmlBackedJSClass.InjectedFileVisitor)new JSResolveUtil.JSInjectedFilesVisitor(){

            protected void process(JSFile file) {
                ResolveState state = ResolveState.initial().put(XmlBackedJSClass.PROCESS_XML_BACKED_CLASS_MEMBERS_HINT, (Object)Boolean.TRUE);
                file.processDeclarations((PsiScopeProcessor)new ResolveProcessor(null){
                    {
                        this.setSkipImplicitDeclarations(true);
                    }

                    public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                        if (element == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/javascript/flex/mxml/FlexXmlBackedMembersIndex$2$1", "execute"));
                        }
                        if (state == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/javascript/flex/mxml/FlexXmlBackedMembersIndex$2$1", "execute"));
                        }
                        if (element instanceof JSFunction || element instanceof JSVariable) {
                            consumer.consume((Object)element);
                        }
                        return true;
                    }

                    public <T> T getHint(@NotNull Key<T> hintKey) {
                        if (hintKey == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hintKey", "com/intellij/javascript/flex/mxml/FlexXmlBackedMembersIndex$2$1", "getHint"));
                        }
                        return null;
                    }

                    public void handleEvent(@NotNull PsiScopeProcessor.Event event, Object associated) {
                        if (event == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/javascript/flex/mxml/FlexXmlBackedMembersIndex$2$1", "handleEvent"));
                        }
                    }
                }, state, null, (PsiElement)file);
            }
        }, isPhysical);
        file.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(){

            public void visitElement(PsiElement element) {
                XmlTag tag;
                if (element instanceof XmlTag && (tag = (XmlTag)element).getAttributeValue("id") != null && MxmlJSClass.canBeReferencedById(tag)) {
                    consumer.consume((Object)tag);
                }
                super.visitElement(element);
            }
        });
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = this.myKeyDescriptor;
        if (enumeratorStringDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/mxml/FlexXmlBackedMembersIndex", "getKeyDescriptor"));
        }
        return enumeratorStringDescriptor;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        DefaultFileTypeSpecificInputFilter defaultFileTypeSpecificInputFilter = new DefaultFileTypeSpecificInputFilter(new FileType[]{JavaScriptSupportLoader.getMxmlFileType()}){

            public boolean acceptInput(@NotNull VirtualFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/javascript/flex/mxml/FlexXmlBackedMembersIndex$4", "acceptInput"));
                }
                return JavaScriptSupportLoader.isMxmlOrFxgFile((VirtualFile)file);
            }
        };
        if (defaultFileTypeSpecificInputFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/mxml/FlexXmlBackedMembersIndex", "getInputFilter"));
        }
        return defaultFileTypeSpecificInputFilter;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public int getVersion() {
        return JSFileElementType.getVersion() + 1;
    }

    public static Collection<String> getSymbolNames(Project project) {
        return FileBasedIndex.getInstance().getAllKeys(NAME, project);
    }

    public static Collection<NavigationItem> getItemsByName(final String name, Project project) {
        Collection files = FileBasedIndex.getInstance().getContainingFiles(NAME, (Object)name, GlobalSearchScope.projectScope((Project)project));
        final ArrayList<NavigationItem> result = new ArrayList<NavigationItem>();
        for (VirtualFile vFile : files) {
            PsiFile file = PsiManager.getInstance((Project)project).findFile(vFile);
            if (!(file instanceof XmlFile)) continue;
            FlexXmlBackedMembersIndex.process((XmlFile)file, new Consumer<PsiElement>(){

                public void consume(PsiElement element) {
                    if (name.equals(FlexXmlBackedMembersIndex.getName(element))) {
                        if (element instanceof JSNamedElement) {
                            result.add((JSNamedElement)element);
                        } else {
                            PsiElement[] children;
                            XmlAttributeValue valueElement;
                            XmlAttribute id = ((XmlTag)element).getAttribute("id");
                            if (id != null && (valueElement = id.getValueElement()) != null && (children = valueElement.getChildren()).length == 3) {
                                result.add(new TagNavigationItem(children[1], name));
                            }
                        }
                    }
                }
            }, true);
        }
        return result;
    }

    @Nullable
    private static String getName(PsiElement element) {
        if (element instanceof XmlTag) {
            return ((XmlTag)element).getAttributeValue("id");
        }
        return ((JSNamedElement)element).getName();
    }

    public static void visitScriptTagInjectedFilesForIndexing(XmlFile file, XmlBackedJSClass.InjectedFileVisitor visitor, boolean physical) {
        new XmlBackedJSClassImpl.InjectedScriptsVisitor(XmlBackedJSClassFactory.getRootTag((XmlFile)file), (XmlBackedJSClassProvider)MxmlJSClassProvider.getInstance(), false, true, visitor, physical).go();
    }

    private static class TagNavigationItem
    extends FakePsiElement
    implements PsiElementNavigationItem,
    ItemPresentation {
        private final PsiElement myElement;
        private final String myName;

        public TagNavigationItem(PsiElement element, String name) {
            this.myElement = element;
            this.myName = name;
        }

        public String getName() {
            return this.myName;
        }

        public ItemPresentation getPresentation() {
            return this;
        }

        public PsiElement getTargetElement() {
            return this.myElement;
        }

        public void navigate(boolean requestFocus) {
            ((Navigatable)this.myElement).navigate(requestFocus);
        }

        public boolean canNavigate() {
            return ((Navigatable)this.myElement).canNavigate();
        }

        public boolean canNavigateToSource() {
            return ((Navigatable)this.myElement).canNavigateToSource();
        }

        public String getPresentableText() {
            return this.getName();
        }

        public String getLocationString() {
            PsiFile file = this.myElement.getContainingFile();
            String packageName = JSResolveUtil.getExpectedPackageNameFromFile((VirtualFile)file.getVirtualFile(), (Project)this.myElement.getProject());
            StringBuilder result = new StringBuilder();
            result.append(StringUtil.getQualifiedName((String)packageName, (String)FileUtil.getNameWithoutExtension((String)file.getName())));
            result.append("(").append(file.getName()).append(")");
            return result.toString();
        }

        public Icon getIcon(boolean open) {
            return JSStructureItemPresentation.getIcon((XmlTag)((XmlTag)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, XmlTag.class)));
        }

        public PsiElement getParent() {
            return this.myElement.getParent();
        }

        public PsiFile getContainingFile() {
            return this.myElement.getContainingFile();
        }
    }
}

