/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.flex.mxml.schema;

import com.intellij.codeInsight.daemon.IdeValidationHost;
import com.intellij.codeInsight.daemon.Validator;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.ide.IconProvider;
import com.intellij.javascript.flex.mxml.MxmlJSClass;
import com.intellij.javascript.flex.mxml.schema.AnnotationBackedDescriptorImpl;
import com.intellij.javascript.flex.mxml.schema.AnyXmlElementWithAnyChildrenDescriptor;
import com.intellij.javascript.flex.mxml.schema.CodeContext;
import com.intellij.javascript.flex.mxml.schema.FlexMxmlNSDescriptor;
import com.intellij.javascript.flex.mxml.schema.FxDefinitionBackedDescriptor;
import com.intellij.javascript.flex.mxml.schema.MxmlLanguageTagsUtil;
import com.intellij.javascript.flex.resolve.ActionScriptClassResolver;
import com.intellij.lang.ASTNode;
import com.intellij.lang.LanguageNamesValidation;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.flex.AnnotationBackedDescriptor;
import com.intellij.lang.javascript.flex.FlexUtils;
import com.intellij.lang.javascript.flex.XmlBackedJSClassImpl;
import com.intellij.lang.javascript.flex.sdk.FlexSdkUtils;
import com.intellij.lang.javascript.index.JSTypeEvaluateManager;
import com.intellij.lang.javascript.index.JavaScriptIndex;
import com.intellij.lang.javascript.inspections.actionscript.ActionScriptAnnotatingVisitor;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttribute;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeNameValuePair;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClass;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClassFactory;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSImportHandlingUtil;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.validation.JSAnnotatingVisitor;
import com.intellij.lang.refactoring.NamesValidator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlElementDescriptorAwareAboutChildren;
import com.intellij.xml.XmlElementDescriptorWithCDataContent;
import com.intellij.xml.XmlElementsGroup;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.impl.schema.AnyXmlAttributeDescriptor;
import com.intellij.xml.util.XmlUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassBackedElementDescriptor
extends IconProvider
implements XmlElementDescriptor,
Validator<XmlTag>,
XmlElementDescriptorWithCDataContent,
XmlElementDescriptorAwareAboutChildren {
    @NonNls
    protected final String className;
    @NonNls
    protected final String name;
    @NonNls
    protected final String iconPath;
    protected final Project project;
    protected final CodeContext context;
    private final boolean predefined;
    private Map<String, AnnotationBackedDescriptor> myDescriptors;
    private Map<String, Map<String, AnnotationBackedDescriptor>> myPackageToInternalDescriptors;
    private Map<String, AnnotationBackedDescriptor> myPredefinedDescriptors;
    @NonNls
    private static final String ARRAY_TYPE_ANNOTATION_PARAMETER = "arrayType";
    @NonNls
    private static final String RADIO_BUTTON_GROUP_CLASS = "mx.controls.RadioButtonGroup";
    private static final XmlUtil.DuplicationInfoProvider<XmlElement> myDuplicationInfoProvider = new XmlUtil.DuplicationInfoProvider<XmlElement>(){

        public String getName(@NotNull XmlElement xmlElement) {
            if (xmlElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlElement", "com/intellij/javascript/flex/mxml/schema/ClassBackedElementDescriptor$1", "getName"));
            }
            if (xmlElement instanceof XmlTag) {
                return ((XmlTag)xmlElement).getLocalName();
            }
            return ((XmlAttribute)xmlElement).getName();
        }

        @NotNull
        public String getNameKey(@NotNull XmlElement xmlElement, @NotNull String name) {
            if (xmlElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlElement", "com/intellij/javascript/flex/mxml/schema/ClassBackedElementDescriptor$1", "getNameKey"));
            }
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/javascript/flex/mxml/schema/ClassBackedElementDescriptor$1", "getNameKey"));
            }
            String string = name;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/mxml/schema/ClassBackedElementDescriptor$1", "getNameKey"));
            }
            return string;
        }

        @NotNull
        public PsiElement getNodeForMessage(@NotNull XmlElement xmlElement) {
            if (xmlElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlElement", "com/intellij/javascript/flex/mxml/schema/ClassBackedElementDescriptor$1", "getNodeForMessage"));
            }
            XmlElement xmlElement2 = xmlElement;
            if (xmlElement2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/mxml/schema/ClassBackedElementDescriptor$1", "getNodeForMessage"));
            }
            return xmlElement2;
        }
    };
    private static final String IMPLEMENTS_ATTR_NAME = "implements";
    private AnnotationBackedDescriptor defaultPropertyDescriptor;
    private boolean defaultPropertyDescriptorInitialized;
    private boolean isContainerClass;
    private boolean isContainerClassInitialized;
    private static final String CONTAINER_CLASS_NAME_2 = "mx.core.IVisualElementContainer";
    @NonNls
    static final String IFACTORY_SHORT_CLASS_NAME = "IFactory";
    private static final String PRIMITIVE_GRAPHIC_ELEMENT_BASE_CLASS = "spark.primitives.supportClasses.GraphicElement";

    ClassBackedElementDescriptor(String name, String _classname, CodeContext _context, Project _project) {
        this(name, _classname, _context, _project, false, null);
    }

    ClassBackedElementDescriptor(String _classname, CodeContext _context, Project _project, boolean _predefined) {
        this(null, _classname, _context, _project, _predefined, null);
    }

    ClassBackedElementDescriptor(String _name, String _classname, CodeContext _context, Project _project, boolean _predefined, String _iconPath) {
        this.context = _context;
        this.className = _classname;
        this.project = _project;
        this.predefined = _predefined;
        this.iconPath = _iconPath;
        this.name = _name;
    }

    public String getQualifiedName() {
        return this.className;
    }

    public String getDefaultName() {
        return this.getName();
    }

    public boolean isPredefined() {
        return this.predefined;
    }

    public XmlElementDescriptor[] getElementsDescriptors(XmlTag _context) {
        boolean includeProperties;
        if (MxmlJSClass.isTagOrInsideTagThatAllowsAnyXmlContent(_context) || MxmlLanguageTagsUtil.isFxReparentTag(_context)) {
            return EMPTY_ARRAY;
        }
        if (MxmlLanguageTagsUtil.isFxLibraryTag(_context)) {
            XmlElementDescriptor[] xmlElementDescriptorArray;
            XmlElementDescriptor definitionDescriptor = this.context.getElementDescriptor("Definition", (XmlTag)null);
            if (definitionDescriptor == null) {
                xmlElementDescriptorArray = EMPTY_ARRAY;
            } else {
                XmlElementDescriptor[] xmlElementDescriptorArray2 = new XmlElementDescriptor[1];
                xmlElementDescriptorArray = xmlElementDescriptorArray2;
                xmlElementDescriptorArray2[0] = definitionDescriptor;
            }
            return xmlElementDescriptorArray;
        }
        XmlElementDescriptor _parentDescriptor = _context.getDescriptor();
        if (_parentDescriptor instanceof AnnotationBackedDescriptorImpl) {
            String arrayType = ((AnnotationBackedDescriptorImpl)_parentDescriptor).getArrayType();
            if (arrayType != null) {
                return this.getElementDescriptorsInheritedFromGivenType(arrayType);
            }
            String type = ((AnnotationBackedDescriptorImpl)_parentDescriptor).getType();
            if (type != null && ClassBackedElementDescriptor.isAdequateType(type)) {
                return this.getElementDescriptorsInheritedFromGivenType(type);
            }
            if (IFACTORY_SHORT_CLASS_NAME.equals(ClassBackedElementDescriptor.className(type)) && JavaScriptSupportLoader.isLanguageNamespace((String)this.context.namespace)) {
                XmlElementDescriptor[] xmlElementDescriptorArray;
                XmlElementDescriptor descriptor = this.context.getElementDescriptor("Component", (XmlTag)null);
                if (descriptor == null) {
                    xmlElementDescriptorArray = EMPTY_ARRAY;
                } else {
                    XmlElementDescriptor[] xmlElementDescriptorArray3 = new XmlElementDescriptor[1];
                    xmlElementDescriptorArray = xmlElementDescriptorArray3;
                    xmlElementDescriptorArray3[0] = descriptor;
                }
                return xmlElementDescriptorArray;
            }
        }
        if (!(_parentDescriptor instanceof ClassBackedElementDescriptor)) {
            return EMPTY_ARRAY;
        }
        ClassBackedElementDescriptor parentDescriptor = (ClassBackedElementDescriptor)_parentDescriptor;
        this.getAttributesDescriptors(_context);
        ArrayList<XmlElementDescriptor> resultList = new ArrayList<XmlElementDescriptor>(this.myDescriptors == null ? 0 : this.myDescriptors.size() + this.context.getAllDescriptorsSize());
        boolean isComponentTag = MxmlLanguageTagsUtil.isComponentTag(_context);
        boolean bl = includeProperties = parentDescriptor == this && !isComponentTag;
        if (isComponentTag) {
            ContainerUtil.addAll(resultList, (Object[])this.getElementDescriptorsInheritedFromGivenType("mx.core.IUIComponent"));
            ContainerUtil.addAll(resultList, (Object[])this.getElementDescriptorsInheritedFromGivenType(PRIMITIVE_GRAPHIC_ELEMENT_BASE_CLASS));
        } else if (parentDescriptor.getDefaultPropertyDescriptor() != null && parentDescriptor.defaultPropertyDescriptor.getType() != null) {
            String type;
            PsiElement contextParent = _context.getParent();
            if (contextParent instanceof XmlDocument && JavaScriptSupportLoader.isLanguageNamespace((String)_context.getNamespace())) {
                for (XmlElementDescriptor descriptor : this.context.getDescriptorsWithAllowedDeclaration()) {
                    if (!(descriptor instanceof ClassBackedElementDescriptor) || !((ClassBackedElementDescriptor)descriptor).predefined) continue;
                    resultList.add(descriptor);
                }
            }
            ContainerUtil.addAll(resultList, (Object[])(ClassBackedElementDescriptor.isAdequateType(type = parentDescriptor.getDefaultPropertyType()) ? this.getElementDescriptorsInheritedFromGivenType(type) : this.context.getDescriptorsWithAllowedDeclaration()));
            if (JavaScriptSupportLoader.isLanguageNamespace((String)this.context.namespace)) {
                ContainerUtil.addIfNotNull((Object)this.context.getElementDescriptor("Script", (XmlTag)null), resultList);
                ContainerUtil.addIfNotNull((Object)this.context.getElementDescriptor("Reparent", (XmlTag)null), resultList);
                if (contextParent instanceof XmlTag && MxmlLanguageTagsUtil.isComponentTag((XmlTag)contextParent)) {
                    ContainerUtil.addIfNotNull((Object)this.context.getElementDescriptor("Declarations", (XmlTag)null), resultList);
                    ContainerUtil.addIfNotNull((Object)this.context.getElementDescriptor("Binding", (XmlTag)null), resultList);
                    ContainerUtil.addIfNotNull((Object)this.context.getElementDescriptor("Style", (XmlTag)null), resultList);
                    ContainerUtil.addIfNotNull((Object)this.context.getElementDescriptor("Metadata", (XmlTag)null), resultList);
                }
            }
        } else if (parentDescriptor.predefined || ClassBackedElementDescriptor.isContainerClass(parentDescriptor)) {
            this.context.appendDescriptorsWithAllowedDeclaration(resultList);
        }
        if (includeProperties && this.myDescriptors != null) {
            String contextPackage;
            Map<String, AnnotationBackedDescriptor> internalDescriptors;
            resultList.addAll(this.myDescriptors.values());
            if (!this.myPackageToInternalDescriptors.isEmpty() && (internalDescriptors = this.myPackageToInternalDescriptors.get(contextPackage = JSResolveUtil.getPackageNameFromPlace((PsiElement)_context))) != null) {
                resultList.addAll(internalDescriptors.values());
            }
        }
        return resultList.toArray(new XmlElementDescriptor[resultList.size()]);
    }

    private static boolean isContainerClass(ClassBackedElementDescriptor descriptor) {
        if (!descriptor.isContainerClassInitialized) {
            PsiElement declaration;
            descriptor.isContainerClass = descriptor.predefined ? false : JSResolveUtil.isAssignableType((String)"mx.core.IContainer", (String)descriptor.className, (PsiElement)(declaration = descriptor.getDeclaration())) || JSResolveUtil.isAssignableType((String)CONTAINER_CLASS_NAME_2, (String)descriptor.className, (PsiElement)declaration);
            descriptor.isContainerClassInitialized = true;
        }
        return descriptor.isContainerClass;
    }

    private String getDefaultPropertyType() {
        return this.defaultPropertyDescriptor.getArrayType() != null ? this.defaultPropertyDescriptor.getArrayType() : this.defaultPropertyDescriptor.getType();
    }

    @Nullable
    public XmlElementDescriptor getElementDescriptor(XmlTag childTag, XmlTag contextTag) {
        if (MxmlJSClass.isTagThatAllowsAnyXmlContent(contextTag)) {
            return new AnyXmlElementWithAnyChildrenDescriptor();
        }
        if (MxmlLanguageTagsUtil.isFxReparentTag(contextTag)) {
            return null;
        }
        XmlElementDescriptor descriptor = this._getElementDescriptor(childTag, contextTag);
        if (descriptor instanceof AnnotationBackedDescriptorImpl && ((AnnotationBackedDescriptorImpl)descriptor).isPredefined()) {
            return null;
        }
        if (MxmlLanguageTagsUtil.isComponentTag(contextTag) && descriptor instanceof ClassBackedElementDescriptor && ((ClassBackedElementDescriptor)descriptor).isPredefined()) {
            return null;
        }
        if (MxmlLanguageTagsUtil.isFxReparentTag(childTag) || MxmlLanguageTagsUtil.isScriptTag(childTag) || MxmlLanguageTagsUtil.isDesignLayerTag(childTag)) {
            return descriptor;
        }
        if (descriptor == null && "http://ns.adobe.com/mxml/2009".equals(childTag.getNamespace()) && contextTag != null) {
            return FxDefinitionBackedDescriptor.getFxDefinitionBackedDescriptor(this.context.module, childTag);
        }
        XmlElementDescriptor parentDescriptor = contextTag.getDescriptor();
        if (MxmlLanguageTagsUtil.isComponentTag(contextTag)) {
            XmlElementDescriptor checkedDescriptor = ClassBackedElementDescriptor.checkValidDescriptorAccordingToType("mx.core.IUIComponent", descriptor);
            return checkedDescriptor != null ? checkedDescriptor : ClassBackedElementDescriptor.checkValidDescriptorAccordingToType(PRIMITIVE_GRAPHIC_ELEMENT_BASE_CLASS, descriptor);
        }
        if (this.getDefaultPropertyDescriptor() != null && this.defaultPropertyDescriptor.getType() != null) {
            if (descriptor instanceof ClassBackedElementDescriptor && ((ClassBackedElementDescriptor)descriptor).predefined) {
                PsiElement contextParent = contextTag.getParent();
                if (contextParent instanceof XmlDocument) {
                    return MxmlLanguageTagsUtil.isLanguageTagAllowedUnderRootTag(childTag) ? descriptor : null;
                }
                if (contextParent instanceof XmlTag && MxmlLanguageTagsUtil.isComponentTag((XmlTag)contextParent)) {
                    return MxmlLanguageTagsUtil.isLanguageTagAllowedUnderInlineComponentRootTag(childTag) ? descriptor : null;
                }
            }
            return ClassBackedElementDescriptor.checkValidDescriptorAccordingToType(this.getDefaultPropertyType(), descriptor);
        }
        if (ClassBackedElementDescriptor.needToCheckThatChildIsUiComponent(contextTag, parentDescriptor, descriptor)) {
            return ClassBackedElementDescriptor.checkValidDescriptorAccordingToType("mx.core.IUIComponent", descriptor);
        }
        return descriptor;
    }

    private static boolean needToCheckThatChildIsUiComponent(XmlTag parentTag, XmlElementDescriptor _parentDescriptor, XmlElementDescriptor _childDescriptor) {
        if (!(_childDescriptor instanceof ClassBackedElementDescriptor) || !(_parentDescriptor instanceof ClassBackedElementDescriptor)) {
            return false;
        }
        ClassBackedElementDescriptor childDescriptor = (ClassBackedElementDescriptor)_childDescriptor;
        ClassBackedElementDescriptor parentDescriptor = (ClassBackedElementDescriptor)_parentDescriptor;
        if (childDescriptor.predefined) {
            return false;
        }
        if (MxmlLanguageTagsUtil.isFxDeclarationsTag(parentTag) || MxmlLanguageTagsUtil.isFxDefinitionTag(parentTag)) {
            return false;
        }
        PsiElement parent = parentTag.getParent();
        if (!ArrayUtil.contains((String)"http://ns.adobe.com/mxml/2009", (String[])parentTag.knownNamespaces()) && (parent instanceof XmlDocument || parent instanceof XmlTag && MxmlLanguageTagsUtil.isComponentTag((XmlTag)parent))) {
            return false;
        }
        if (JSResolveUtil.isAssignableType((String)RADIO_BUTTON_GROUP_CLASS, (String)childDescriptor.className, (PsiElement)parentTag)) {
            return false;
        }
        return ClassBackedElementDescriptor.isContainerClass(parentDescriptor);
    }

    @Nullable
    private XmlElementDescriptor _getElementDescriptor(XmlTag childTag, XmlTag contextTag) {
        String contextPackage;
        Map<String, AnnotationBackedDescriptor> internalDescriptors;
        AnnotationBackedDescriptor descriptor;
        String childNs = childTag.getNamespace();
        if (!ClassBackedElementDescriptor.sameNs(childNs, this.context.namespace)) {
            XmlNSDescriptor descriptor2 = childTag.getNSDescriptor(childNs, true);
            return descriptor2 != null ? descriptor2.getElementDescriptor(childTag) : null;
        }
        this.getAttributesDescriptors(childTag);
        String localName = childTag.getLocalName();
        localName = ClassBackedElementDescriptor.skipStateNamePart(localName);
        AnnotationBackedDescriptor annotationBackedDescriptor = descriptor = this.myDescriptors != null ? this.myDescriptors.get(localName) : null;
        if (descriptor == null && this.myPackageToInternalDescriptors != null && !this.myPackageToInternalDescriptors.isEmpty() && (internalDescriptors = this.myPackageToInternalDescriptors.get(contextPackage = JSResolveUtil.getPackageNameFromPlace((PsiElement)childTag))) != null) {
            descriptor = (XmlElementDescriptor)internalDescriptors.get(localName);
        }
        if (descriptor != null) {
            return descriptor;
        }
        String name = this.getName();
        if ("WebService".equals(name) && "operation".equals(localName)) {
            return this.context.getElementDescriptor("WebServiceOperation", (XmlTag)null);
        }
        if ("RemoteObject".equals(name) && "method".equals(localName)) {
            return this.context.getElementDescriptor("RemoteObjectOperation", (XmlTag)null);
        }
        XmlElementDescriptor xmlElementDescriptor = this.context.getElementDescriptor(localName, childTag);
        if (xmlElementDescriptor == null && !this.predefined) {
            xmlElementDescriptor = this.getClassIfDynamic(localName, this.getDeclaration());
        }
        return xmlElementDescriptor;
    }

    static boolean sameNs(String childNs, String namespace) {
        boolean b = childNs.equals(namespace);
        if (!b) {
            return JavaScriptSupportLoader.isLanguageNamespace((String)childNs) && JavaScriptSupportLoader.isLanguageNamespace((String)namespace);
        }
        return b;
    }

    @Nullable
    XmlElementDescriptor getClassIfDynamic(String localName, PsiElement element) {
        if (ClassBackedElementDescriptor.isDynamicClass(element)) {
            return new ClassBackedElementDescriptor(localName.length() > 0 && Character.isUpperCase(localName.charAt(0)) ? localName : "Object", this.context, this.project, true);
        }
        return null;
    }

    static boolean isDynamicClass(PsiElement element) {
        JSAttributeList attrList;
        return (element = JSResolveUtil.unwrapProxy((PsiElement)element)) instanceof JSClass && (attrList = ((JSClass)element).getAttributeList()) != null && attrList.hasModifier(JSAttributeList.ModifierType.DYNAMIC);
    }

    public XmlAttributeDescriptor[] getAttributesDescriptors(@Nullable XmlTag _context) {
        String contextPackage;
        Map<String, AnnotationBackedDescriptor> internalDescriptors;
        if (MxmlLanguageTagsUtil.isFxPrivateTag(_context) || MxmlLanguageTagsUtil.isFxLibraryTag(_context)) {
            return XmlAttributeDescriptor.EMPTY;
        }
        if (MxmlLanguageTagsUtil.isFxDefinitionTag(_context)) {
            return new XmlAttributeDescriptor[]{new AnnotationBackedDescriptorImpl("name", this, true, null, null, null)};
        }
        if (_context != null && MxmlLanguageTagsUtil.isComponentTag(_context)) {
            return new XmlAttributeDescriptor[]{new ClassNameAttributeDescriptor(this), new AnnotationBackedDescriptorImpl("id", this, true, null, null, null)};
        }
        if (this.myDescriptors == null || this.myPackageToInternalDescriptors == null) {
            PsiElement element = this.getDeclaration();
            if (element == null) {
                this.myDescriptors = Collections.emptyMap();
                this.myPackageToInternalDescriptors = Collections.emptyMap();
            } else {
                this.ensureDescriptorsMapsInitialized(element, null);
            }
        }
        ArrayList<AnnotationBackedDescriptor> descriptors = new ArrayList<AnnotationBackedDescriptor>(this.myDescriptors.values());
        if (_context != null && !this.myPackageToInternalDescriptors.isEmpty() && (internalDescriptors = this.myPackageToInternalDescriptors.get(contextPackage = JSResolveUtil.getPackageNameFromPlace((PsiElement)_context))) != null) {
            descriptors.addAll(internalDescriptors.values());
        }
        if (_context != null && MxmlLanguageTagsUtil.isComponentTag(_context.getParentTag())) {
            descriptors.add(new AnnotationBackedDescriptorImpl(IMPLEMENTS_ATTR_NAME, this, true, null, null, null));
        }
        if (_context != null && _context.getParent() instanceof XmlDocument) {
            AnnotationBackedDescriptor idDescriptor = this.myDescriptors.get("id");
            if (idDescriptor != null) {
                descriptors.remove(idDescriptor);
            }
            descriptors.add(new AnnotationBackedDescriptorImpl(IMPLEMENTS_ATTR_NAME, this, true, null, null, null));
            if (this.myPredefinedDescriptors != null) {
                for (AnnotationBackedDescriptor descriptor : this.myPredefinedDescriptors.values()) {
                    if ("id".equals(descriptor.getName()) || ArrayUtil.contains((String)descriptor.getName(), (String[])CodeContext.GUMBO_ATTRIBUTES)) continue;
                    descriptors.add(descriptor);
                }
            }
        } else if (this.myPredefinedDescriptors != null) {
            descriptors.addAll(this.myPredefinedDescriptors.values());
        }
        return descriptors.toArray(new XmlAttributeDescriptor[descriptors.size()]);
    }

    public void addPredefinedMemberDescriptor(@NotNull AnnotationBackedDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/javascript/flex/mxml/schema/ClassBackedElementDescriptor", "addPredefinedMemberDescriptor"));
        }
        if (this.predefined) {
            if (this.myDescriptors == null) {
                this.myDescriptors = new THashMap();
                this.myPackageToInternalDescriptors = Collections.emptyMap();
            }
            this.myDescriptors.put(descriptor.getName(), descriptor);
        } else {
            if (this.myPredefinedDescriptors == null) {
                this.myPredefinedDescriptors = new THashMap();
            }
            this.myPredefinedDescriptors.put(descriptor.getName(), descriptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureDescriptorsMapsInitialized(PsiElement element, @Nullable Set<JSClass> visited) {
        Class<CodeContext> clazz = CodeContext.class;
        synchronized (CodeContext.class) {
            THashMap map = this.myDescriptors;
            THashMap packageToInternalDescriptors = this.myPackageToInternalDescriptors;
            if (map != null && packageToInternalDescriptors != null) {
                // ** MonitorExit[var5_3] (shouldn't be in output)
                return;
            }
            map = new THashMap();
            packageToInternalDescriptors = new THashMap();
            Set processedElements = null;
            if (element instanceof XmlBackedJSClassImpl) {
                element = element.getParent().getContainingFile();
            }
            if (element instanceof XmlFile && MxmlJSClass.isFxgFile((PsiFile)element)) {
                element = XmlBackedJSClassFactory.getXmlBackedClass((XmlFile)((XmlFile)element));
            }
            while (element instanceof XmlFile) {
                XmlElementDescriptor descriptor;
                XmlDocument document = ((XmlFile)element).getDocument();
                XmlTag rootTag = document != null ? document.getRootTag() : null;
                XmlElementDescriptor xmlElementDescriptor = descriptor = rootTag != null ? rootTag.getDescriptor() : null;
                if (processedElements == null) {
                    processedElements = new THashSet();
                }
                processedElements.add(element);
                PsiElement psiElement = element = descriptor != null ? descriptor.getDeclaration() : null;
                if (processedElements.contains(element)) break;
                this.collectMxmlAttributes((Map<String, AnnotationBackedDescriptor>)map, (Map<String, Map<String, AnnotationBackedDescriptor>>)packageToInternalDescriptors, rootTag);
            }
            if (element instanceof JSNamedElement) {
                JSNamedElement jsClass = (JSNamedElement)element;
                jsClass = (JSNamedElement)JSResolveUtil.unwrapProxy((PsiElement)jsClass);
                if (visited == null || !visited.contains(jsClass)) {
                    if (!"XML".equals(jsClass.getName()) && !"XMLList".equals(jsClass.getName())) {
                        JSReferenceList extendsList;
                        JSReferenceList jSReferenceList = extendsList = jsClass instanceof JSClass ? ((JSClass)jsClass).getExtendsList() : null;
                        if (extendsList != null) {
                            JSClass clazz2 = (JSClass)jsClass;
                            if (visited == null) {
                                visited = new THashSet();
                            }
                            visited.add((JSClass)clazz2);
                            for (JSClass superClazz : clazz2.getSuperClasses()) {
                                this.appendSuperClassDescriptors((Map<String, AnnotationBackedDescriptor>)map, (Map<String, Map<String, AnnotationBackedDescriptor>>)packageToInternalDescriptors, (PsiElement)superClazz, (Set<JSClass>)visited);
                            }
                        } else if (!"Object".equals(jsClass.getName()) && CodeContext.isStdNamespace(this.context.namespace)) {
                            this.appendSuperClassDescriptors((Map<String, AnnotationBackedDescriptor>)map, (Map<String, Map<String, AnnotationBackedDescriptor>>)packageToInternalDescriptors, JSResolveUtil.unwrapProxy((PsiElement)ActionScriptClassResolver.findClassByQNameStatic("Object", (PsiElement)jsClass)), (Set<JSClass>)visited);
                        }
                    }
                    this.collectMyAttributes((PsiElement)jsClass, (Map<String, AnnotationBackedDescriptor>)map, (Map<String, Map<String, AnnotationBackedDescriptor>>)packageToInternalDescriptors);
                }
            }
            this.myDescriptors = map;
            this.myPackageToInternalDescriptors = packageToInternalDescriptors;
            // ** MonitorExit[var5_3] (shouldn't be in output)
            return;
        }
    }

    private void collectMxmlAttributes(final Map<String, AnnotationBackedDescriptor> map, final Map<String, Map<String, AnnotationBackedDescriptor>> packageToInternalDescriptors, XmlTag rootTag) {
        if (rootTag != null) {
            JSResolveUtil.JSInjectedFilesVisitor injectedFilesVisitor = new JSResolveUtil.JSInjectedFilesVisitor(){

                protected void process(JSFile file) {
                    ClassBackedElementDescriptor.this.collectMyAttributes((PsiElement)file, map, packageToInternalDescriptors);
                }
            };
            FlexUtils.processMxmlTags(rootTag, true, injectedFilesVisitor);
            ClassBackedElementDescriptor.processClassBackedTagsWithIdAttribute(rootTag, new Processor<Pair<XmlAttribute, String>>(){

                public boolean process(Pair<XmlAttribute, String> idAttributeAndItsType) {
                    XmlAttribute idAttribute = (XmlAttribute)idAttributeAndItsType.first;
                    String idAttributeValue = idAttribute.getValue();
                    String type = (String)idAttributeAndItsType.second;
                    map.put(idAttributeValue, new AnnotationBackedDescriptorImpl(idAttributeValue, ClassBackedElementDescriptor.this, false, type, null, (PsiElement)idAttribute));
                    return true;
                }
            });
        }
    }

    static boolean processClassBackedTagsWithIdAttribute(@NotNull XmlTag tag, Processor<Pair<XmlAttribute, String>> processor) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/javascript/flex/mxml/schema/ClassBackedElementDescriptor", "processClassBackedTagsWithIdAttribute"));
        }
        boolean toContinue = true;
        XmlElementDescriptor tagDescriptor = tag.getDescriptor();
        if (tagDescriptor instanceof ClassBackedElementDescriptor) {
            XmlAttribute idAttribute = tag.getAttribute("id");
            if (idAttribute != null && !StringUtil.isEmpty((String)idAttribute.getValue())) {
                toContinue = processor.process((Object)Pair.create((Object)idAttribute, (Object)tagDescriptor.getQualifiedName()));
            }
            if (toContinue) {
                for (XmlTag childTag : tag.getSubTags()) {
                    if (!toContinue) continue;
                    toContinue = ClassBackedElementDescriptor.processClassBackedTagsWithIdAttribute(childTag, processor);
                }
            }
        }
        return toContinue;
    }

    private void collectMyAttributes(final PsiElement jsClass, final Map<String, AnnotationBackedDescriptor> map, final Map<String, Map<String, AnnotationBackedDescriptor>> packageToInternalDescriptors) {
        ClassBackedElementDescriptor.processAttributes(jsClass, new AttributedItemsProcessor(){

            @Override
            public boolean process(JSNamedElement jsNamedElement, boolean isPackageLocalVisibility) {
                String name = jsNamedElement.getName();
                if (name != null) {
                    String instanceType;
                    if (jsNamedElement instanceof JSVariable && ((JSVariable)jsNamedElement).isConst()) {
                        return true;
                    }
                    String propertyType = ClassBackedElementDescriptor.getPropertyType(jsNamedElement);
                    boolean deferredInstance = false;
                    JSAttributeList attributeList = ((JSAttributeListOwner)jsNamedElement).getAttributeList();
                    if (attributeList != null && (instanceType = JSPsiImplUtils.getTypeFromAnnotationParameter((JSAttributeList)attributeList, (String)"InstanceType", null)) != null) {
                        deferredInstance = true;
                        propertyType = instanceType;
                    }
                    if (!(propertyType == null || propertyType.length() <= 0 || !Character.isUpperCase(propertyType.charAt(0)) && propertyType.indexOf(46) < 0 || "String".equals(propertyType) || "Number".equals(propertyType) || "Boolean".equals(propertyType))) {
                        String arrayType = null;
                        if (JSTypeEvaluateManager.isArrayType((String)propertyType)) {
                            arrayType = JSTypeEvaluateManager.getComponentType((String)propertyType);
                        } else if ("Array".equals(propertyType)) {
                            if (attributeList != null && (arrayType = JSPsiImplUtils.getTypeFromAnnotationParameter((JSAttributeList)attributeList, (String)"Inspectable", (String)ClassBackedElementDescriptor.ARRAY_TYPE_ANNOTATION_PARAMETER)) == null) {
                                arrayType = JSPsiImplUtils.getArrayElementTypeFromAnnotation((JSAttributeList)attributeList);
                            }
                            if (arrayType == null && jsClass instanceof JSClass && jsNamedElement instanceof JSFunction && ((JSFunction)jsNamedElement).isSetProperty()) {
                                JSAttributeList getterAttributeList;
                                JSFunction getter = ((JSClass)jsClass).findFunctionByNameAndKind(jsNamedElement.getName(), JSFunction.FunctionKind.GETTER);
                                JSAttributeList jSAttributeList = getterAttributeList = getter == null ? null : getter.getAttributeList();
                                if (getterAttributeList != null && (arrayType = JSPsiImplUtils.getTypeFromAnnotationParameter((JSAttributeList)getterAttributeList, (String)"Inspectable", (String)ClassBackedElementDescriptor.ARRAY_TYPE_ANNOTATION_PARAMETER)) == null) {
                                    arrayType = JSPsiImplUtils.getArrayElementTypeFromAnnotation((JSAttributeList)getterAttributeList);
                                }
                            }
                        } else {
                            propertyType = JSImportHandlingUtil.resolveTypeName((String)propertyType, (PsiElement)jsNamedElement);
                        }
                        if (arrayType != null) {
                            arrayType = JSImportHandlingUtil.resolveTypeName((String)arrayType, (PsiElement)jsNamedElement);
                        }
                        ClassBackedElementDescriptor.this.putDescriptor(jsNamedElement, name, propertyType, arrayType, deferredInstance, isPackageLocalVisibility, map, packageToInternalDescriptors);
                    } else {
                        ClassBackedElementDescriptor.this.putDescriptor(jsNamedElement, name, propertyType, null, deferredInstance, isPackageLocalVisibility, map, packageToInternalDescriptors);
                    }
                }
                return true;
            }

            @Override
            public boolean process(JSAttributeNameValuePair pair, String annotationName, boolean included) {
                String name = pair.getSimpleValue();
                if (name != null) {
                    if (included) {
                        AnnotationBackedDescriptorImpl previousDescriptor = (AnnotationBackedDescriptorImpl)((Object)map.get(name));
                        AnnotationBackedDescriptorImpl descriptor = new AnnotationBackedDescriptorImpl(name, ClassBackedElementDescriptor.this, false, null, null, (PsiElement)pair);
                        if (previousDescriptor == null || !previousDescriptor.isPreferredTo(descriptor)) {
                            map.put(name, descriptor);
                        }
                    } else {
                        map.remove(name);
                    }
                }
                return true;
            }
        });
        if (this.predefined && ("Script".equals(this.className) || "Style".equals(this.className))) {
            map.put("source", new AnnotationBackedDescriptorImpl("source", this, true, null, null, null));
        }
        if (!this.predefined && map.get("id") == null) {
            this.addPredefinedMemberDescriptor(new AnnotationBackedDescriptorImpl("id", this, true, null, null, null));
        }
    }

    private void putDescriptor(JSNamedElement jsNamedElement, String name, String propertyType, String arrayType, boolean deferredInstance, boolean isPackageLocalVisibility, Map<String, AnnotationBackedDescriptor> map, Map<String, Map<String, AnnotationBackedDescriptor>> packageToInternalDescriptors) {
        AnnotationBackedDescriptorImpl previousDescriptor = (AnnotationBackedDescriptorImpl)map.get(name);
        AnnotationBackedDescriptorImpl descriptor = previousDescriptor != null && previousDescriptor.parentDescriptor != this && previousDescriptor.getOriginatingElementType() == AnnotationBackedDescriptorImpl.OriginatingElementType.VarOrFunction && jsNamedElement instanceof JSAttributeListOwner && AnnotationBackedDescriptorImpl.findInspectableAttr((PsiElement)jsNamedElement) == null ? new AnnotationBackedDescriptorImpl(name, this, previousDescriptor, jsNamedElement) : new AnnotationBackedDescriptorImpl(name, this, false, propertyType, arrayType, deferredInstance, (PsiElement)jsNamedElement);
        if (previousDescriptor == null || !previousDescriptor.isPreferredTo(descriptor)) {
            if (isPackageLocalVisibility) {
                String packageName = JSResolveUtil.getPackageNameFromPlace((PsiElement)jsNamedElement);
                if (packageName != null) {
                    THashMap descriptorMap = packageToInternalDescriptors.get(packageName);
                    if (descriptorMap == null) {
                        descriptorMap = new THashMap();
                        packageToInternalDescriptors.put(packageName, (Map<String, AnnotationBackedDescriptor>)descriptorMap);
                    }
                    descriptorMap.put(name, descriptor);
                }
            } else {
                map.put(name, descriptor);
            }
        }
    }

    static String getPropertyType(JSNamedElement jsNamedElement) {
        JSType type;
        if (jsNamedElement instanceof JSVariable) {
            return ((JSVariable)jsNamedElement).getTypeString();
        }
        if (jsNamedElement instanceof JSFunctionItem && (type = JSResolveUtil.getTypeFromSetAccessor((JSFunctionItem)((JSFunctionItem)jsNamedElement))) != null) {
            return type.getTypeText();
        }
        return null;
    }

    private void appendSuperClassDescriptors(Map<String, AnnotationBackedDescriptor> map, Map<String, Map<String, AnnotationBackedDescriptor>> packageToInternalDescriptors, PsiElement _clazz, @Nullable Set<JSClass> visited) {
        if (_clazz instanceof JSClass) {
            JSClass clazz = (JSClass)_clazz;
            ClassBackedElementDescriptor parentDescriptor = this.context.getElementDescriptor(clazz.getName(), clazz.getQualifiedName());
            if (parentDescriptor == null) {
                parentDescriptor = new ClassBackedElementDescriptor(null, clazz.getQualifiedName(), this.context, this.project);
            }
            parentDescriptor.ensureDescriptorsMapsInitialized((PsiElement)clazz, visited);
            map.putAll(parentDescriptor.myDescriptors);
            for (Map.Entry<String, Map<String, AnnotationBackedDescriptor>> entry : parentDescriptor.myPackageToInternalDescriptors.entrySet()) {
                THashMap descriptorMap = packageToInternalDescriptors.get(entry.getKey());
                if (descriptorMap == null) {
                    descriptorMap = new THashMap();
                    packageToInternalDescriptors.put(entry.getKey(), (Map<String, AnnotationBackedDescriptor>)descriptorMap);
                }
                descriptorMap.putAll(entry.getValue());
            }
        }
    }

    public void validate(@NotNull XmlTag tag, @NotNull Validator.ValidationHost host) {
        PsiElement declaration;
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/javascript/flex/mxml/schema/ClassBackedElementDescriptor", "validate"));
        }
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/javascript/flex/mxml/schema/ClassBackedElementDescriptor", "validate"));
        }
        if (FlexSdkUtils.isFlex4Sdk(FlexUtils.getSdkForActiveBC(this.context.module))) {
            MxmlLanguageTagsUtil.checkFlex4Attributes(tag, host, true);
        }
        if (MxmlLanguageTagsUtil.isFxPrivateTag(tag)) {
            MxmlLanguageTagsUtil.validateFxPrivateTag(tag, host);
            return;
        }
        if (MxmlLanguageTagsUtil.isFxLibraryTag(tag)) {
            MxmlLanguageTagsUtil.validateFxLibraryTag(tag, host);
            return;
        }
        if (MxmlLanguageTagsUtil.isFxDefinitionTag(tag)) {
            MxmlLanguageTagsUtil.validateFxDefinitionTag(tag, host);
            return;
        }
        if (MxmlLanguageTagsUtil.isFxReparentTag(tag)) {
            MxmlLanguageTagsUtil.validateFxReparentTag(tag, host);
            return;
        }
        for (XmlTag subtag : tag.getSubTags()) {
            JSClass[] s = subtag.getLocalName();
            if (s.length() <= 0 || !Character.isLowerCase(s.charAt(0)) || tag.getAttributeValue((String)s) == null) continue;
            ArrayList elements = new ArrayList();
            ClassBackedElementDescriptor.collectLowerCasedElements(elements, (XmlElement[])tag.getAttributes());
            ClassBackedElementDescriptor.collectLowerCasedElements(elements, (XmlElement[])tag.getSubTags());
            XmlUtil.doDuplicationCheckForElements((PsiElement[])((PsiElement[])elements.toArray(new XmlElement[elements.size()])), (Map)new THashMap(elements.size()), myDuplicationInfoProvider, (Validator.ValidationHost)host);
            break;
        }
        if ((declaration = this.getDeclaration()) instanceof JSClass && !CodeContext.hasDefaultConstructor((JSClass)declaration)) {
            host.addMessage((PsiElement)tag, JSBundle.message((String)"class.0.does.not.have.default.constructor", (Object[])new Object[]{((JSClass)declaration).getQualifiedName()}), Validator.ValidationHost.ErrorType.ERROR);
        }
        if (tag.getParent() instanceof XmlDocument) {
            JSClass[] classes;
            XmlBackedJSClass jsClass = XmlBackedJSClassFactory.getXmlBackedClass((XmlFile)((XmlFile)tag.getContainingFile()));
            JSReferenceList list = jsClass.getImplementsList();
            MxmlErrorReportingClient reportingClient = new MxmlErrorReportingClient(host);
            if (list != null) {
                ActionScriptAnnotatingVisitor.checkActionScriptImplementedMethods((JSClass)jsClass, reportingClient);
                for (JSClass element : list.getReferencedClasses()) {
                    if (element == jsClass) {
                        reportingClient.reportError(ClassBackedElementDescriptor.refToImplementsNode(tag), JSBundle.message((String)"javascript.validation.message.circular.dependency", (Object[])new Object[0]), JSAnnotatingVisitor.ErrorReportingClient.ProblemKind.ERROR, new IntentionAction[0]);
                        continue;
                    }
                    if (element == null || element.isInterface()) continue;
                    reportingClient.reportError(ClassBackedElementDescriptor.refToImplementsNode(tag), JSBundle.message((String)"javascript.validation.message.interface.name.expected.here", (Object[])new Object[0]), JSAnnotatingVisitor.ErrorReportingClient.ProblemKind.ERROR, new IntentionAction[0]);
                }
            }
            if ((classes = jsClass.getSuperClasses()).length > 0 && classes[0] == jsClass) {
                reportingClient.reportError(tag.getNode(), JSBundle.message((String)"javascript.validation.message.circular.dependency", (Object[])new Object[0]), JSAnnotatingVisitor.ErrorReportingClient.ProblemKind.ERROR, new IntentionAction[0]);
            }
            ActionScriptAnnotatingVisitor.checkFileUnderSourceRoot((JSNamedElement)jsClass, reportingClient);
        }
        if (MxmlLanguageTagsUtil.isComponentTag(tag) && tag.getSubTags().length == 0) {
            host.addMessage((PsiElement)tag, JSBundle.message((String)"javascript.validation.empty.component.type", (Object[])new Object[0]), Validator.ValidationHost.ErrorType.ERROR);
        }
    }

    private static ASTNode refToImplementsNode(XmlTag tag) {
        return tag.getAttribute(IMPLEMENTS_ATTR_NAME).getValueElement().getChildren()[1].getNode();
    }

    private static <T extends XmlElement & PsiNamedElement> void collectLowerCasedElements(List<XmlElement> elements, T[] xmlAttributes) {
        for (T a : xmlAttributes) {
            String name;
            if (a instanceof XmlAttribute && "id".equals(((PsiNamedElement)a).getName())) continue;
            String string = name = a instanceof XmlTag ? ((XmlTag)a).getLocalName() : ((PsiNamedElement)a).getName();
            if (name == null || name.length() <= 0 || !Character.isLowerCase(name.charAt(0))) continue;
            elements.add((XmlElement)a);
        }
    }

    public boolean requiresCdataBracesInContext(@NotNull XmlTag context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/flex/mxml/schema/ClassBackedElementDescriptor", "requiresCdataBracesInContext"));
        }
        return this.predefined && "Script".equals(context.getLocalName());
    }

    public Icon getIcon(@NotNull PsiElement element, int flags) {
        VirtualFile relativeFile;
        PsiFile containingFile;
        VirtualFile file;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/javascript/flex/mxml/schema/ClassBackedElementDescriptor", "getIcon"));
        }
        if (this.iconPath != null && (file = (containingFile = element.getContainingFile()).getVirtualFile()) != null && (relativeFile = VfsUtil.findRelativeFile((String)this.iconPath, (VirtualFile)file.getParent())) != null) {
            try {
                return new ImageIcon(new URL(VfsUtil.fixIDEAUrl((String)relativeFile.getUrl())));
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    XmlElementDescriptor[] getElementDescriptorsInheritedFromGivenType(@NotNull String arrayElementType) {
        if (arrayElementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arrayElementType", "com/intellij/javascript/flex/mxml/schema/ClassBackedElementDescriptor", "getElementDescriptorsInheritedFromGivenType"));
        }
        PsiElement declaration = this.getDeclaration();
        if (declaration == null) {
            return EMPTY_ARRAY;
        }
        PsiElement clazz = JSResolveUtil.unwrapProxy((PsiElement)ActionScriptClassResolver.findClassByQNameStatic(arrayElementType, declaration));
        if (!(clazz instanceof JSClass)) {
            return EMPTY_ARRAY;
        }
        JSClass jsClass = (JSClass)clazz;
        JSAttributeList attributeList = jsClass.getAttributeList();
        boolean isFinalClass = attributeList != null && attributeList.hasModifier(JSAttributeList.ModifierType.FINAL);
        ArrayList<XmlElementDescriptor> result = new ArrayList<XmlElementDescriptor>();
        if (isFinalClass) {
            ClassBackedElementDescriptor descriptor;
            String jsClassName = jsClass.getName();
            if (jsClassName != null && (descriptor = this.context.getElementDescriptor(jsClassName, jsClass.getQualifiedName())) instanceof ClassBackedElementDescriptor && CodeContext.checkDeclaration(descriptor)) {
                result.add(descriptor);
            }
        } else {
            for (XmlElementDescriptor descriptor : this.context.getDescriptorsWithAllowedDeclaration()) {
                PsiElement decl;
                if (!(descriptor instanceof ClassBackedElementDescriptor) || ((ClassBackedElementDescriptor)descriptor).predefined || !((decl = descriptor.getDeclaration()) instanceof JSClass) || !JSInheritanceUtil.isParentClass((JSClass)((JSClass)decl), (JSClass)jsClass, (boolean)false)) continue;
                result.add(descriptor);
            }
        }
        return result.toArray(new XmlElementDescriptor[result.size()]);
    }

    @Nullable
    static XmlElementDescriptor checkValidDescriptorAccordingToType(String arrayElementType, XmlElementDescriptor descriptor) {
        if (descriptor instanceof ClassBackedElementDescriptor && ClassBackedElementDescriptor.isAdequateType(arrayElementType)) {
            PsiElement declaration = descriptor.getDeclaration();
            if (declaration instanceof XmlFile) {
                declaration = XmlBackedJSClassFactory.getXmlBackedClass((XmlFile)((XmlFile)declaration));
            }
            if (declaration == null) {
                return null;
            }
            PsiElement element = JSResolveUtil.unwrapProxy((PsiElement)declaration);
            if (element instanceof JSClass && !JSResolveUtil.isAssignableType((String)arrayElementType, (String)((JSClass)element).getQualifiedName(), (PsiElement)element)) {
                return null;
            }
        }
        return descriptor;
    }

    @Nullable
    public AnnotationBackedDescriptor getDefaultPropertyDescriptor() {
        if (!this.defaultPropertyDescriptorInitialized) {
            PsiElement element;
            PsiElement psiElement = element = this.predefined ? null : JSResolveUtil.unwrapProxy((PsiElement)this.getDeclaration());
            if (element instanceof XmlFile) {
                element = XmlBackedJSClassFactory.getXmlBackedClass((XmlFile)((XmlFile)element));
            }
            if (element instanceof JSClass) {
                JSClass jsClass = (JSClass)element;
                do {
                    AnnotationBackedDescriptor descriptor;
                    if ((descriptor = this.getDefaultPropertyDescriptor(jsClass)) != null) {
                        this.defaultPropertyDescriptor = descriptor;
                        break;
                    }
                    jsClass = (JSClass)ArrayUtil.getFirstElement((Object[])jsClass.getSuperClasses());
                } while (jsClass != null);
            }
            this.defaultPropertyDescriptorInitialized = true;
        }
        return this.defaultPropertyDescriptor;
    }

    @Nullable
    private AnnotationBackedDescriptor getDefaultPropertyDescriptor(JSClass jsClass) {
        String s;
        JSAttributeNameValuePair pair;
        JSAttribute attribute;
        final Ref dpAttributeRef = Ref.create();
        if (jsClass instanceof XmlBackedJSClassImpl) {
            XmlFile xmlFile = (XmlFile)jsClass.getContainingFile();
            XmlTag rootTag = xmlFile.getRootTag();
            if (rootTag != null) {
                for (XmlTag metadataTag : rootTag.findSubTags("Metadata", "http://ns.adobe.com/mxml/2009")) {
                    JSResolveUtil.processInjectedFileForTag((XmlTag)metadataTag, (JSResolveUtil.JSInjectedFilesVisitor)new JSResolveUtil.JSInjectedFilesVisitor(){

                        protected void process(JSFile file) {
                            for (PsiElement elt : file.getChildren()) {
                                if (!(elt instanceof JSAttributeList)) continue;
                                JSAttribute dpAttribute = ((JSAttributeList)elt).findAttributeByName("DefaultProperty");
                                if (!dpAttributeRef.isNull() || dpAttribute == null) continue;
                                dpAttributeRef.set((Object)dpAttribute);
                                return;
                            }
                        }
                    });
                }
            }
        } else {
            JSAttributeList attributeList = jsClass.getAttributeList();
            if (attributeList != null) {
                dpAttributeRef.set((Object)attributeList.findAttributeByName("DefaultProperty"));
            }
        }
        if ((attribute = (JSAttribute)dpAttributeRef.get()) != null && (pair = attribute.getValueByName(null)) != null && (s = pair.getSimpleValue()) != null) {
            this.getAttributesDescriptors(null);
            XmlAttributeDescriptor descriptor = this.getAttributeDescriptor(s, null);
            if (descriptor instanceof AnnotationBackedDescriptor) {
                return (AnnotationBackedDescriptor)descriptor;
            }
            return new AnnotationBackedDescriptorImpl("any", this, true, "NonExistentClass!", null, null);
        }
        return null;
    }

    public boolean allowElementsFromNamespace(String namespace, XmlTag context) {
        if (MxmlJSClass.isTagOrInsideTagThatAllowsAnyXmlContent(context)) {
            return false;
        }
        if (MxmlLanguageTagsUtil.isFxLibraryTag(context)) {
            return "http://ns.adobe.com/mxml/2009".equals(namespace);
        }
        XmlElementDescriptor _descriptor = context.getDescriptor();
        if (_descriptor instanceof ClassBackedElementDescriptor) {
            ClassBackedElementDescriptor descriptor = (ClassBackedElementDescriptor)_descriptor;
            if (context.getParent() instanceof XmlDocument && JavaScriptSupportLoader.isLanguageNamespace((String)namespace)) {
                return true;
            }
            if (MxmlLanguageTagsUtil.isComponentTag(context) || descriptor.getDefaultPropertyDescriptor() != null && descriptor.defaultPropertyDescriptor.getType() != null) {
                return true;
            }
            if (!descriptor.predefined && !ClassBackedElementDescriptor.isContainerClass(descriptor)) {
                return false;
            }
        }
        return true;
    }

    static boolean isAdequateType(String type) {
        if ("Array".equals(type) || "Object".equals(type) || "*".equals(type)) {
            return false;
        }
        String className = ClassBackedElementDescriptor.className(type);
        return !"IDeferredInstance".equals(className);
    }

    static String className(String type) {
        return type != null ? type.substring(type.lastIndexOf(46) + 1) : null;
    }

    static boolean processAttributes(PsiElement jsClass, AttributedItemsProcessor processor) {
        jsClass = JSResolveUtil.unwrapProxy((PsiElement)jsClass);
        return ClassBackedElementDescriptor.doProcess(jsClass, processor);
    }

    private static boolean doProcess(PsiElement jsClass, final AttributedItemsProcessor processor) {
        return JSResolveUtil.processMetaAttributesForClass((PsiElement)jsClass, (JSResolveUtil.MetaDataProcessor)new JSResolveUtil.MetaDataProcessor(){

            public boolean process(@NotNull JSAttribute attr) {
                if (attr == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attr", "com/intellij/javascript/flex/mxml/schema/ClassBackedElementDescriptor$6", "process"));
                }
                String attrName = attr.getName();
                boolean skipped = false;
                if ("Event".equals(attrName) || "Style".equals(attrName) || "Effect".equals(attrName) || (skipped = "Exclude".equals(attrName))) {
                    JSAttributeNameValuePair jsAttributeNameValuePair = attr.getValueByName("name");
                    if (jsAttributeNameValuePair == null) {
                        jsAttributeNameValuePair = attr.getValueByName(null);
                    }
                    if (jsAttributeNameValuePair != null && !processor.process(jsAttributeNameValuePair, attrName, !skipped)) {
                        return false;
                    }
                }
                return true;
            }

            public boolean handleOtherElement(PsiElement el, PsiElement context, Ref<PsiElement> continuePassElement) {
                if (continuePassElement != null) {
                    if (el instanceof JSVarStatement) {
                        JSVariable[] jsVariables = ((JSVarStatement)el).getVariables();
                        if (jsVariables.length > 0) {
                            continuePassElement.set((Object)jsVariables[0]);
                        }
                    } else {
                        continuePassElement.set((Object)el);
                    }
                } else {
                    JSAttributeList.AccessType accessType = ((JSAttributeList)el).getAccessType();
                    if ((accessType == JSAttributeList.AccessType.PUBLIC || accessType == JSAttributeList.AccessType.PACKAGE_LOCAL) && !((JSAttributeList)el).hasModifier(JSAttributeList.ModifierType.STATIC) && (context instanceof JSVariable || context instanceof JSFunction && ((JSFunction)context).isSetProperty()) && !processor.process((JSNamedElement)context, accessType == JSAttributeList.AccessType.PACKAGE_LOCAL)) {
                        return false;
                    }
                }
                return true;
            }
        });
    }

    public XmlAttributeDescriptor getAttributeDescriptor(String attributeName, @Nullable XmlTag context) {
        String contextPackage;
        Map<String, AnnotationBackedDescriptor> internalDescriptors;
        String prefix;
        if (ClassBackedElementDescriptor.isPrivateAttribute(attributeName, context)) {
            return new AnyXmlAttributeDescriptor(attributeName);
        }
        if (context != null && context.getParent() instanceof XmlDocument && ("id".equals(attributeName) || ArrayUtil.contains((String)attributeName, (String[])CodeContext.GUMBO_ATTRIBUTES))) {
            return null;
        }
        PsiElement element = this.getDeclaration();
        if (element == null) {
            return null;
        }
        attributeName = ClassBackedElementDescriptor.skipStateNamePart(attributeName);
        this.ensureDescriptorsMapsInitialized(element, null);
        AnnotationBackedDescriptor descriptor = this.myDescriptors.get(attributeName);
        if (descriptor == null && context != null && StringUtil.isNotEmpty((String)(prefix = context.getNamespacePrefix())) && attributeName.startsWith(prefix + ":")) {
            descriptor = this.myDescriptors.get(attributeName.substring(prefix.length() + 1));
        }
        if (descriptor == null && context != null && !this.myPackageToInternalDescriptors.isEmpty() && (internalDescriptors = this.myPackageToInternalDescriptors.get(contextPackage = JSResolveUtil.getPackageNameFromPlace((PsiElement)context))) != null) {
            descriptor = internalDescriptors.get(attributeName);
        }
        if (descriptor == null && this.myPredefinedDescriptors != null) {
            descriptor = this.myPredefinedDescriptors.get(attributeName);
        }
        if (descriptor == null) {
            if (IMPLEMENTS_ATTR_NAME.equals(attributeName) && context != null) {
                PsiElement parent = context.getParent();
                if (parent instanceof XmlDocument || parent instanceof XmlTag && MxmlLanguageTagsUtil.isComponentTag((XmlTag)parent)) {
                    descriptor = new AnnotationBackedDescriptorImpl(IMPLEMENTS_ATTR_NAME, this, true, null, null, null);
                }
            } else if ("className".equals(attributeName) && MxmlLanguageTagsUtil.isComponentTag(context)) {
                descriptor = new ClassNameAttributeDescriptor(this);
            } else if (!this.predefined && !"id".equals(attributeName) && !MxmlLanguageTagsUtil.isXmlOrXmlListTag(context) && ClassBackedElementDescriptor.isDynamicClass(element)) {
                return new AnyXmlAttributeDescriptor(attributeName);
            }
        }
        return descriptor;
    }

    static boolean isPrivateAttribute(String attributeName, XmlTag context) {
        String namespace;
        String namespacePrefix;
        int colonIndex = attributeName.indexOf(58);
        String string = namespacePrefix = colonIndex == -1 ? null : attributeName.substring(0, colonIndex);
        return namespacePrefix != null && context != null && ArrayUtil.contains((String)"http://ns.adobe.com/mxml/2009", (String[])context.knownNamespaces()) && !StringUtil.isEmpty((String)(namespace = context.getNamespaceByPrefix(namespacePrefix))) && !namespace.equals("http://ns.adobe.com/mxml/2009") && !namespace.equals(context.getNamespace());
    }

    private static String skipStateNamePart(String attributeName) {
        int dotPos = attributeName.lastIndexOf(46);
        if (dotPos != -1 && !attributeName.startsWith("id.")) {
            return attributeName.substring(0, dotPos);
        }
        return attributeName;
    }

    public XmlAttributeDescriptor getAttributeDescriptor(XmlAttribute attribute) {
        return this.getAttributeDescriptor(attribute.getName(), attribute.getParent());
    }

    public XmlNSDescriptor getNSDescriptor() {
        return null;
    }

    public XmlElementsGroup getTopGroup() {
        return null;
    }

    public int getContentType() {
        return -1;
    }

    public String getDefaultValue() {
        return null;
    }

    @Nullable
    public PsiElement getDeclaration() {
        PsiElement jsClass;
        String className;
        String string = className = this.predefined ? "Object" : this.className;
        if (className.equals("__AS3__.vec.Vector")) {
            className = "Vector";
        }
        PsiFile file = (jsClass = ActionScriptClassResolver.findClassByQName(className, JavaScriptIndex.getInstance((Project)this.project), this.context.module)) == null ? null : jsClass.getContainingFile();
        return file != null && JavaScriptSupportLoader.isMxmlOrFxgFile((PsiFile)file) ? file : jsClass;
    }

    @NonNls
    public String getName(PsiElement context) {
        XmlNSDescriptor nsDescriptor;
        String prefix = null;
        XmlTag tag = (XmlTag)context;
        String name = this.getName();
        int packageIndex = this.className.lastIndexOf(name);
        String packageName = packageIndex > 0 ? this.className.substring(0, packageIndex - 1) : "";
        packageName = packageName.length() > 0 ? packageName + ".*" : "*";
        XmlNSDescriptor xmlNSDescriptor = nsDescriptor = tag.getPrefixByNamespace(packageName) != null ? tag.getNSDescriptor(packageName, true) : null;
        if (nsDescriptor instanceof FlexMxmlNSDescriptor && ((FlexMxmlNSDescriptor)nsDescriptor).hasElementDescriptorWithName(name, this.className)) {
            prefix = tag.getPrefixByNamespace(packageName);
        }
        if (prefix == null) {
            String preferredNamespace = this.context.namespace;
            String[] knownNamespaces = tag.knownNamespaces();
            if (preferredNamespace.indexOf(42) == -1 && ArrayUtil.contains((String)preferredNamespace, (String[])knownNamespaces) && (nsDescriptor = tag.getNSDescriptor(preferredNamespace, true)) instanceof FlexMxmlNSDescriptor && ((FlexMxmlNSDescriptor)nsDescriptor).hasElementDescriptorWithName(name, this.className)) {
                prefix = tag.getPrefixByNamespace(preferredNamespace);
            }
            if (prefix == null) {
                for (String namespace : knownNamespaces) {
                    if (namespace.equals(preferredNamespace) || namespace.indexOf(42) != -1 || !((nsDescriptor = tag.getNSDescriptor(namespace, true)) instanceof FlexMxmlNSDescriptor) || !((FlexMxmlNSDescriptor)nsDescriptor).hasElementDescriptorWithName(name, this.className)) continue;
                    prefix = tag.getPrefixByNamespace(namespace);
                    break;
                }
            }
        }
        if (prefix == null || prefix.length() == 0) {
            return name;
        }
        return prefix + ":" + name;
    }

    @NonNls
    public String getName() {
        return this.name == null ? this.getNameFromQName() : this.name;
    }

    private String getNameFromQName() {
        return ClassBackedElementDescriptor.className(this.className);
    }

    public void init(PsiElement element) {
    }

    public Object[] getDependences() {
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    private static class ClassNameAttributeDescriptor
    extends AnnotationBackedDescriptorImpl {
        protected ClassNameAttributeDescriptor(ClassBackedElementDescriptor parentDescriptor) {
            super("className", parentDescriptor, true, null, null, null);
        }

        @Override
        public String validateValue(XmlElement context, String value) {
            NamesValidator namesValidator = (NamesValidator)LanguageNamesValidation.INSTANCE.forLanguage(JavaScriptSupportLoader.JAVASCRIPT.getLanguage());
            if (!namesValidator.isIdentifier(value, context.getProject())) {
                return JSBundle.message((String)"invalid.identifier.value", (Object[])new Object[0]);
            }
            return null;
        }
    }

    static interface AttributedItemsProcessor {
        public boolean process(JSNamedElement var1, boolean var2);

        public boolean process(JSAttributeNameValuePair var1, String var2, boolean var3);
    }

    private static class MxmlErrorReportingClient
    implements JSAnnotatingVisitor.ErrorReportingClient {
        private final Validator.ValidationHost myHost;

        public MxmlErrorReportingClient(Validator.ValidationHost host) {
            this.myHost = host;
        }

        public void reportError(ASTNode nameIdentifier, String s, JSAnnotatingVisitor.ErrorReportingClient.ProblemKind kind, IntentionAction ... fixes) {
            Validator.ValidationHost.ErrorType errorType;
            if (fixes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fixes", "com/intellij/javascript/flex/mxml/schema/ClassBackedElementDescriptor$MxmlErrorReportingClient", "reportError"));
            }
            Validator.ValidationHost.ErrorType errorType2 = errorType = kind == JSAnnotatingVisitor.ErrorReportingClient.ProblemKind.ERROR ? Validator.ValidationHost.ErrorType.ERROR : Validator.ValidationHost.ErrorType.WARNING;
            if (this.myHost instanceof IdeValidationHost) {
                ((IdeValidationHost)this.myHost).addMessageWithFixes(nameIdentifier.getPsi(), s, errorType, fixes);
            } else {
                this.myHost.addMessage(nameIdentifier.getPsi(), s, errorType);
            }
        }
    }
}

