/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.flex.refactoring.moveClass;

import com.intellij.javascript.flex.refactoring.moveClass.FlexMoveClassDialog;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.flex.XmlBackedJSClassImpl;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClass;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClassFactory;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.xml.XmlFile;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.MoveHandlerDelegate;
import java.util.ArrayList;
import org.jetbrains.annotations.Nullable;

public class FlexMoveFileRefactoringHandler
extends MoveHandlerDelegate {
    public boolean tryToMove(PsiElement element, Project project, DataContext dataContext, @Nullable PsiReference reference, Editor editor) {
        JSQualifiedNamedElement adjusted = FlexMoveFileRefactoringHandler.adjustForMove(element);
        if (adjusted == null) {
            return false;
        }
        if (!JSRefactoringUtil.checkReadOnlyStatus((PsiElement)adjusted, (Editor)editor, (String)RefactoringBundle.message((String)"move.title"))) {
            return true;
        }
        this.doMove(project, new PsiElement[]{element}, null, null);
        return true;
    }

    public void doMove(Project project, PsiElement[] elements, @Nullable PsiElement targetContainer, @Nullable MoveCallback callback) {
        if (elements.length == 0) {
            return;
        }
        ArrayList<JSQualifiedNamedElement> adjusted = new ArrayList<JSQualifiedNamedElement>(elements.length);
        for (PsiElement element : elements) {
            JSQualifiedNamedElement e = FlexMoveFileRefactoringHandler.adjustForMove(element);
            if (!JSRefactoringUtil.checkReadOnlyStatus((PsiElement)e, null, (String)RefactoringBundle.message((String)"move.title"))) {
                return;
            }
            adjusted.add(e);
        }
        new FlexMoveClassDialog(project, adjusted, targetContainer, callback).show();
    }

    public boolean isValidTarget(PsiElement psiElement, PsiElement[] sources) {
        return psiElement instanceof PsiDirectoryContainer;
    }

    public boolean canMove(PsiElement[] elements, @Nullable PsiElement targetContainer) {
        if (elements.length == 0) {
            return false;
        }
        JSQualifiedNamedElement first = FlexMoveFileRefactoringHandler.adjustForMove(elements[0]);
        if (first == null) {
            return false;
        }
        if (JSResolveUtil.isFileLocalSymbol((PsiElement)first)) {
            if (elements.length > 1) {
                return false;
            }
            return super.canMove(elements, targetContainer);
        }
        for (PsiElement element : elements) {
            if (FlexMoveFileRefactoringHandler.adjustForMove(element) != null) continue;
            return false;
        }
        return super.canMove(elements, targetContainer);
    }

    @Nullable
    public static JSQualifiedNamedElement adjustForMove(PsiElement element) {
        PsiElement parent;
        PsiFile file = (element = JSResolveUtil.unwrapProxy((PsiElement)element)).getContainingFile();
        if (file == null || !file.getLanguage().is((Language)JavaScriptSupportLoader.ECMA_SCRIPT_L4) && !JavaScriptSupportLoader.isFlexMxmFile((PsiFile)file)) {
            return null;
        }
        if (element instanceof JSPackageStatement) {
            return null;
        }
        if (element instanceof XmlBackedJSClassImpl) {
            return (JSQualifiedNamedElement)element;
        }
        if (element instanceof JSQualifiedNamedElement && ((parent = JSResolveUtil.findParent((PsiElement)element)) instanceof JSPackageStatement || parent instanceof JSFile && JSResolveUtil.getXmlBackedClass((JSFile)((JSFile)parent)) == null)) {
            return (JSQualifiedNamedElement)element;
        }
        if (element instanceof JSVarStatement && ((JSVarStatement)element).getVariables().length == 1 && ((parent = JSResolveUtil.findParent((PsiElement)element)) instanceof JSPackageStatement || parent instanceof JSFile && JSResolveUtil.getXmlBackedClass((JSFile)((JSFile)parent)) == null)) {
            return ((JSVarStatement)element).getVariables()[0];
        }
        if (element instanceof JSFile) {
            XmlBackedJSClass xmlBackedClass = JSResolveUtil.getXmlBackedClass((JSFile)((JSFile)element));
            if (xmlBackedClass != null) {
                return xmlBackedClass;
            }
            return JSPsiImplUtils.findQualifiedElement((JSFile)((JSFile)element));
        }
        if (element instanceof XmlFile && JavaScriptSupportLoader.isFlexMxmFile((PsiFile)((PsiFile)element))) {
            return XmlBackedJSClassFactory.getXmlBackedClass((XmlFile)((XmlFile)element));
        }
        return null;
    }
}

