/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.changesignature;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.changesignature.JSChangeInfo;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.refactoring.changeSignature.JSChangeSignatureDialog;
import com.intellij.lang.javascript.refactoring.changeSignature.JSMethodDescriptor;
import com.intellij.lang.javascript.refactoring.changeSignature.JSParameterInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.changeSignature.ChangeInfo;
import com.intellij.refactoring.changeSignature.LanguageChangeSignatureDetector;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSChangeSignatureDetector
implements LanguageChangeSignatureDetector {
    public ChangeInfo createInitialChangeInfo(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/changesignature/JSChangeSignatureDetector", "createInitialChangeInfo"));
        }
        JSFunction method = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)element, JSFunction.class, (boolean)false);
        if (method == null || !JSChangeSignatureDetector.isInsideMethodSignature(element, method)) {
            return null;
        }
        if (PsiTreeUtil.hasErrorElements((PsiElement)method.getParameterList())) {
            return null;
        }
        return new JSChangeInfo(method);
    }

    private static boolean isInsideMethodSignature(PsiElement element, @NotNull JSFunction method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/lang/javascript/changesignature/JSChangeSignatureDetector", "isInsideMethodSignature"));
        }
        TextRange r = JSChangeSignatureDetector.getRange((PsiElement)method);
        if (r != null && r.contains(element.getTextOffset())) {
            return true;
        }
        if (element instanceof PsiErrorElement && element.getPrevSibling().getNode().getElementType() == JSTokenTypes.COLON) {
            return true;
        }
        return element instanceof PsiWhiteSpace && element.getPrevSibling() instanceof PsiErrorElement && element.getPrevSibling().getPrevSibling().getNode().getElementType() == JSTokenTypes.COLON;
    }

    public boolean performChange(ChangeInfo changeInfo, ChangeInfo initialChangeInfo, final @NotNull String oldText, boolean silently) {
        if (oldText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldText", "com/intellij/lang/javascript/changesignature/JSChangeSignatureDetector", "performChange"));
        }
        final JSChangeInfo jsChangeInfo = (JSChangeInfo)changeInfo;
        JSMethodDescriptor descriptor = new JSMethodDescriptor(jsChangeInfo.getMethod(), false){

            public String getName() {
                return jsChangeInfo.getNewName();
            }

            public List<JSParameterInfo> getParameters() {
                return Arrays.asList(jsChangeInfo.getNewParameters());
            }

            public int getParametersCount() {
                return this.getParameters().size();
            }

            public String getVisibility() {
                return jsChangeInfo.getNewVisibility().name();
            }

            public JSFunction getMethod() {
                return jsChangeInfo.getMethod();
            }
        };
        JSChangeSignatureDialog d = new JSChangeSignatureDialog(descriptor, changeInfo.getMethod()){

            protected void invokeRefactoring(BaseRefactoringProcessor processor) {
                JSChangeSignatureDetector.revertChanges((PsiElement)jsChangeInfo.getMethod(), oldText);
                super.invokeRefactoring(processor);
            }
        };
        return d.showAndGet();
    }

    private static void revertChanges(final PsiElement method, final String oldText) {
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                PsiFile file = method.getContainingFile();
                PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)method.getProject());
                Document document = documentManager.getDocument(file);
                if (document != null) {
                    TextRange textRange = method.getTextRange();
                    document.replaceString(textRange.getStartOffset(), textRange.getEndOffset(), (CharSequence)oldText);
                    documentManager.commitDocument(document);
                }
            }
        });
    }

    public boolean isChangeSignatureAvailableOnElement(PsiElement element, ChangeInfo currentInfo) {
        if (currentInfo instanceof JSChangeInfo) {
            return element.getNode().getElementType() == JSTokenTypes.IDENTIFIER && Comparing.equal((Object)currentInfo.getMethod(), (Object)element.getParent().getParent());
        }
        return false;
    }

    @Nullable
    private static TextRange getRange(PsiElement element) {
        ASTNode colon;
        JSFunction f = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)element, JSFunction.class, (boolean)false);
        if (f == null) {
            return null;
        }
        ASTNode identifier = f.findNameIdentifier();
        if (identifier == null) {
            return null;
        }
        PsiElement e = f.getReturnTypeElement();
        if (e == null && (colon = f.getNode().findChildByType(JSTokenTypes.COLON)) != null) {
            e = colon.getPsi();
        }
        if (e == null) {
            e = f.getParameterList();
        }
        return new TextRange(identifier.getTextRange().getStartOffset(), e.getTextRange().getEndOffset());
    }

    public boolean isMoveParameterAvailable(PsiElement parameter, boolean left) {
        return false;
    }

    public void moveParameter(PsiElement parameter, Editor editor, boolean left) {
    }

    public boolean ignoreChanges(PsiElement element) {
        return false;
    }

    public TextRange getHighlightingRange(ChangeInfo changeInfo) {
        return null;
    }

    public String extractSignature(PsiElement child, @NotNull ChangeInfo initialChangeInfo) {
        if (initialChangeInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initialChangeInfo", "com/intellij/lang/javascript/changesignature/JSChangeSignatureDetector", "extractSignature"));
        }
        return null;
    }

    public ChangeInfo createNextChangeInfo(String signature, @NotNull ChangeInfo currentInfo, String initialName) {
        if (currentInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentInfo", "com/intellij/lang/javascript/changesignature/JSChangeSignatureDetector", "createNextChangeInfo"));
        }
        return null;
    }
}

