/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.actions.airpackage;

import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.lang.javascript.flex.actions.airpackage.PasswordStore;
import com.intellij.lang.javascript.flex.projectStructure.model.AirSigningOptions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.PathUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JSeparator;

public class KeystorePasswordDialog
extends DialogWrapper {
    private JPanel myMainPanel;
    private JCheckBox myRememberPasswordsCheckBox;
    private final Project myProject;
    private final Collection<Trinity<AirSigningOptions, JPasswordField, JPasswordField>> myKeystoresAndPasswordFields;
    private JComponent myPreferredFocusedComponent;

    public KeystorePasswordDialog(Project project, Collection<AirSigningOptions> signingOptionsWithUnknownPasswords) {
        super(project);
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myKeystoresAndPasswordFields = this.createPasswordFields(signingOptionsWithUnknownPasswords);
        this.setTitle(FlexBundle.message("package.air.application.title", new Object[0]));
        this.init();
        this.myRememberPasswordsCheckBox.setSelected(PasswordStore.getInstance(project).isRememberPasswords());
    }

    private Collection<Trinity<AirSigningOptions, JPasswordField, JPasswordField>> createPasswordFields(Collection<AirSigningOptions> signingOptionsWithUnknownPasswords) {
        ArrayList<Trinity<AirSigningOptions, JPasswordField, JPasswordField>> result = new ArrayList<Trinity<AirSigningOptions, JPasswordField, JPasswordField>>();
        JPanel panel = new JPanel(new GridBagLayout());
        this.myMainPanel.add((Component)panel, "Center");
        int row = 0;
        for (AirSigningOptions signingOptions : signingOptionsWithUnknownPasswords) {
            if (row > 0) {
                panel.add((Component)new JSeparator(0), new GridBagConstraints(0, row, 2, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 0), 0, 0));
                ++row;
            }
            panel.add((Component)new JLabel("Keystore file:"), new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 0, 2, 0), 0, 0));
            panel.add((Component)new JLabel(FileUtil.toSystemDependentName((String)signingOptions.getKeystorePath())), new GridBagConstraints(1, row, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 0, 2, 0), 0, 0));
            panel.add((Component)new JLabel("Keystore password:"), new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 0, 2, 0), 0, 0));
            JPasswordField keystorePasswordField = new JPasswordField();
            panel.add((Component)keystorePasswordField, new GridBagConstraints(1, row, 1, 1, 0.0, 0.0, 17, 2, new Insets(2, 0, 2, 0), 0, 0));
            if (row == 1) {
                this.myPreferredFocusedComponent = keystorePasswordField;
            }
            ++row;
            if (signingOptions.getKeyAlias().isEmpty()) {
                result.add((Trinity<AirSigningOptions, JPasswordField, JPasswordField>)Trinity.create((Object)signingOptions, (Object)keystorePasswordField, (Object)null));
                continue;
            }
            panel.add((Component)new JLabel("Key alias:"), new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 0, 2, 0), 0, 0));
            panel.add((Component)new JLabel(signingOptions.getKeyAlias()), new GridBagConstraints(1, row, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 0, 2, 0), 0, 0));
            panel.add((Component)new JLabel("Key password:"), new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 0, 2, 0), 0, 0));
            JPasswordField keyPasswordField = new JPasswordField();
            panel.add((Component)keyPasswordField, new GridBagConstraints(1, row, 1, 1, 0.0, 0.0, 17, 2, new Insets(2, 0, 2, 0), 0, 0));
            ++row;
            result.add((Trinity<AirSigningOptions, JPasswordField, JPasswordField>)Trinity.create((Object)signingOptions, (Object)keystorePasswordField, (Object)keyPasswordField));
        }
        return result;
    }

    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myPreferredFocusedComponent;
    }

    protected ValidationInfo doValidate() {
        for (Trinity<AirSigningOptions, JPasswordField, JPasswordField> entry : this.myKeystoresAndPasswordFields) {
            AirSigningOptions signingOptions = (AirSigningOptions)entry.first;
            JPasswordField keystorePasswordField = (JPasswordField)entry.second;
            String keystorePassword = new String(keystorePasswordField.getPassword());
            JPasswordField keyPasswordField = (JPasswordField)entry.third;
            String keyPassword = keyPasswordField == null ? "" : new String(keyPasswordField.getPassword());
            try {
                PasswordStore.checkPassword(signingOptions, keystorePassword, keyPassword);
            }
            catch (PasswordStore.SigningOptionsException e) {
                JPasswordField errorField = e.wrongKeyPassword ? keyPasswordField : (e.wrongKeystorePassword ? keystorePasswordField : null);
                String message = errorField == null ? PathUtil.getFileName((String)signingOptions.getKeystorePath()) + ": " + e.getMessage() : e.getMessage();
                return new ValidationInfo(message, (JComponent)errorField);
            }
        }
        return null;
    }

    protected void doOKAction() {
        this.storePasswords();
        super.doOKAction();
    }

    private void storePasswords() {
        boolean rememberPasswords = this.myRememberPasswordsCheckBox.isSelected();
        PasswordStore passwordStore = PasswordStore.getInstance(this.myProject);
        passwordStore.setRememberPasswords(rememberPasswords);
        if (rememberPasswords) {
            this.storePasswords(passwordStore);
        } else {
            passwordStore.clearPasswords();
        }
    }

    private void storePasswords(PasswordStore passwordStore) {
        for (Trinity<AirSigningOptions, JPasswordField, JPasswordField> entry : this.myKeystoresAndPasswordFields) {
            AirSigningOptions signingOptions = (AirSigningOptions)entry.first;
            String keystorePassword = new String(((JPasswordField)entry.second).getPassword());
            JPasswordField keyPasswordField = (JPasswordField)entry.third;
            passwordStore.storeKeystorePassword(signingOptions.getKeystorePath(), keystorePassword);
            if (keyPasswordField == null) continue;
            String keyPassword = new String(keyPasswordField.getPassword());
            passwordStore.storeKeyPassword(signingOptions.getKeystorePath(), signingOptions.getKeyAlias(), keyPassword);
        }
    }

    public PasswordStore getPasswords() {
        assert (this.isOK()) : "ask for passwords only after OK in dialog";
        PasswordStore passwordStore = PasswordStore.getInstance(this.myProject);
        if (passwordStore.isRememberPasswords()) {
            return passwordStore;
        }
        PasswordStore temporaryStore = new PasswordStore();
        this.storePasswords(temporaryStore);
        return temporaryStore;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        this.myRememberPasswordsCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Remember passwords for this session");
        jCheckBox.setMnemonic('R');
        jCheckBox.setDisplayedMnemonicIndex(0);
        jCheckBox.setMargin(new Insets(20, 3, 2, 3));
        jPanel.add((Component)jCheckBox, "South");
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

