/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.actions.newfile;

import com.intellij.javascript.flex.mxml.MxmlJSClass;
import com.intellij.javascript.flex.mxml.schema.CodeContext;
import com.intellij.javascript.flex.mxml.schema.CodeContextHolder;
import com.intellij.javascript.flex.mxml.schema.FlexSchemaHandler;
import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.lang.javascript.flex.actions.newfile.CreateFlexComponentFix;
import com.intellij.lang.javascript.flex.actions.newfile.NewActionScriptClassAction;
import com.intellij.lang.javascript.flex.projectStructure.model.FlexBuildConfigurationManager;
import com.intellij.lang.javascript.validation.fixes.CreateClassOrInterfaceFix;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;

public class NewFlexComponentAction
extends NewActionScriptClassAction {
    @NonNls
    private static final String FLEX3_COMPONENT_TEMPLATE_NAME = "Flex 3 Component";
    @NonNls
    private static final String FLEX4_COMPONENT_TEMPLATE_NAME = "Flex 4 Component";
    private static final String[] FLEX_CLASSIFIER_TEMPLATES = new String[]{"Flex 3 Component", "Flex 4 Component"};

    public static boolean isClassifierTemplate(String templateName) {
        return ArrayUtil.contains((String)templateName, (String[])FLEX_CLASSIFIER_TEMPLATES);
    }

    @Override
    protected boolean isAvailableIn(Module module) {
        return super.isAvailableIn(module) && !FlexBuildConfigurationManager.getInstance(module).getActiveConfiguration().isPureAs();
    }

    @Override
    protected CreateClassOrInterfaceFix createAction(PsiDirectory dir) {
        return new CreateFlexComponentFix(dir);
    }

    @Override
    protected String getCommandName() {
        return FlexBundle.message("new.flex.component.command.name", new Object[0]);
    }

    public static void setParentComponent(MxmlJSClass clazz, String newParentQname) {
        Pair<String, String> prefixAndNamespace = NewFlexComponentAction.getPrefixAndNamespace(clazz.getParent(), newParentQname);
        clazz.setBaseComponent(newParentQname, (String)prefixAndNamespace.first, (String)prefixAndNamespace.second);
    }

    public static Pair<String, String> getPrefixAndNamespace(XmlTag tag, String qName) {
        String namespace2;
        String[] stringArray;
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)tag);
        boolean isFlex4Template = ArrayUtil.contains((String)"http://ns.adobe.com/mxml/2009", (String[])tag.knownNamespaces());
        CodeContextHolder holder = CodeContextHolder.getInstance(module.getProject());
        CodeContext.getContext("library://ns.adobe.com/flex/spark", module);
        Collection<String> namespaces = holder.getNamespaces(module);
        if (isFlex4Template) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "http://www.adobe.com/2006/mxml";
        } else {
            stringArray = MxmlJSClass.FLEX_4_NAMESPACES;
        }
        String[] illegalNamespaces = stringArray;
        for (String namespace2 : namespaces) {
            CodeContext codeContext;
            if (ArrayUtil.contains((String)namespace2, (String[])illegalNamespaces) || CodeContext.isPackageBackedNamespace(namespace2) || (codeContext = CodeContext.isStdNamespace(namespace2) ? holder.getStandardContext(namespace2, module) : holder.getCodeContext(namespace2, module)) == null || codeContext.getElementDescriptor(StringUtil.getShortName((String)qName), qName) == null) continue;
            return Pair.create((Object)FlexSchemaHandler.getDefaultPrefix(namespace2), (Object)namespace2);
        }
        String packageName = StringUtil.getPackageName((String)qName);
        namespace2 = StringUtil.isEmpty((String)packageName) ? "*" : packageName + ".*";
        return Pair.create((Object)FlexSchemaHandler.getDefaultPrefix(namespace2), (Object)namespace2);
    }
}

