/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.build;

import com.intellij.flex.FlexCommonUtils;
import com.intellij.flex.model.bc.OutputType;
import com.intellij.lang.javascript.flex.FlexUtils;
import com.intellij.lang.javascript.flex.build.FlexCompilationManager;
import com.intellij.lang.javascript.flex.build.FlexCompilationTask;
import com.intellij.lang.javascript.flex.build.FlexCompilationUtils;
import com.intellij.lang.javascript.flex.projectStructure.model.FlexBuildConfiguration;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.util.text.StringTokenizer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ASC20CompilationTask
extends FlexCompilationTask {
    private Process myProcess;
    @Nullable
    private String myPreviousUnreportedMessage;

    public ASC20CompilationTask(@NotNull Module module, @NotNull FlexBuildConfiguration bc, @NotNull Collection<FlexBuildConfiguration> dependencies) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/lang/javascript/flex/build/ASC20CompilationTask", "<init>"));
        }
        if (bc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bc", "com/intellij/lang/javascript/flex/build/ASC20CompilationTask", "<init>"));
        }
        if (dependencies == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencies", "com/intellij/lang/javascript/flex/build/ASC20CompilationTask", "<init>"));
        }
        super(module, bc, dependencies);
    }

    @Override
    protected void doStart(FlexCompilationManager compilationManager) throws IOException {
        boolean app = this.myBC.getOutputType() != OutputType.Library;
        Sdk sdk = this.myBC.getSdk();
        assert (sdk != null);
        List<String> compilerCommand = FlexCompilationUtils.getASC20Command(this.myModule.getProject(), sdk, app);
        List<String> command = FlexCompilationUtils.buildCommand(compilerCommand, this.getConfigFiles(), this.myModule, this.myBC);
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        processBuilder.redirectErrorStream(true);
        processBuilder.directory(new File(FlexUtils.getFlexCompilerWorkDirPath(this.myModule.getProject(), null)));
        compilationManager.addMessage(this, CompilerMessageCategory.INFORMATION, StringUtil.join(command, (String)" "), null, -1, -1);
        this.myProcess = processBuilder.start();
        this.readInputStream(compilationManager);
    }

    @Override
    protected void doCancel() {
        if (this.myProcess != null) {
            this.myProcess.destroy();
        }
    }

    private void readInputStream(final FlexCompilationManager compilationManager) {
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                InputStreamReader reader = FlexCommonUtils.createInputStreamReader((InputStream)ASC20CompilationTask.this.myProcess.getInputStream());
                try {
                    int read;
                    char[] buf = new char[2048];
                    while ((read = reader.read(buf, 0, buf.length)) >= 0) {
                        String output = new String(buf, 0, read);
                        StringTokenizer tokenizer = new StringTokenizer(output, "\r\n");
                        while (tokenizer.hasMoreElements()) {
                            boolean ok;
                            String message = tokenizer.nextElement();
                            if (StringUtil.isEmptyOrSpaces((String)message) || (ok = ASC20CompilationTask.this.handleCompilerMessage(compilationManager, message.trim()))) continue;
                            ASC20CompilationTask.this.myCompilationFailed = true;
                        }
                    }
                    ASC20CompilationTask.this.printPreviousLine(compilationManager);
                }
                catch (IOException e) {
                    compilationManager.addMessage(ASC20CompilationTask.this, CompilerMessageCategory.ERROR, e.getMessage(), null, -1, -1);
                    ASC20CompilationTask.this.myCompilationFailed = true;
                }
                finally {
                    ASC20CompilationTask.this.cancel();
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        });
    }

    private boolean handleCompilerMessage(FlexCompilationManager compilationManager, String message) {
        if ("^".equals(message)) {
            this.myPreviousUnreportedMessage = null;
            return true;
        }
        if ("command line".equals(message)) {
            this.printPreviousLine(compilationManager);
            return true;
        }
        if (message.startsWith("Exception in thread \"")) {
            this.printPreviousLine(compilationManager);
            compilationManager.addMessage(this, CompilerMessageCategory.ERROR, message, null, -1, -1);
            return false;
        }
        if (message.startsWith("Warning: ") || message.startsWith("Error: ") || message.startsWith("Syntax error: ") || message.startsWith("Internal error: ")) {
            CompilerMessageCategory category = message.startsWith("Warning: ") ? CompilerMessageCategory.WARNING : CompilerMessageCategory.ERROR;
            int index = message.indexOf(": ");
            String usefulMessage = message.substring(index + ": ".length());
            Pair sourcePathAndLine = FlexCommonUtils.getSourcePathAndLineFromASC20Message((String)this.myPreviousUnreportedMessage);
            if (sourcePathAndLine == null) {
                this.printPreviousLine(compilationManager);
                compilationManager.addMessage(this, category, usefulMessage, null, -1, -1);
            } else if (!this.isNotSupportedOptionFromGeneratedConfig(usefulMessage, (String)sourcePathAndLine.first)) {
                compilationManager.addMessage(this, category, usefulMessage, VfsUtilCore.pathToUrl((String)((String)sourcePathAndLine.first)), (Integer)sourcePathAndLine.second, -1);
            }
            this.myPreviousUnreportedMessage = null;
            return category == CompilerMessageCategory.WARNING;
        }
        this.printPreviousLine(compilationManager);
        this.myPreviousUnreportedMessage = message;
        return true;
    }

    private boolean isNotSupportedOptionFromGeneratedConfig(String message, String filePath) {
        return filePath.equals(this.getConfigFiles().get(0).getPath()) && ("'compiler.locale' is not fully supported.".equals(message) || "'compiler.theme' is not fully supported.".equals(message) || "'compiler.preloader' is not fully supported.".equals(message) || "'compiler.accessible' is not fully supported.".equals(message) || "'compiler.fonts.managers' is not fully supported.".equals(message) || "'static-link-runtime-shared-libraries' is not fully supported.".equals(message));
    }

    private void printPreviousLine(FlexCompilationManager compilationManager) {
        if (this.myPreviousUnreportedMessage != null) {
            if (!(this.myPreviousUnreportedMessage.equals("<theme />") || this.myPreviousUnreportedMessage.equals("</locale>") || this.myPreviousUnreportedMessage.equals("<preloader>spark.preloaders.SplashScreen</preloader>") || this.myPreviousUnreportedMessage.equals("<accessible>true</accessible>") || this.myPreviousUnreportedMessage.equals("<accessible>false</accessible>") || this.myPreviousUnreportedMessage.equals("</managers>") || this.myPreviousUnreportedMessage.equals("<static-link-runtime-shared-libraries>false</static-link-runtime-shared-libraries>"))) {
                compilationManager.addMessage(this, CompilerMessageCategory.INFORMATION, this.myPreviousUnreportedMessage, null, -1, -1);
            }
            this.myPreviousUnreportedMessage = null;
        }
    }
}

