/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.flashbuilder;

import com.intellij.CommonBundle;
import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.Nullable;

public class FlashBuilderProjectFinder {
    public static final String PROJECT_PREFS_RELATIVE_PATH = "/.metadata/.plugins/org.eclipse.core.runtime/.settings/com.adobe.flexbuilder.project.prefs";
    static final String SDKS_RELATIVE_PATH = "/sdks";
    private static final String PROJECTS_CACHE_RELATIVE_PATH = "/.metadata/.plugins/org.eclipse.core.resources/.projects";
    private static final String DOT_LOCATION = ".location";

    static boolean isFlashBuilderWorkspace(VirtualFile file) {
        return file != null && file.isDirectory() && VfsUtil.findRelativeFile((String)PROJECT_PREFS_RELATIVE_PATH, (VirtualFile)file) != null;
    }

    static boolean isFlashBuilderWorkspace(String dirPath) {
        return new File(dirPath + PROJECT_PREFS_RELATIVE_PATH).isFile();
    }

    static boolean isFlashBuilderProject(VirtualFile file) {
        VirtualFile dir = file == null ? null : file.getParent();
        return file != null && !file.isDirectory() && ".project".equals(file.getName()) && dir != null && dir.findChild(".actionScriptProperties") != null;
    }

    static boolean isFlashBuilderProject(File file) {
        File dir = file == null ? null : file.getParentFile();
        File dotActionScriptPropertiesFile = dir == null ? null : new File(dir, ".actionScriptProperties");
        return file != null && ".project".equals(file.getName()) && file.isFile() && dotActionScriptPropertiesFile != null && dotActionScriptPropertiesFile.isFile();
    }

    static boolean collectAllProjectPaths(@Nullable Project project, final List<String> projectPaths, final String dirPath) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (FlashBuilderProjectFinder.isFlashBuilderWorkspace(dirPath)) {
                    FlashBuilderProjectFinder.collectProjectPathsInWorkspace(projectPaths, dirPath);
                } else {
                    FlashBuilderProjectFinder.collectProjectPathsInDirectory(projectPaths, dirPath);
                }
            }
        };
        return ProgressManager.getInstance().runProcessWithProgressSynchronously(runnable, FlexBundle.message("looking.for.flash.builder.projects", new Object[0]), true, project);
    }

    private static void collectProjectPathsInWorkspace(List<String> projectPaths, String workspacePath) {
        File[] subdirs;
        File projectsCacheDir = new File(workspacePath, PROJECTS_CACHE_RELATIVE_PATH);
        if (!projectsCacheDir.isDirectory()) {
            return;
        }
        for (File dir : subdirs = projectsCacheDir.listFiles(FileUtilRt.ALL_DIRECTORIES)) {
            String dotProjectFileLocation = FlashBuilderProjectFinder.getDotProjectFileLocation(workspacePath, dir);
            if (dotProjectFileLocation == null) continue;
            projectPaths.add(dotProjectFileLocation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static String getDotProjectFileLocation(String workspacePath, File projectCacheDir) {
        File dotProjectFile;
        String projectName = projectCacheDir.getName();
        File dotLocationFile = new File(projectCacheDir + "/" + DOT_LOCATION);
        if (dotLocationFile.isFile()) {
            FilterInputStream input = null;
            try {
                URI dotProjectUri;
                File dotProjectFile2;
                String projectUriUri;
                input = new DataInputStream(new FileInputStream(dotLocationFile));
                int CHUNK_START_LENGTH = 16;
                String URI_PREFIX = "URI//";
                long skipped = input.skip(16L);
                if (skipped == 16L && (projectUriUri = ((DataInputStream)input).readUTF()) != null && projectUriUri.startsWith("URI//") && FlashBuilderProjectFinder.isFlashBuilderProject(dotProjectFile2 = new File(dotProjectUri = new URI(projectUriUri.substring("URI//".length()) + "/" + ".project")))) {
                    String string = dotProjectFile2.getPath();
                    return string;
                }
            }
            catch (IOException iOException) {
            }
            catch (URISyntaxException uRISyntaxException) {
            }
            finally {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        if (FlashBuilderProjectFinder.isFlashBuilderProject(dotProjectFile = new File(workspacePath + "/" + projectName + "/" + ".project"))) {
            return dotProjectFile.getPath();
        }
        return null;
    }

    private static void collectProjectPathsInDirectory(List<String> projectPaths, String dirPath) {
        File dotProjectFile;
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        if (progressIndicator != null) {
            progressIndicator.checkCanceled();
            progressIndicator.setText2(dirPath);
        }
        if (FlashBuilderProjectFinder.isFlashBuilderProject(dotProjectFile = new File(dirPath, ".project"))) {
            projectPaths.add(dotProjectFile.getPath());
        } else {
            File[] subdirs;
            File root = new File(dirPath);
            for (File subdir : subdirs = root.listFiles(FileUtilRt.ALL_DIRECTORIES)) {
                FlashBuilderProjectFinder.collectProjectPathsInDirectory(projectPaths, subdir.getPath());
            }
        }
    }

    static boolean hasArchiveExtension(String path) {
        return path.endsWith(".fxp") || path.endsWith(".fxpl") || path.endsWith(".zip");
    }

    static boolean hasFxpExtension(String path) {
        String lowercased = path.toLowerCase();
        return lowercased.endsWith(".fxp") || lowercased.endsWith(".fxpl");
    }

    static void checkArchiveContainsFBProject(String archiveFilePath) throws ConfigurationException {
        FlashBuilderProjectFinder._isMultiProjectArchive(archiveFilePath);
    }

    static boolean isMultiProjectArchive(String archiveFilePath) {
        try {
            return FlashBuilderProjectFinder._isMultiProjectArchive(archiveFilePath);
        }
        catch (ConfigurationException e) {
            return false;
        }
    }

    private static boolean _isMultiProjectArchive(String archiveFilePath) throws ConfigurationException {
        boolean containsDotProjectFile = false;
        boolean containsDotActionScriptFile = false;
        boolean containsNestedProjects = false;
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(archiveFilePath);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                String entryName = entries.nextElement().getName();
                if (".project".equals(entryName)) {
                    containsDotProjectFile = true;
                }
                if (".actionScriptProperties".equals(entryName)) {
                    containsDotActionScriptFile = true;
                }
                if (entryName.endsWith(".fxp") || entryName.endsWith(".fxpl")) {
                    containsNestedProjects = true;
                }
                if (!containsDotProjectFile || !containsDotActionScriptFile || !containsNestedProjects) continue;
                break;
            }
            if (!containsDotProjectFile || !containsDotActionScriptFile) {
                throw new ConfigurationException(FlexBundle.message("does.not.contain.flash.builder.projects", new Object[0]), CommonBundle.getErrorTitle());
            }
            boolean bl = containsNestedProjects;
            return bl;
        }
        catch (IOException e) {
            throw new ConfigurationException(FlexBundle.message("does.not.contain.flash.builder.projects", new Object[0]), CommonBundle.getErrorTitle());
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

