/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.flexunit;

import com.intellij.execution.ExecutionException;
import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;

public abstract class ServerConnectionBase {
    private static final Logger LOG = Logger.getInstance((String)ServerConnectionBase.class.getName());
    private final Object myLock = new Object();
    private ConnectionStatus myStatus = ConnectionStatus.NOT_CONNECTED;
    private boolean myStopped;
    private ServerSocket myServerSocket;
    private OutputStreamWriter myWriter;
    private static final int ACCEPT_TIMEOUT = 250;

    public void open(int port) throws ExecutionException {
        try {
            this.myServerSocket = new ServerSocket(port);
            this.myServerSocket.setSoTimeout(250);
        }
        catch (IOException e) {
            throw new ExecutionException(FlexBundle.message("port.is.busy", port), (Throwable)e);
        }
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                try {
                    ServerConnectionBase.this.doRun();
                    ServerConnectionBase.this.setStatus(ConnectionStatus.DISCONNECTED);
                }
                catch (IOException e) {
                    LOG.warn((Throwable)e);
                    ServerConnectionBase.this.setStatus(ConnectionStatus.CONNECTION_FAILED);
                }
            }
        });
    }

    public static int getFreePort(int defaultPort, int attempts) {
        for (int i = 0; i < attempts; ++i) {
            int port = defaultPort + i;
            if (!ServerConnectionBase.tryPort(port)) continue;
            return port;
        }
        return -1;
    }

    public static boolean tryPort(int port) {
        try {
            ServerSocket socket = new ServerSocket(port);
            socket.close();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setStatus(ConnectionStatus status) {
        Object object = this.myLock;
        synchronized (object) {
            this.myStatus = status;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionStatus getStatus() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myStatus;
        }
    }

    public void write(String text) {
        if (this.getStatus() != ConnectionStatus.CONNECTED || this.myWriter == null) {
            return;
        }
        try {
            this.myWriter.write(text);
            this.myWriter.flush();
        }
        catch (IOException e) {
            LOG.warn("Failed to write", (Throwable)e);
        }
    }

    protected abstract void run(InputStream var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRun() throws IOException {
        try {
            this.setStatus(ConnectionStatus.WAITING_FOR_CONNECTION);
            LOG.debug("listening port " + this.myServerSocket.getLocalPort() + ", timeout: " + this.myServerSocket.getSoTimeout() + " ms");
            Socket socket = null;
            while (!this.isStopped() && socket == null) {
                try {
                    socket = this.myServerSocket.accept();
                }
                catch (SocketTimeoutException socketTimeoutException) {}
            }
            if (socket == null) {
                return;
            }
            try {
                this.setStatus(ConnectionStatus.CONNECTED);
                LOG.debug("connected");
                this.myWriter = new OutputStreamWriter(socket.getOutputStream());
                this.run(socket.getInputStream());
            }
            finally {
                LOG.debug("closing client socket");
                socket.close();
                this.myWriter.close();
                this.myWriter = null;
            }
        }
        finally {
            this.myServerSocket.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        LOG.debug("stopping");
        Object object = this.myLock;
        synchronized (object) {
            if (this.myStopped) {
                return;
            }
            this.myStopped = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isStopped() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myStopped;
        }
    }

    public static enum ConnectionStatus {
        NOT_CONNECTED,
        WAITING_FOR_CONNECTION,
        CONNECTED,
        DISCONNECTED,
        CONNECTION_FAILED;

    }
}

