/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.importer;

import com.intellij.lang.actionscript.psi.stubs.impl.ActionScriptFunctionStubImpl;
import com.intellij.lang.actionscript.psi.stubs.impl.ActionScriptVariableStubImpl;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.flex.importer.AS3InterfaceDumper;
import com.intellij.lang.javascript.flex.importer.Abc;
import com.intellij.lang.javascript.flex.importer.MemberInfo;
import com.intellij.lang.javascript.flex.importer.MetaData;
import com.intellij.lang.javascript.flex.importer.MethodInfo;
import com.intellij.lang.javascript.flex.importer.Multiname;
import com.intellij.lang.javascript.flex.importer.SlotInfo;
import com.intellij.lang.javascript.flex.importer.Traits;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSStubElementType;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.stubs.impl.JSAttributeListStubImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSAttributeNameValuePairStubImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSAttributeStubImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSClassStubImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSParameterListStubImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSParameterStubImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSReferenceListStubImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSVarStatementStubImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.SmartList;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AS3InterfaceStubDumper
extends AS3InterfaceDumper {
    final LinkedList<StubElement> parents = new LinkedList();
    private static final JSAttributeList.AccessType[] ourAccessTypes = JSAttributeList.AccessType.values();
    private static final JSAttributeList.ModifierType[] ourModifierTypes = JSAttributeList.ModifierType.values();

    public AS3InterfaceStubDumper(StubElement parent) {
        this.parents.add(parent);
    }

    @Override
    public void processMetadata(MetaData metaData) {
        this.parents.addLast((StubElement)new JSAttributeStubImpl(metaData.name, this.parents.getLast()));
        super.processMetadata(metaData);
        this.parents.removeLast();
    }

    @Override
    public void addMetaDataValue(String s, String s1) {
        new JSAttributeNameValuePairStubImpl(s, StringUtil.stripQuotesAroundValue((String)s1), this.parents.getLast());
    }

    @Override
    protected void processArgumentList(MethodInfo methodInfo, String parentName) {
        this.parents.add((StubElement)new JSParameterListStubImpl(this.parents.getLast()));
        super.processArgumentList(methodInfo, parentName);
        this.parents.removeLast();
    }

    @Override
    public void processParameter(@NotNull String name, @Nullable Multiname type, String parentName, @Nullable Multiname value, boolean rest) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/flex/importer/AS3InterfaceStubDumper", "processParameter"));
        }
        new JSParameterStubImpl(name, rest, this.getTypeRef(type, parentName), AS3InterfaceStubDumper.getValueRepr(value), this.parents.getLast());
    }

    @Override
    public void append(@NotNull @NonNls String str) {
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/lang/javascript/flex/importer/AS3InterfaceStubDumper", "append"));
        }
    }

    @Override
    public void processFunction(MethodInfo methodInfo, boolean referenceNameRequested, Abc abc, String indent, String attr) {
        this.parents.add((StubElement)new ActionScriptFunctionStubImpl(methodInfo.name.name, methodInfo.isGetMethod() ? JSFunction.FunctionKind.GETTER : (methodInfo.isSetMethod() ? JSFunction.FunctionKind.SETTER : (methodInfo.parentTraits != null && methodInfo.parentTraits.name == methodInfo.name ? JSFunction.FunctionKind.CONSTRUCTOR : JSFunction.FunctionKind.SIMPLE)), this.getMultinameAsPackageName(methodInfo.name, methodInfo.parentTraits != null ? methodInfo.parentTraits.getClassName() : null), this.getTypeRef(methodInfo.returnType, methodInfo.getParentName()), "static ".equals(attr) ? JSContext.STATIC : JSContext.INSTANCE, this.getAccessType(methodInfo), this.parents.getLast()));
        super.processFunction(methodInfo, referenceNameRequested, abc, indent, attr);
        this.parents.removeLast();
    }

    @Override
    public void processVariable(SlotInfo info, String indent, String attr) {
        this.parents.add((StubElement)new JSVarStatementStubImpl(this.parents.getLast()));
        super.processVariable(info, indent, attr);
        String parentName = info.getParentName();
        String qName = this.getMultinameAsPackageName(info.name, parentName);
        new ActionScriptVariableStubImpl(qName.substring(qName.lastIndexOf(46) + 1), info.isConst(), this.getTypeRef(info.type, parentName), AS3InterfaceStubDumper.getValueRepr(info.value), qName, "static ".equals(attr) ? JSContext.STATIC : JSContext.INSTANCE, this.getAccessType(info), this.parents.getLast());
        this.parents.removeLast();
    }

    @Override
    public void processClass(SlotInfo slotInfo, Abc abc, String attr, String indent) {
        this.parents.add((StubElement)new JSClassStubImpl(slotInfo.name.name, slotInfo.isInterfaceClass(), this.getMultinameAsPackageName(slotInfo.name, null), this.getAccessType(slotInfo), this.parents.getLast()));
        super.processClass(slotInfo, abc, attr, indent);
        this.parents.removeLast();
    }

    @NotNull
    private JSAttributeList.AccessType getAccessType(MemberInfo memberInfo) {
        String nsName = memberInfo.name.getNsName(memberInfo);
        JSAttributeList.AccessType accessType = JSAttributeList.AccessType.PACKAGE_LOCAL;
        if ("public".equals(nsName)) {
            accessType = JSAttributeList.AccessType.PUBLIC;
        } else if ("protected".equals(nsName)) {
            accessType = JSAttributeList.AccessType.PROTECTED;
        } else if ("private".equals(nsName)) {
            accessType = JSAttributeList.AccessType.PRIVATE;
        } else if ("internal".equals(nsName)) {
            accessType = JSAttributeList.AccessType.PACKAGE_LOCAL;
        }
        JSAttributeList.AccessType accessType2 = accessType;
        if (accessType2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/importer/AS3InterfaceStubDumper", "getAccessType"));
        }
        return accessType2;
    }

    @Override
    protected void processModifierList(MemberInfo memberInfo, String attr, String indent) {
        StringTokenizer tokenizer = new StringTokenizer(attr, " ");
        SmartList modifiers = new SmartList();
        JSAttributeList.AccessType accessType = null;
        String ns = null;
        while (tokenizer.hasMoreTokens()) {
            String next = tokenizer.nextToken();
            boolean foundModifier = false;
            for (JSAttributeList.AccessType accessType2 : ourAccessTypes) {
                if (!next.equalsIgnoreCase(accessType2.name())) continue;
                accessType = accessType2;
                foundModifier = true;
                break;
            }
            if (!foundModifier) {
                for (JSAttributeList.AccessType accessType3 : ourModifierTypes) {
                    if (!next.equalsIgnoreCase(accessType3.name())) continue;
                    modifiers.add(accessType3);
                    foundModifier = true;
                    break;
                }
            }
            if (foundModifier) continue;
            ns = next;
        }
        Traits parentTraits = memberInfo.parentTraits;
        if (parentTraits.staticTrait != null) {
            parentTraits = parentTraits.staticTrait;
        }
        String resolvedNs = null;
        if (parentTraits.usedNamespacesToNamesMap != null) {
            List keysByValue = parentTraits.usedNamespacesToNamesMap.getKeysByValue(ns);
            resolvedNs = keysByValue != null && keysByValue.size() > 0 ? (String)keysByValue.get(0) : null;
        }
        this.parents.add((StubElement)new JSAttributeListStubImpl(this.parents.getLast(), ns, resolvedNs, accessType, modifiers.toArray(new JSAttributeList.ModifierType[modifiers.size()])));
        super.processModifierList(memberInfo, attr, indent);
        this.parents.removeLast();
    }

    @Override
    protected void dumpExtendsList(Traits it) {
        if (!it.base.isStarReference()) {
            JSStubElementTypes.DEFAULT_EXTENDS_LIST.createStub(new String[]{this.getTypeRef(it.base, null)}, this.parents.getLast());
        }
    }

    @Override
    protected void dumpInterfacesList(String indent, Traits it, boolean anInterface) {
        if (it.interfaces.length > 0) {
            String[] interfaces = new String[it.interfaces.length];
            int i = 0;
            for (Multiname name : it.interfaces) {
                interfaces[i++] = this.getTypeRef(name, null);
            }
            new JSReferenceListStubImpl(interfaces, this.parents.getLast(), (JSStubElementType)(anInterface ? JSStubElementTypes.DEFAULT_EXTENDS_LIST : JSStubElementTypes.IMPLEMENTS_LIST));
        }
    }
}

