/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.projectStructure;

import com.intellij.flex.model.bc.BuildConfigurationNature;
import com.intellij.flex.model.bc.OutputType;
import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.lang.javascript.flex.FlexModuleType;
import com.intellij.lang.javascript.flex.projectStructure.BuildConfigurationNode;
import com.intellij.lang.javascript.flex.projectStructure.LazyInitializer;
import com.intellij.lang.javascript.flex.projectStructure.model.ModifiableFlexBuildConfiguration;
import com.intellij.lang.javascript.flex.projectStructure.model.SdkEntry;
import com.intellij.lang.javascript.flex.projectStructure.model.impl.Factory;
import com.intellij.lang.javascript.flex.projectStructure.model.impl.FlexProjectConfigurationEditor;
import com.intellij.lang.javascript.flex.projectStructure.ui.AddBuildConfigurationDialog;
import com.intellij.lang.javascript.flex.projectStructure.ui.CompositeConfigurable;
import com.intellij.lang.javascript.flex.projectStructure.ui.FlexBCConfigurable;
import com.intellij.lang.javascript.flex.sdk.FlexSdkUtils;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesModifiableModel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ModuleStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureDaemonAnalyzer;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.navigation.Place;
import com.intellij.util.EventDispatcher;
import com.intellij.util.Function;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.BidirectionalMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlexBCConfigurator {
    private static final Logger LOG = Logger.getInstance((String)FlexBCConfigurator.class.getName());
    private final BidirectionalMap<ModifiableFlexBuildConfiguration, CompositeConfigurable> myConfigurablesMap = new BidirectionalMap();
    private final BidirectionalMap<ModifiableFlexBuildConfiguration, String> myBCToOutputPathMap = new BidirectionalMap();
    private final EventDispatcher<Listener> myEventDispatcher = EventDispatcher.create(Listener.class);
    private final LazyInitializer<Project> myModifiableModelInitializer = new LazyInitializer<Project>(){

        @Override
        protected void initialize(final Project project) {
            LOG.assertTrue(FlexBCConfigurator.this.myConfigEditor == null);
            final ModulesConfigurator configurator = ModuleStructureConfigurable.getInstance((Project)project).getContext().getModulesConfigurator();
            FlexBCConfigurator.this.myConfigEditor = new FlexProjectConfigurationEditor(project, new FlexProjectConfigurationEditor.ProjectModifiableModelProvider(){

                @Override
                public Module[] getModules() {
                    return configurator.getModuleModel().getModules();
                }

                @Override
                public ModifiableRootModel getModuleModifiableModel(Module module) {
                    return configurator.getOrCreateModuleEditor(module).getModifiableRootModelProxy();
                }

                @Override
                public void addListener(Listener listener, Disposable parentDisposable) {
                    FlexBCConfigurator.this.addListener(listener, parentDisposable);
                }

                @Override
                public void commitModifiableModels() throws ConfigurationException {
                    configurator.apply();
                }

                public LibraryTable.ModifiableModel getLibrariesModifiableModel(String level) {
                    return ProjectStructureConfigurable.getInstance((Project)project).getContext().createModifiableModelProvider(level).getModifiableModel();
                }

                @Override
                public Library findSourceLibraryForLiveName(final String name, String level) {
                    final LibrariesModifiableModel model = ProjectStructureConfigurable.getInstance((Project)project).getContext().createModifiableModelProvider(level).getModifiableModel();
                    return (Library)ContainerUtil.find((Object[])model.getLibraries(), (Condition)new Condition<Library>(){

                        public boolean value(Library library) {
                            return name.equals(model.getLibraryEditor(library).getModel().getName());
                        }
                    });
                }

                @Override
                public Library findSourceLibrary(String name, String level) {
                    return this.getLibrariesModifiableModel(level).getLibraryByName(name);
                }
            });
        }

        @Override
        public void doDispose() {
            Disposer.dispose((Disposable)FlexBCConfigurator.this.myConfigEditor);
            FlexBCConfigurator.this.myConfigEditor = null;
        }
    };
    private FlexProjectConfigurationEditor myConfigEditor;

    @Nullable
    public FlexProjectConfigurationEditor getConfigEditor() {
        return this.myConfigEditor;
    }

    public void addListener(Listener listener, Disposable parentDisposable) {
        this.myEventDispatcher.addListener((EventListener)listener, parentDisposable);
    }

    public void reset(Project project) {
        this.myModifiableModelInitializer.ensureInitialized(project);
        ModuleStructureConfigurable moduleStructureConfigurable = ModuleStructureConfigurable.getInstance((Project)project);
        for (CompositeConfigurable configurable : this.myConfigurablesMap.values()) {
            moduleStructureConfigurable.ensureInitialized((NamedConfigurable)configurable);
        }
    }

    public List<CompositeConfigurable> getOrCreateConfigurables(Module module, Runnable treeNodeNameUpdater) {
        this.myModifiableModelInitializer.ensureInitialized(module.getProject());
        ModifiableFlexBuildConfiguration[] configurations = this.myConfigEditor.getConfigurations(module);
        ArrayList<CompositeConfigurable> configurables = new ArrayList<CompositeConfigurable>(configurations.length);
        for (ModifiableFlexBuildConfiguration bc : configurations) {
            CompositeConfigurable configurable = (CompositeConfigurable)((Object)this.myConfigurablesMap.get((Object)bc));
            if (configurable == null) {
                configurable = this.createBcConfigurable(module, bc, treeNodeNameUpdater);
                this.myConfigurablesMap.put((Object)bc, (Object)configurable);
            }
            configurables.add(configurable);
        }
        return configurables;
    }

    private CompositeConfigurable createBcConfigurable(Module module, final ModifiableFlexBuildConfiguration bc, final Runnable treeNodeNameUpdater) {
        ProjectStructureConfigurable c = ProjectStructureConfigurable.getInstance((Project)module.getProject());
        Runnable bcNatureModifier = this.createBCNatureModifier(bc);
        return new FlexBCConfigurable(module, bc, bcNatureModifier, this.myConfigEditor, c.getProjectJdksModel(), c.getContext()){

            @Override
            public void apply() throws ConfigurationException {
                super.apply();
                FlexBCConfigurator.this.myBCToOutputPathMap.put((Object)bc, (Object)bc.getActualOutputFilePath());
            }

            @Override
            public void setDisplayName(String name) {
                super.setDisplayName(name);
                treeNodeNameUpdater.run();
                ((Listener)FlexBCConfigurator.this.myEventDispatcher.getMulticaster()).buildConfigurationRenamed(this);
            }
        }.wrapInTabs();
    }

    private Runnable createBCNatureModifier(final ModifiableFlexBuildConfiguration bc) {
        return new Runnable(){

            @Override
            public void run() {
                CompositeConfigurable compositeConfigurable = (CompositeConfigurable)((Object)FlexBCConfigurator.this.myConfigurablesMap.get((Object)bc));
                BuildConfigurationNature oldNature = bc.getNature();
                AddBuildConfigurationDialog dialog = new AddBuildConfigurationDialog(FlexBCConfigurator.this.myConfigEditor.getProject(), FlexBundle.message("change.bc.type.title", new Object[0]), Collections.<String>emptyList(), oldNature, false);
                dialog.reset(bc.getName(), bc.getAndroidPackagingOptions().isEnabled(), bc.getIosPackagingOptions().isEnabled());
                if (!dialog.showAndGet()) {
                    return;
                }
                BuildConfigurationNature newNature = dialog.getNature();
                if (newNature.equals((Object)oldNature)) {
                    if (newNature.isApp() && newNature.isMobilePlatform()) {
                        bc.getAndroidPackagingOptions().setEnabled(dialog.isAndroidEnabled());
                        bc.getIosPackagingOptions().setEnabled(dialog.isIOSEnabled());
                        compositeConfigurable.reset();
                    }
                    return;
                }
                bc.setNature(newNature);
                FlexBCConfigurator.fixOutputFileExtension(bc);
                if (newNature.targetPlatform != oldNature.targetPlatform || newNature.outputType != oldNature.outputType) {
                    FlexBCConfigurator.updatePackageFileName(bc, PathUtil.suggestFileName((String)bc.getName()));
                }
                if (newNature.isApp() && newNature.isMobilePlatform()) {
                    bc.getAndroidPackagingOptions().setEnabled(dialog.isAndroidEnabled());
                    bc.getIosPackagingOptions().setEnabled(dialog.isIOSEnabled());
                }
                FlexProjectConfigurationEditor.resetNonApplicableValuesToDefaults(bc);
                FlexBCConfigurable bcConfigurable = FlexBCConfigurable.unwrap(compositeConfigurable);
                bcConfigurable.createChildConfigurables();
                bcConfigurable.updateTabs(compositeConfigurable);
                compositeConfigurable.reset();
                ((Listener)FlexBCConfigurator.this.myEventDispatcher.getMulticaster()).natureChanged(bcConfigurable);
            }
        };
    }

    private static void fixOutputFileExtension(ModifiableFlexBuildConfiguration bc) {
        String extension;
        String outputFileName = bc.getOutputFileName();
        String lowercase = outputFileName.toLowerCase();
        String string = extension = bc.getOutputType() == OutputType.Library ? ".swc" : ".swf";
        if (lowercase.endsWith(".swf") || lowercase.endsWith(".swc")) {
            bc.setOutputFileName(outputFileName.substring(0, outputFileName.length() - ".sw_".length()) + extension);
        } else {
            bc.setOutputFileName(outputFileName + extension);
        }
    }

    public void moduleRemoved(final Module module) {
        if (ModuleType.get((Module)module) != FlexModuleType.getInstance()) {
            return;
        }
        List configsToRemove = ContainerUtil.findAll((Collection)this.myConfigurablesMap.keySet(), (Condition)new Condition<ModifiableFlexBuildConfiguration>(){

            public boolean value(ModifiableFlexBuildConfiguration bc) {
                return FlexBCConfigurator.this.myConfigEditor.getModule(bc) == module;
            }
        });
        ProjectStructureDaemonAnalyzer daemonAnalyzer = ProjectStructureConfigurable.getInstance((Project)this.myConfigEditor.getProject()).getContext().getDaemonAnalyzer();
        for (ModifiableFlexBuildConfiguration bc : configsToRemove) {
            CompositeConfigurable configurable = (CompositeConfigurable)((Object)this.myConfigurablesMap.remove((Object)bc));
            this.myBCToOutputPathMap.remove((Object)bc);
            daemonAnalyzer.removeElement(configurable.getProjectStructureElement());
            daemonAnalyzer.queueUpdateForAllElementsWithErrors();
            configurable.disposeUIResources();
        }
        ((Listener)this.myEventDispatcher.getMulticaster()).moduleRemoved(module);
    }

    public boolean isModified() {
        if (this.myConfigEditor.isModified()) {
            return true;
        }
        for (CompositeConfigurable configurable : this.myConfigurablesMap.values()) {
            if (!configurable.isModified()) continue;
            return true;
        }
        return false;
    }

    public void apply() throws ConfigurationException {
        ModuleStructureConfigurable c = ProjectStructureConfigurable.getInstance((Project)this.myConfigEditor.getProject()).getModulesConfig();
        for (CompositeConfigurable configurable : this.myConfigurablesMap.values()) {
            c.ensureInitialized((NamedConfigurable)configurable);
            if (!configurable.isModified()) continue;
            configurable.apply();
        }
        if (this.myConfigEditor.isModified()) {
            this.myConfigEditor.checkCanCommit();
            this.myConfigEditor.commit();
        }
    }

    public void afterModelCommit() {
        for (CompositeConfigurable configurable : this.myConfigurablesMap.values()) {
            configurable.reset();
        }
    }

    public void dispose() {
        this.myModifiableModelInitializer.dispose();
        this.myConfigurablesMap.clear();
        this.myBCToOutputPathMap.clear();
    }

    public void removeConfiguration(ModifiableFlexBuildConfiguration bc) {
        CompositeConfigurable configurable = (CompositeConfigurable)((Object)this.myConfigurablesMap.remove((Object)bc));
        this.myBCToOutputPathMap.remove((Object)bc);
        ProjectStructureDaemonAnalyzer daemonAnalyzer = ProjectStructureConfigurable.getInstance((Project)this.myConfigEditor.getProject()).getContext().getDaemonAnalyzer();
        daemonAnalyzer.removeElement(configurable.getProjectStructureElement());
        daemonAnalyzer.queueUpdateForAllElementsWithErrors();
        ((Listener)this.myEventDispatcher.getMulticaster()).buildConfigurationRemoved(FlexBCConfigurable.unwrap(configurable));
    }

    public void addConfiguration(Module module, Runnable treeNodeNameUpdater) {
        SdkEntry sdkEntry;
        if (module == null) {
            return;
        }
        String title = FlexBundle.message("add.build.configuration.title", module.getName());
        AddBuildConfigurationDialog dialog = new AddBuildConfigurationDialog(module.getProject(), title, this.getUsedNames(module), BuildConfigurationNature.DEFAULT, true);
        if (!dialog.showAndGet()) {
            return;
        }
        ModifiableFlexBuildConfiguration bc = this.myConfigEditor.createConfiguration(module);
        String bcName = dialog.getBCName();
        String fileName = PathUtil.suggestFileName((String)bcName);
        BuildConfigurationNature nature = dialog.getNature();
        bc.setName(bcName);
        bc.setNature(nature);
        ModifiableFlexBuildConfiguration someExistingConfig = this.myConfigEditor.getConfigurations(module)[0];
        bc.setOutputFileName(fileName + (bc.getOutputType() == OutputType.Library ? ".swc" : ".swf"));
        bc.setOutputFolder(someExistingConfig.getOutputFolder());
        FlexBCConfigurator.updatePackageFileName(bc, fileName);
        if (nature.isApp() && nature.isMobilePlatform()) {
            bc.getAndroidPackagingOptions().setEnabled(dialog.isAndroidEnabled());
            bc.getIosPackagingOptions().setEnabled(dialog.isIOSEnabled());
        }
        SdkEntry newSdkEntry = (sdkEntry = someExistingConfig.getDependencies().getSdkEntry()) != null && FlexSdkUtils.findFlexOrFlexmojosSdk(sdkEntry.getName()) != null ? Factory.createSdkEntry(sdkEntry.getName()) : FlexBCConfigurator.findAnySdk();
        bc.getDependencies().setSdkEntry(newSdkEntry);
        this.createConfigurableNode(bc, module, treeNodeNameUpdater);
    }

    @Nullable
    private static SdkEntry findAnySdk() {
        List<Sdk> sdks = FlexSdkUtils.getFlexSdks();
        return sdks.isEmpty() ? null : Factory.createSdkEntry(sdks.get(0).getName());
    }

    public void copy(CompositeConfigurable configurable, Runnable treeNodeNameUpdater) {
        try {
            configurable.apply();
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
        ModifiableFlexBuildConfiguration existingBC = (ModifiableFlexBuildConfiguration)this.myConfigurablesMap.getKeysByValue((Object)configurable).get(0);
        FlexBCConfigurable unwrapped = FlexBCConfigurable.unwrap(configurable);
        String title = FlexBundle.message("copy.build.configuration", existingBC.getName(), unwrapped.getModule().getName());
        Module module = unwrapped.getModule();
        AddBuildConfigurationDialog dialog = new AddBuildConfigurationDialog(module.getProject(), title, this.getUsedNames(module), existingBC.getNature(), true);
        dialog.reset("", existingBC.getAndroidPackagingOptions().isEnabled(), existingBC.getIosPackagingOptions().isEnabled());
        if (!dialog.showAndGet()) {
            return;
        }
        String newBCName = dialog.getBCName();
        String fileName = PathUtil.suggestFileName((String)newBCName);
        BuildConfigurationNature newNature = dialog.getNature();
        ModifiableFlexBuildConfiguration newBC = this.myConfigEditor.copyConfiguration(existingBC, newNature);
        newBC.setName(newBCName);
        newBC.setOutputFileName(fileName + (newBC.getOutputType() == OutputType.Library ? ".swc" : ".swf"));
        FlexBCConfigurator.updatePackageFileName(newBC, fileName);
        if (newNature.isApp() && newNature.isMobilePlatform()) {
            newBC.getAndroidPackagingOptions().setEnabled(dialog.isAndroidEnabled());
            newBC.getIosPackagingOptions().setEnabled(dialog.isIOSEnabled());
        }
        this.createConfigurableNode(newBC, unwrapped.getModule(), treeNodeNameUpdater);
    }

    private static void updatePackageFileName(ModifiableFlexBuildConfiguration bc, String packageFileName) {
        BuildConfigurationNature nature = bc.getNature();
        if (nature.isApp()) {
            if (nature.isDesktopPlatform()) {
                bc.getAirDesktopPackagingOptions().setPackageFileName(packageFileName);
            } else if (nature.isMobilePlatform()) {
                bc.getAndroidPackagingOptions().setPackageFileName(packageFileName);
                bc.getIosPackagingOptions().setPackageFileName(packageFileName);
            }
        }
    }

    private void createConfigurableNode(ModifiableFlexBuildConfiguration bc, Module module, Runnable treeNodeNameUpdater) {
        CompositeConfigurable wrapped = this.createBcConfigurable(module, bc, treeNodeNameUpdater);
        this.myConfigurablesMap.put((Object)bc, (Object)wrapped);
        BuildConfigurationNode node = new BuildConfigurationNode(wrapped);
        ModuleStructureConfigurable moduleStructureConfigurable = ModuleStructureConfigurable.getInstance((Project)module.getProject());
        moduleStructureConfigurable.addNode((MasterDetailsComponent.MyNode)node, moduleStructureConfigurable.findModuleNode(module));
        Place place = new Place().putPath("category", (Object)moduleStructureConfigurable).putPath("treeObject", (Object)bc);
        ProjectStructureConfigurable.getInstance((Project)module.getProject()).navigateTo(place, true);
    }

    private Collection<String> getUsedNames(Module module) {
        LinkedList<String> result = new LinkedList<String>();
        for (ModifiableFlexBuildConfiguration configuration : this.myConfigEditor.getConfigurations(module)) {
            result.add(((CompositeConfigurable)((Object)this.myConfigurablesMap.get((Object)configuration))).getDisplayName());
        }
        return result;
    }

    public List<CompositeConfigurable> getBCConfigurables(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/lang/javascript/flex/projectStructure/FlexBCConfigurator", "getBCConfigurables"));
        }
        return ContainerUtil.map((Object[])this.myConfigEditor.getConfigurations(module), (Function)new Function<ModifiableFlexBuildConfiguration, CompositeConfigurable>(){

            public CompositeConfigurable fun(ModifiableFlexBuildConfiguration configuration) {
                return (CompositeConfigurable)((Object)FlexBCConfigurator.this.myConfigurablesMap.get((Object)configuration));
            }
        });
    }

    public FlexBCConfigurable getBCConfigurable(@NotNull ModifiableFlexBuildConfiguration bc) {
        if (bc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bc", "com/intellij/lang/javascript/flex/projectStructure/FlexBCConfigurator", "getBCConfigurable"));
        }
        return FlexBCConfigurable.unwrap((CompositeConfigurable)((Object)this.myConfigurablesMap.get((Object)bc)));
    }

    @Nullable
    public List<ModifiableFlexBuildConfiguration> getBCsByOutputPath(String outputPath) {
        return this.myBCToOutputPathMap.getKeysByValue((Object)outputPath);
    }

    public Place getPlaceFor(Module module, String bcName) {
        Place p = new Place();
        p = p.putPath("category", (Object)ModuleStructureConfigurable.getInstance((Project)this.myConfigEditor.getProject()));
        p = p.putPath("treeObject", (Object)this.myConfigEditor.findCurrentConfiguration(module, bcName));
        return p;
    }

    public boolean canBeRemoved(ModifiableFlexBuildConfiguration[] configurations) {
        HashMap module2ConfigCount = new HashMap();
        for (ModifiableFlexBuildConfiguration bc : configurations) {
            Module module;
            Integer count = (Integer)module2ConfigCount.get(module = this.myConfigEditor.getModule(bc));
            module2ConfigCount.put(module, count != null ? count + 1 : 1);
        }
        for (Map.Entry entry : module2ConfigCount.entrySet()) {
            Module module = (Module)entry.getKey();
            if (this.myConfigEditor.getConfigurations(module).length != (Integer)entry.getValue()) continue;
            return false;
        }
        return true;
    }

    public static interface Listener
    extends EventListener {
        public void moduleRemoved(Module var1);

        public void buildConfigurationRemoved(FlexBCConfigurable var1);

        public void natureChanged(FlexBCConfigurable var1);

        public void buildConfigurationRenamed(FlexBCConfigurable var1);
    }
}

