/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.projectStructure;

import com.intellij.lang.javascript.flex.projectStructure.FlexBuildConfigurationsExtension;
import com.intellij.lang.javascript.flex.projectStructure.model.impl.FlexProjectConfigurationEditor;
import com.intellij.lang.javascript.psi.impl.CompositeRootCollection;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.AdditionalDataConfigurable;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.RootProvider;
import com.intellij.openapi.roots.impl.SdkFinder;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlexCompositeSdk
extends UserDataHolderBase
implements Sdk,
CompositeRootCollection {
    private static final String NAME_DELIM = "\t";
    private final String[] myNames;
    @Nullable
    private volatile Sdk[] mySdks;
    private static final OrderRootType[] RELEVANT_ROOT_TYPES = new OrderRootType[]{OrderRootType.CLASSES, OrderRootType.SOURCES};
    public static final String TYPE_ID = "__CompositeFlexSdk__";
    private static final SdkType TYPE = new SdkType("__CompositeFlexSdk__"){

        public String suggestHomePath() {
            return null;
        }

        public boolean isValidSdkHome(String path) {
            return false;
        }

        public String suggestSdkName(String currentSdkName, String sdkHome) {
            return currentSdkName;
        }

        @Nullable
        public AdditionalDataConfigurable createAdditionalDataConfigurable(SdkModel sdkModel, SdkModificator sdkModificator) {
            return null;
        }

        public void saveAdditionalData(@NotNull SdkAdditionalData additionalData, @NotNull Element additional) {
            if (additionalData == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "additionalData", "com/intellij/lang/javascript/flex/projectStructure/FlexCompositeSdk$4", "saveAdditionalData"));
            }
            if (additional == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "additional", "com/intellij/lang/javascript/flex/projectStructure/FlexCompositeSdk$4", "saveAdditionalData"));
            }
        }

        public String getPresentableName() {
            return this.getName();
        }
    };

    public FlexCompositeSdk(String[] names) {
        this.myNames = names;
        this.init();
    }

    private void init() {
        Application application = ApplicationManager.getApplication();
        final Disposable d = Disposer.newDisposable();
        Disposer.register((Disposable)application, (Disposable)d);
        application.getMessageBus().connect(d).subscribe(ProjectJdkTable.JDK_TABLE_TOPIC, (Object)new ProjectJdkTable.Listener(){

            public void jdkAdded(Sdk jdk) {
                FlexCompositeSdk.this.resetSdks();
            }

            public void jdkRemoved(Sdk jdk) {
                if (jdk == FlexCompositeSdk.this) {
                    Disposer.dispose((Disposable)d);
                }
                FlexCompositeSdk.this.resetSdks();
            }

            public void jdkNameChanged(Sdk jdk, String previousName) {
                FlexCompositeSdk.this.resetSdks();
            }
        });
    }

    @NotNull
    public SdkType getSdkType() {
        SdkType sdkType = TYPE;
        if (sdkType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/projectStructure/FlexCompositeSdk", "getSdkType"));
        }
        return sdkType;
    }

    @NotNull
    public String getName() {
        String string = FlexCompositeSdk.getCompositeName(this.myNames);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/projectStructure/FlexCompositeSdk", "getName"));
        }
        return string;
    }

    public static String getCompositeName(String[] names) {
        return StringUtil.join((String[])names, (String)NAME_DELIM);
    }

    public String getVersionString() {
        return null;
    }

    public String getHomePath() {
        return null;
    }

    public VirtualFile getHomeDirectory() {
        return null;
    }

    @NotNull
    public RootProvider getRootProvider() {
        RootProvider rootProvider = new RootProvider(){

            @NotNull
            public String[] getUrls(final @NotNull OrderRootType rootType) {
                if (rootType == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootType", "com/intellij/lang/javascript/flex/projectStructure/FlexCompositeSdk$2", "getUrls"));
                }
                final HashSet result = new HashSet();
                FlexCompositeSdk.this.forAllSdks((Processor<Sdk>)((Processor)new Processor<Sdk>(){

                    public boolean process(Sdk sdk) {
                        result.addAll(Arrays.asList(sdk.getRootProvider().getUrls(rootType)));
                        return true;
                    }
                }));
                String[] stringArray = ArrayUtil.toStringArray(result);
                if (stringArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/projectStructure/FlexCompositeSdk$2", "getUrls"));
                }
                return stringArray;
            }

            @NotNull
            public VirtualFile[] getFiles(final @NotNull OrderRootType rootType) {
                if (rootType == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootType", "com/intellij/lang/javascript/flex/projectStructure/FlexCompositeSdk$2", "getFiles"));
                }
                final HashSet result = new HashSet();
                FlexCompositeSdk.this.forAllSdks((Processor<Sdk>)((Processor)new Processor<Sdk>(){

                    public boolean process(Sdk sdk) {
                        result.addAll(Arrays.asList(sdk.getRootProvider().getFiles(rootType)));
                        return true;
                    }
                }));
                VirtualFile[] virtualFileArray = result.toArray(new VirtualFile[result.size()]);
                if (virtualFileArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/projectStructure/FlexCompositeSdk$2", "getFiles"));
                }
                return virtualFileArray;
            }

            public void addRootSetChangedListener(final @NotNull RootProvider.RootSetChangedListener listener) {
                if (listener == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/lang/javascript/flex/projectStructure/FlexCompositeSdk$2", "addRootSetChangedListener"));
                }
                FlexCompositeSdk.this.forAllSdks((Processor<Sdk>)((Processor)new Processor<Sdk>(){

                    public boolean process(Sdk sdk) {
                        RootProvider rootProvider = sdk.getRootProvider();
                        rootProvider.removeRootSetChangedListener(listener);
                        rootProvider.addRootSetChangedListener(listener);
                        return true;
                    }
                }));
            }

            public void addRootSetChangedListener(final @NotNull RootProvider.RootSetChangedListener listener, final @NotNull Disposable parentDisposable) {
                if (listener == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/lang/javascript/flex/projectStructure/FlexCompositeSdk$2", "addRootSetChangedListener"));
                }
                if (parentDisposable == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/lang/javascript/flex/projectStructure/FlexCompositeSdk$2", "addRootSetChangedListener"));
                }
                FlexCompositeSdk.this.forAllSdks((Processor<Sdk>)((Processor)new Processor<Sdk>(){

                    public boolean process(Sdk sdk) {
                        sdk.getRootProvider().addRootSetChangedListener(listener, parentDisposable);
                        return true;
                    }
                }));
            }

            public void removeRootSetChangedListener(final @NotNull RootProvider.RootSetChangedListener listener) {
                if (listener == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/lang/javascript/flex/projectStructure/FlexCompositeSdk$2", "removeRootSetChangedListener"));
                }
                FlexCompositeSdk.this.forAllSdks((Processor<Sdk>)((Processor)new Processor<Sdk>(){

                    public boolean process(Sdk sdk) {
                        sdk.getRootProvider().removeRootSetChangedListener(listener);
                        return true;
                    }
                }));
            }
        };
        if (rootProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/projectStructure/FlexCompositeSdk", "getRootProvider"));
        }
        return rootProvider;
    }

    private void forAllSdks(Processor<Sdk> processor) {
        Sdk[] sdks;
        for (Sdk sdk : sdks = this.getSdks()) {
            if (processor.process((Object)sdk)) continue;
            return;
        }
    }

    @NotNull
    public Sdk[] getSdks() {
        boolean cache;
        Object[] allSdks;
        if (this.mySdks != null) {
            if (this.mySdks == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/projectStructure/FlexCompositeSdk", "getSdks"));
            }
            return this.mySdks;
        }
        FlexProjectConfigurationEditor currentEditor = FlexBuildConfigurationsExtension.getInstance().getConfigurator().getConfigEditor();
        if (currentEditor == null) {
            allSdks = ProjectJdkTable.getInstance().getAllJdks();
            cache = true;
        } else {
            Collection sdks = ProjectStructureConfigurable.getInstance((Project)currentEditor.getProject()).getProjectJdksModel().getProjectSdks().values();
            allSdks = sdks.toArray(new Sdk[sdks.size()]);
            cache = false;
        }
        List result = ContainerUtil.findAll((Object[])allSdks, (Condition)new Condition<Sdk>(){

            public boolean value(Sdk sdk) {
                return ArrayUtil.contains((String)sdk.getName(), (String[])FlexCompositeSdk.this.myNames);
            }
        });
        Sdk[] resultArray = result.toArray(new Sdk[result.size()]);
        if (cache) {
            this.mySdks = resultArray;
        }
        if (resultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/projectStructure/FlexCompositeSdk", "getSdks"));
        }
        return resultArray;
    }

    private void resetSdks() {
        this.mySdks = null;
    }

    @NotNull
    public SdkModificator getSdkModificator() {
        throw new UnsupportedOperationException();
    }

    public SdkAdditionalData getSdkAdditionalData() {
        return null;
    }

    @NotNull
    public Object clone() {
        throw new UnsupportedOperationException();
    }

    public VirtualFile[] getFiles(OrderRootType rootType, VirtualFile hint) {
        Sdk[] sdks;
        for (Sdk sdk : sdks = this.getSdks()) {
            for (OrderRootType t : RELEVANT_ROOT_TYPES) {
                VirtualFile[] files = sdk.getRootProvider().getFiles(t);
                if (!FlexCompositeSdk.isAncestorOf(files, hint)) continue;
                return t == rootType ? files : sdk.getRootProvider().getFiles(rootType);
            }
        }
        return VirtualFile.EMPTY_ARRAY;
    }

    private static boolean isAncestorOf(VirtualFile[] ancestors, VirtualFile file) {
        VirtualFile fileInLocalFs = JarFileSystem.getInstance().getVirtualFileForJar(file);
        for (VirtualFile ancestor : ancestors) {
            if (VfsUtilCore.isAncestor((VirtualFile)ancestor, (VirtualFile)file, (boolean)false)) {
                return true;
            }
            if (fileInLocalFs == null || !VfsUtilCore.isAncestor((VirtualFile)ancestor, (VirtualFile)fileInLocalFs, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    public String getName(VirtualFile hint) {
        Sdk[] sdks = this.getSdks();
        if (sdks.length >= 2) {
            for (Sdk sdk : sdks) {
                for (OrderRootType t : RELEVANT_ROOT_TYPES) {
                    if (!FlexCompositeSdk.isAncestorOf(sdk.getRootProvider().getFiles(t), hint)) continue;
                    return sdk.getName();
                }
            }
        }
        return this.getName();
    }

    public static class SdkFinderImpl
    extends SdkFinder {
        public Sdk findSdk(String name, String sdkType) {
            if (TYPE.getName().equals(sdkType)) {
                List sdksNames = StringUtil.split((String)name, (String)FlexCompositeSdk.NAME_DELIM);
                return new FlexCompositeSdk(ArrayUtil.toStringArray((Collection)sdksNames));
            }
            return null;
        }
    }
}

