/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.projectStructure.detection;

import com.intellij.ide.util.DelegatingProgressIndicator;
import com.intellij.ide.util.importProject.LibrariesDetectionStep;
import com.intellij.ide.util.importProject.ModuleInsight;
import com.intellij.ide.util.importProject.ModulesDetectionStep;
import com.intellij.ide.util.importProject.ProjectDescriptor;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.importSources.DetectedProjectRoot;
import com.intellij.ide.util.projectWizard.importSources.ProjectFromSourcesBuilder;
import com.intellij.ide.util.projectWizard.importSources.ProjectStructureDetector;
import com.intellij.ide.util.projectWizard.importSources.util.CommonSourceRootDetectionUtil;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.javascript.ActionScriptFileType;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.flex.projectStructure.detection.FlexModuleInsight;
import com.intellij.lang.javascript.flex.projectStructure.detection.FlexModuleSourceRoot;
import com.intellij.lang.javascript.flex.projectStructure.detection.FlexSdkStep;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.NullableFunction;
import com.intellij.util.StringBuilderSpinAllocator;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlexProjectStructureDetector
extends ProjectStructureDetector {
    public static final NullableFunction<CharSequence, String> PACKAGE_NAME_FETCHER = new NullableFunction<CharSequence, String>(){

        public String fun(CharSequence charSequence) {
            Lexer lexer = ((ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage((Language)JavaScriptSupportLoader.ECMA_SCRIPT_L4)).createLexer(null);
            lexer.start(charSequence);
            return FlexProjectStructureDetector.readPackageName(charSequence, lexer);
        }
    };
    private static final TokenSet WHITESPACE_AND_COMMENTS = TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.WHITE_SPACE, JSTokenTypes.DOC_COMMENT, JSTokenTypes.C_STYLE_COMMENT, JSTokenTypes.END_OF_LINE_COMMENT});

    public static boolean isActionScriptFile(File file) {
        return FileTypeRegistry.getInstance().getFileTypeByFileName(file.getName()) == ActionScriptFileType.INSTANCE;
    }

    @NotNull
    public ProjectStructureDetector.DirectoryProcessingResult detectRoots(@NotNull File dir, @NotNull File[] children, @NotNull File base, @NotNull List<DetectedProjectRoot> result) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/lang/javascript/flex/projectStructure/detection/FlexProjectStructureDetector", "detectRoots"));
        }
        if (children == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "children", "com/intellij/lang/javascript/flex/projectStructure/detection/FlexProjectStructureDetector", "detectRoots"));
        }
        if (base == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "base", "com/intellij/lang/javascript/flex/projectStructure/detection/FlexProjectStructureDetector", "detectRoots"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/javascript/flex/projectStructure/detection/FlexProjectStructureDetector", "detectRoots"));
        }
        for (File child : children) {
            if (child.isFile()) {
                if (FlexProjectStructureDetector.isActionScriptFile(child)) {
                    Pair root = CommonSourceRootDetectionUtil.IO_FILE.suggestRootForFileWithPackageStatement((Object)child, (Object)base, PACKAGE_NAME_FETCHER, false);
                    if (root != null) {
                        result.add((DetectedProjectRoot)new FlexModuleSourceRoot((File)root.getFirst()));
                        ProjectStructureDetector.DirectoryProcessingResult directoryProcessingResult = ProjectStructureDetector.DirectoryProcessingResult.skipChildrenAndParentsUpTo((File)((File)root.getFirst()));
                        if (directoryProcessingResult == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/projectStructure/detection/FlexProjectStructureDetector", "detectRoots"));
                        }
                        return directoryProcessingResult;
                    }
                    ProjectStructureDetector.DirectoryProcessingResult directoryProcessingResult = ProjectStructureDetector.DirectoryProcessingResult.SKIP_CHILDREN;
                    if (directoryProcessingResult == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/projectStructure/detection/FlexProjectStructureDetector", "detectRoots"));
                    }
                    return directoryProcessingResult;
                }
                if (JavaScriptSupportLoader.isFlexMxmFile((String)child.getName())) {
                    result.add((DetectedProjectRoot)new FlexModuleSourceRoot(dir));
                }
            }
            if (!"node_modules".equals(child.getName())) continue;
            ProjectStructureDetector.DirectoryProcessingResult directoryProcessingResult = ProjectStructureDetector.DirectoryProcessingResult.SKIP_CHILDREN;
            if (directoryProcessingResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/projectStructure/detection/FlexProjectStructureDetector", "detectRoots"));
            }
            return directoryProcessingResult;
        }
        ProjectStructureDetector.DirectoryProcessingResult directoryProcessingResult = ProjectStructureDetector.DirectoryProcessingResult.PROCESS_CHILDREN;
        if (directoryProcessingResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/projectStructure/detection/FlexProjectStructureDetector", "detectRoots"));
        }
        return directoryProcessingResult;
    }

    public List<ModuleWizardStep> createWizardSteps(ProjectFromSourcesBuilder builder, ProjectDescriptor projectDescriptor, Icon stepIcon) {
        FlexModuleInsight moduleInsight = new FlexModuleInsight((ProgressIndicator)new DelegatingProgressIndicator(), builder.getExistingModuleNames(), builder.getExistingProjectLibraryNames());
        ArrayList<ModuleWizardStep> steps = new ArrayList<ModuleWizardStep>();
        steps.add((ModuleWizardStep)new LibrariesDetectionStep(builder, projectDescriptor, (ModuleInsight)moduleInsight, stepIcon, "reference.dialogs.new.project.fromCode.page1"));
        steps.add((ModuleWizardStep)new ModulesDetectionStep((ProjectStructureDetector)this, builder, projectDescriptor, (ModuleInsight)moduleInsight, stepIcon, "reference.dialogs.new.project.fromCode.page2"));
        steps.add(new FlexSdkStep(builder.getContext()));
        return steps;
    }

    @Nullable
    public static String readPackageName(CharSequence charSequence, Lexer lexer) {
        FlexProjectStructureDetector.skipWhiteSpaceAndComments(lexer);
        if (!JSTokenTypes.PACKAGE_KEYWORD.equals(lexer.getTokenType())) {
            return null;
        }
        lexer.advance();
        FlexProjectStructureDetector.skipWhiteSpaceAndComments(lexer);
        return FlexProjectStructureDetector.readQualifiedName(charSequence, lexer, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    static String readQualifiedName(CharSequence charSequence, Lexer lexer, boolean allowStar) {
        StringBuilder buffer = StringBuilderSpinAllocator.alloc();
        try {
            String packageName;
            while (lexer.getTokenType() == JSTokenTypes.IDENTIFIER || allowStar && lexer.getTokenType() != JSTokenTypes.MULT) {
                buffer.append(charSequence, lexer.getTokenStart(), lexer.getTokenEnd());
                if (lexer.getTokenType() == JSTokenTypes.MULT) break;
                lexer.advance();
                if (lexer.getTokenType() != JSTokenTypes.DOT) break;
                buffer.append('.');
                lexer.advance();
            }
            if (StringUtil.endsWithChar((CharSequence)(packageName = buffer.toString()), (char)'.')) {
                String string = null;
                return string;
            }
            String string = packageName;
            return string;
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)buffer);
        }
    }

    public static void skipWhiteSpaceAndComments(Lexer lexer) {
        while (WHITESPACE_AND_COMMENTS.contains(lexer.getTokenType())) {
            lexer.advance();
        }
    }
}

