/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.run;

import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.runners.RunContentBuilder;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.ide.actions.ShowFilePathAction;
import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.lang.javascript.flex.actions.airpackage.AirPackageUtil;
import com.intellij.lang.javascript.flex.flexunit.FlexUnitConnection;
import com.intellij.lang.javascript.flex.flexunit.FlexUnitRunConfiguration;
import com.intellij.lang.javascript.flex.flexunit.FlexUnitRunnerParameters;
import com.intellij.lang.javascript.flex.flexunit.ServerConnectionBase;
import com.intellij.lang.javascript.flex.flexunit.SwfPolicyFileConnection;
import com.intellij.lang.javascript.flex.projectStructure.model.FlexBuildConfiguration;
import com.intellij.lang.javascript.flex.projectStructure.options.BCUtils;
import com.intellij.lang.javascript.flex.run.FlashRunConfiguration;
import com.intellij.lang.javascript.flex.run.FlashRunnerParameters;
import com.intellij.lang.javascript.flex.run.FlexBaseRunner;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.util.PathUtil;
import com.intellij.xdebugger.DefaultDebugProcessHandler;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlexRunner
extends FlexBaseRunner {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected RunContentDescriptor launchFlexConfig(Module module, FlexBuildConfiguration bc, FlashRunnerParameters runnerParameters, RunProfileState state, RunContentDescriptor contentToReuse, ExecutionEnvironment environment) throws ExecutionException {
        switch (bc.getTargetPlatform()) {
            case Web: {
                String urlOrPath = runnerParameters.isLaunchUrl() ? runnerParameters.getUrl() : (bc.isUseHtmlWrapper() ? PathUtil.getParentPath((String)bc.getActualOutputFilePath()) + "/" + BCUtils.getWrapperFileName(bc) : bc.getActualOutputFilePath());
                FlexRunner.launchWithSelectedApplication(urlOrPath, runnerParameters.getLauncherParameters());
                return null;
            }
            case Desktop: {
                return this.standardLaunch(module.getProject(), state, contentToReuse, environment);
            }
            case Mobile: {
                switch (runnerParameters.getMobileRunTarget()) {
                    case Emulator: {
                        return this.standardLaunch(module.getProject(), state, contentToReuse, environment);
                    }
                    case AndroidDevice: {
                        String androidDescriptorPath = FlexRunner.getAirDescriptorPath(bc, bc.getAndroidPackagingOptions());
                        String androidAppId = FlexRunner.getApplicationId(androidDescriptorPath);
                        if (androidAppId == null) {
                            Messages.showErrorDialog((Project)module.getProject(), (String)FlexBundle.message("failed.to.read.app.id", FileUtil.toSystemDependentName((String)androidDescriptorPath)), (String)FlexBundle.message("error.title", new Object[0]));
                            return null;
                        }
                        if (!FlexRunner.packAndInstallToAndroidDevice(module, bc, runnerParameters, androidAppId, false)) return null;
                        FlexRunner.launchOnAndroidDevice(module.getProject(), bc.getSdk(), runnerParameters.getDeviceInfo(), androidAppId, false);
                        return null;
                    }
                    case iOSSimulator: {
                        String adtVersionSimulator = AirPackageUtil.getAdtVersion(module.getProject(), bc.getSdk());
                        String iosSimulatorDescriptorPath = FlexRunner.getAirDescriptorPath(bc, bc.getIosPackagingOptions());
                        String iosSimulatorAppId = FlexRunner.getApplicationId(iosSimulatorDescriptorPath);
                        if (iosSimulatorAppId == null) {
                            Messages.showErrorDialog((Project)module.getProject(), (String)FlexBundle.message("failed.to.read.app.id", FileUtil.toSystemDependentName((String)iosSimulatorDescriptorPath)), (String)FlexBundle.message("error.title", new Object[0]));
                            return null;
                        }
                        if (!FlexRunner.packAndInstallToIOSSimulator(module, bc, runnerParameters, adtVersionSimulator, iosSimulatorAppId, false)) return null;
                        FlexRunner.launchOnIosSimulator(module.getProject(), bc.getSdk(), iosSimulatorAppId, runnerParameters.getIOSSimulatorSdkPath(), false);
                        return null;
                    }
                    case iOSDevice: {
                        String adtVersion = AirPackageUtil.getAdtVersion(module.getProject(), bc.getSdk());
                        if (StringUtil.compareVersionNumbers((String)adtVersion, (String)"3.4") >= 0) {
                            if (!FlexRunner.packAndInstallToIOSDevice(module, bc, runnerParameters, adtVersion, false)) return null;
                            String appName = FlexRunner.getApplicationName(FlexRunner.getAirDescriptorPath(bc, bc.getIosPackagingOptions()));
                            ToolWindowManager.getInstance((Project)module.getProject()).notifyByBalloon(ToolWindowId.RUN, MessageType.INFO, FlexBundle.message("ios.application.installed.to.run", appName));
                        } else {
                            if (!AirPackageUtil.packageIpaForDevice(module, bc, runnerParameters, adtVersion, false)) return null;
                            final String outputFolder = PathUtil.getParentPath((String)bc.getActualOutputFilePath());
                            final String ipaName = bc.getIosPackagingOptions().getPackageFileName() + ".ipa";
                            String message = FlexBundle.message("ios.application.packaged.to.run", ipaName);
                            ToolWindowManager.getInstance((Project)module.getProject()).notifyByBalloon(ToolWindowId.RUN, MessageType.INFO, message, null, (HyperlinkListener)new HyperlinkAdapter(){

                                protected void hyperlinkActivated(HyperlinkEvent e) {
                                    ShowFilePathAction.openFile((File)new File(outputFolder + "/" + ipaName));
                                }
                            });
                        }
                    }
                }
            }
        }
        return null;
    }

    @Nullable
    private RunContentDescriptor standardLaunch(Project project, RunProfileState state, RunContentDescriptor contentToReuse, ExecutionEnvironment environment) throws ExecutionException {
        ExecutionResult executionResult = state.execute(environment.getExecutor(), (ProgramRunner)this);
        if (executionResult == null) {
            return null;
        }
        RunContentBuilder contentBuilder = new RunContentBuilder(executionResult, environment);
        return contentBuilder.showRunContent(contentToReuse);
    }

    @Override
    protected RunContentDescriptor launchWebFlexUnit(Project project, RunContentDescriptor contentToReuse, ExecutionEnvironment env, FlexUnitRunnerParameters params, String swfFilePath) throws ExecutionException {
        final SwfPolicyFileConnection policyFileConnection = new SwfPolicyFileConnection();
        policyFileConnection.open(params.getSocketPolicyPort());
        final FlexUnitConnection flexUnitConnection = new FlexUnitConnection();
        flexUnitConnection.open(params.getPort());
        DefaultDebugProcessHandler processHandler = new DefaultDebugProcessHandler(){

            protected void destroyProcessImpl() {
                flexUnitConnection.write("Finish");
                flexUnitConnection.close();
                policyFileConnection.close();
                super.destroyProcessImpl();
            }

            public boolean detachIsDefault() {
                return false;
            }
        };
        ExecutionConsole console = FlexRunner.createFlexUnitRunnerConsole(project, env, (ProcessHandler)processHandler);
        flexUnitConnection.addListener(new FlexUnitListener((ProcessHandler)processHandler));
        FlexRunner.launchWithSelectedApplication(swfFilePath, params.getLauncherParameters());
        RunContentBuilder contentBuilder = new RunContentBuilder((ExecutionResult)new DefaultExecutionResult(console, (ProcessHandler)processHandler), env);
        Disposer.register((Disposable)project, (Disposable)contentBuilder);
        return contentBuilder.showRunContent(contentToReuse);
    }

    @Override
    @Nullable
    protected RunContentDescriptor launchAirFlexUnit(Project project, RunProfileState state, RunContentDescriptor contentToReuse, ExecutionEnvironment env, FlexUnitRunnerParameters params) throws ExecutionException {
        final SwfPolicyFileConnection policyFileConnection = new SwfPolicyFileConnection();
        policyFileConnection.open(params.getSocketPolicyPort());
        final FlexUnitConnection flexUnitConnection = new FlexUnitConnection();
        flexUnitConnection.open(params.getPort());
        ExecutionResult executionResult = state.execute(env.getExecutor(), (ProgramRunner)this);
        if (executionResult == null) {
            flexUnitConnection.close();
            policyFileConnection.close();
            return null;
        }
        flexUnitConnection.addListener(new FlexUnitListener(executionResult.getProcessHandler()));
        executionResult.getProcessHandler().addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processWillTerminate(ProcessEvent event, boolean willBeDestroyed) {
                flexUnitConnection.write("Finish");
            }

            public void processTerminated(ProcessEvent event) {
                flexUnitConnection.close();
                policyFileConnection.close();
            }
        });
        RunContentBuilder contentBuilder = new RunContentBuilder(executionResult, env);
        return contentBuilder.showRunContent(contentToReuse);
    }

    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        if (executorId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executorId", "com/intellij/lang/javascript/flex/run/FlexRunner", "canRun"));
        }
        if (profile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profile", "com/intellij/lang/javascript/flex/run/FlexRunner", "canRun"));
        }
        return DefaultRunExecutor.EXECUTOR_ID.equals(executorId) && (profile instanceof FlashRunConfiguration || profile instanceof FlexUnitRunConfiguration);
    }

    @NotNull
    public String getRunnerId() {
        if ("FlexRunner" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/run/FlexRunner", "getRunnerId"));
        }
        return "FlexRunner";
    }

    private static class FlexUnitListener
    implements FlexUnitConnection.Listener {
        private final ProcessHandler myProcessHandler;

        public FlexUnitListener(ProcessHandler processHandler) {
            this.myProcessHandler = processHandler;
        }

        @Override
        public void statusChanged(ServerConnectionBase.ConnectionStatus status) {
            if (status == ServerConnectionBase.ConnectionStatus.CONNECTION_FAILED || status == ServerConnectionBase.ConnectionStatus.DISCONNECTED) {
                this.myProcessHandler.destroyProcess();
            }
        }

        @Override
        public void onData(final String line) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    FlexUnitListener.this.myProcessHandler.notifyTextAvailable(line + "\n", ProcessOutputTypes.STDOUT);
                }
            };
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                try {
                    SwingUtilities.invokeAndWait(runnable);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            } else {
                runnable.run();
            }
        }

        @Override
        public void onFinish() {
        }
    }
}

