/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.sdk;

import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.lang.javascript.flex.sdk.FlexmojosSdkAdditionalData;
import com.intellij.lang.javascript.flex.sdk.FlexmojosSdkDataConfigurable;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.projectRoots.AdditionalDataConfigurable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import icons.FlexIcons;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class FlexmojosSdkType
extends SdkType {
    static final String COMPILER_POM_PATTERN_1 = ".+/com/adobe/flex/compiler/.+/compiler-.+\\.pom";
    static final String COMPILER_POM_PATTERN_2 = ".+/org/apache/flex/compiler/.+/compiler-.+\\.pom";

    public FlexmojosSdkType() {
        super("Flexmojos SDK Type");
    }

    public static FlexmojosSdkType getInstance() {
        return (FlexmojosSdkType)SdkType.findInstance(FlexmojosSdkType.class);
    }

    public String suggestHomePath() {
        return null;
    }

    public boolean isValidSdkHome(String _path) {
        String path = FileUtil.toSystemIndependentName((String)_path);
        return path.matches(COMPILER_POM_PATTERN_1) || path.matches(COMPILER_POM_PATTERN_2);
    }

    public FileChooserDescriptor getHomeChooserDescriptor() {
        FileChooserDescriptor descriptor = new FileChooserDescriptor(false, false, false, false, false, false){

            public boolean isFileVisible(VirtualFile file, boolean showHiddenFiles) {
                return false;
            }
        };
        descriptor.setTitle("SDK of this type can only be created automatically during Maven project import.");
        return descriptor;
    }

    public String suggestSdkName(String currentSdkName, String sdkHome) {
        return "Flexmojos SDK " + this.getVersionString(sdkHome);
    }

    public AdditionalDataConfigurable createAdditionalDataConfigurable(SdkModel sdkModel, SdkModificator sdkModificator) {
        return new FlexmojosSdkDataConfigurable();
    }

    public SdkAdditionalData loadAdditionalData(Element element) {
        FlexmojosSdkAdditionalData additionalData = new FlexmojosSdkAdditionalData();
        additionalData.load(element);
        return additionalData;
    }

    public void saveAdditionalData(@NotNull SdkAdditionalData additionalData, @NotNull Element element) {
        if (additionalData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "additionalData", "com/intellij/lang/javascript/flex/sdk/FlexmojosSdkType", "saveAdditionalData"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/flex/sdk/FlexmojosSdkType", "saveAdditionalData"));
        }
        ((FlexmojosSdkAdditionalData)additionalData).save(element);
    }

    public String getPresentableName() {
        return "Flexmojos SDK";
    }

    public String getHomeFieldLabel() {
        return "Flex Compiler POM:";
    }

    public boolean isRootTypeApplicable(OrderRootType type) {
        return false;
    }

    public Icon getIcon() {
        return FlexIcons.Flex.Sdk.MavenFlex;
    }

    @NotNull
    public String getHelpTopic() {
        if ("reference.project.structure.sdk.flexmojos" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/sdk/FlexmojosSdkType", "getHelpTopic"));
        }
        return "reference.project.structure.sdk.flexmojos";
    }

    public Icon getIconForAddAction() {
        return this.getIcon();
    }

    public void setupSdkPaths(@NotNull Sdk sdk) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/intellij/lang/javascript/flex/sdk/FlexmojosSdkType", "setupSdkPaths"));
        }
        VirtualFile sdkRoot = sdk.getHomeDirectory();
        if (sdkRoot == null || !sdkRoot.isValid() || sdkRoot.isDirectory()) {
            return;
        }
        SdkModificator modificator = sdk.getSdkModificator();
        modificator.setVersionString(this.getVersionString(sdkRoot.getPath()));
        FlexmojosSdkAdditionalData data = (FlexmojosSdkAdditionalData)sdk.getSdkAdditionalData();
        if (data == null) {
            data = new FlexmojosSdkAdditionalData();
            modificator.setSdkAdditionalData((SdkAdditionalData)data);
        }
        data.setup(sdkRoot);
        modificator.commitChanges();
    }

    public String getVersionString(String sdkHome) {
        int index1 = sdkHome.lastIndexOf("compiler-");
        return index1 > 0 && sdkHome.endsWith(".pom") ? sdkHome.substring(index1 + "compiler-".length(), sdkHome.length() - ".pom".length()) : FlexBundle.message("flex.sdk.version.unknown", new Object[0]);
    }
}

