/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.formatter;

import com.intellij.lang.Language;
import com.intellij.lang.javascript.ActionScriptFileType;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.formatter.ECMA4CodeStyleSettings;
import com.intellij.lang.javascript.formatter.JSCodeStylePanel;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileTypes.EditorHighlighterProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeEditorHighlighterProviders;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class ActionScriptCodeStylePanel
extends JSCodeStylePanel {
    public ActionScriptCodeStylePanel(CodeStyleSettings settings) {
        super((Language)JavaScriptSupportLoader.ECMA_SCRIPT_L4, settings);
        this.myNamingConventionsPane.setVisible(true);
        this.myFormattingOptionsPane.setVisible(true);
        this.myIndentPackageChildren.setVisible(true);
    }

    @NotNull
    protected FileType getFileType() {
        LanguageFileType languageFileType = ActionScriptFileType.INSTANCE;
        if (languageFileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/formatter/ActionScriptCodeStylePanel", "getFileType"));
        }
        return languageFileType;
    }

    protected EditorHighlighter createHighlighter(EditorColorsScheme scheme) {
        return ((EditorHighlighterProvider)FileTypeEditorHighlighterProviders.INSTANCE.forFileType(this.getFileType())).getEditorHighlighter(ProjectUtil.guessCurrentProject((JComponent)this.getPanel()), this.getFileType(), null, scheme);
    }

    protected String getPreviewText() {
        JSCodeStyleSettings jsCodeStyleSettings = this.getCustomJSSettings(this.getSettings());
        String baseName = "field";
        String propertyName = (this.myPropertyPrefixTextField != null ? this.myPropertyPrefixTextField.getText() : jsCodeStyleSettings.PROPERTY_PREFIX) + baseName;
        String varName = (this.myFieldPrefixTextField != null ? this.myFieldPrefixTextField.getText() : jsCodeStyleSettings.FIELD_PREFIX) + baseName;
        String semiColon = (this.myUseSemicolon != null ? this.myUseSemicolon.isSelected() : jsCodeStyleSettings.USE_SEMICOLON_AFTER_STATEMENT) ? ";" : "";
        return "/*\n    Multiline\n        C-style\n            Comment\n*/\npackage aaa {\nclass XXX {\nprivate var " + varName + ":int" + semiColon + "\n" + "function get " + propertyName + "():int {\nreturn " + varName + semiColon + "}\n" + "function set " + propertyName + "(val:int):void {\n" + " var myLink = {\n" + "    img : \"btn.gif\",\n" + "    text : \"Button\",\n" + "    width : 128\n" + "}" + "varName = val" + semiColon + "\n" + "}\n" + "}";
    }

    protected JSCodeStyleSettings getCustomJSSettings(CodeStyleSettings settings) {
        return (JSCodeStyleSettings)settings.getCustomSettings(ECMA4CodeStyleSettings.class);
    }

    protected String getFileTypeExtension(FileType fileType) {
        return "as";
    }
}

