/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.generation;

import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.generation.BaseJSGenerateHandler;
import com.intellij.lang.javascript.generation.JSNamedElementNode;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.validation.fixes.BaseCreateMethodsFix;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class JavaScriptGenerateToStringHandler
extends BaseJSGenerateHandler {
    JavaScriptGenerateToStringHandler() {
    }

    protected String getTitleKey() {
        return "generate.to.string.chooser.title";
    }

    protected BaseCreateMethodsFix createFix(final JSClass jsClass) {
        return new BaseCreateMethodsFix<JSVariable>(jsClass){

            public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/generation/JavaScriptGenerateToStringHandler$1", "invoke"));
                }
                this.evalAnchor(editor, file);
                final boolean[] needOverride = new boolean[1];
                JSResolveUtil.processOverrides((JSClass)jsClass, (JSResolveUtil.OverrideHandler)new JSResolveUtil.OverrideHandler(){

                    public boolean process(SinkResolveProcessor processor, PsiElement scope, String className) {
                        needOverride[0] = !"Object".equals(className);
                        return false;
                    }
                }, (String)"toString", null, (PsiElement)this.myJsClass);
                String functionText = "public " + (needOverride[0] ? "override " : "") + "function toString():String {\nreturn " + (needOverride[0] ? "super.toString()" : "\"" + jsClass.getName());
                String semicolon = JSCodeStyleSettings.getSemicolon((PsiFile)file);
                boolean first = true;
                Set jsVariables = this.getElementsToProcess();
                if (!jsVariables.isEmpty()) {
                    functionText = functionText + (needOverride[0] ? " + \"{" : "{");
                    for (JSVariable var : jsVariables) {
                        if (!first) {
                            functionText = functionText + " + \",";
                        }
                        first = false;
                        functionText = functionText + var.getName() + "=\" + String(" + var.getName() + ")";
                    }
                    functionText = functionText + "+\"}\"";
                } else if (!needOverride[0]) {
                    functionText = functionText + "\"";
                }
                functionText = functionText + semicolon + "\n}";
                this.doAddOneMethod(project, functionText, this.anchor);
            }
        };
    }

    protected void collectCandidates(JSClass clazz, Collection<JSNamedElementNode> candidates) {
        JavaScriptGenerateToStringHandler.collectJSVariables((JSClass)clazz, candidates, (boolean)false, (boolean)false, (boolean)true);
    }

    protected boolean canHaveEmptySelectedElements() {
        return true;
    }
}

