/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections.actionscript;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.impl.quickfix.RenameElementFix;
import com.intellij.codeInsight.daemon.impl.quickfix.RenameFileFix;
import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.javascript.flex.resolve.ActionScriptClassResolver;
import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.findUsages.JSReadWriteAccessDetector;
import com.intellij.lang.javascript.flex.AddImportECMAScriptClassOrFunctionAction;
import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.lang.javascript.flex.FlexModuleType;
import com.intellij.lang.javascript.flex.ImportUtils;
import com.intellij.lang.javascript.flex.XmlBackedJSClassImpl;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.highlighting.JSSemanticHighlightingUtil;
import com.intellij.lang.javascript.inspections.actionscript.ActionScriptFunctionSignatureChecker;
import com.intellij.lang.javascript.inspections.actionscript.ActionScriptTypeChecker;
import com.intellij.lang.javascript.inspections.actionscript.DeclareConditionalCompilerDefinitionFix;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.e4x.JSE4XFilterQueryArgumentList;
import com.intellij.lang.javascript.psi.e4x.JSE4XNamespaceReference;
import com.intellij.lang.javascript.psi.ecmal4.JSAttribute;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeNameValuePair;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSImportStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSIncludeDirective;
import com.intellij.lang.javascript.psi.ecmal4.JSNamespaceDeclaration;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSAttributeImpl;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSAttributeListImpl;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSPackageStatementImpl;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSPackageWrapper;
import com.intellij.lang.javascript.psi.impl.JSReferenceExpressionImpl;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.primitives.JSStringType;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.lang.javascript.refactoring.changeSignature.JSMethodDescriptor;
import com.intellij.lang.javascript.ui.JSFormatUtil;
import com.intellij.lang.javascript.validation.DuplicatesCheckUtil;
import com.intellij.lang.javascript.validation.ImplementedMethodProcessor;
import com.intellij.lang.javascript.validation.JSAnnotatingVisitor;
import com.intellij.lang.javascript.validation.JSAnnotatorProblemReporter;
import com.intellij.lang.javascript.validation.JSProblemReporter;
import com.intellij.lang.javascript.validation.TypedJSAnnotatingVisitor;
import com.intellij.lang.javascript.validation.ValidateTypesUtil;
import com.intellij.lang.javascript.validation.fixes.ChangeSignatureFix;
import com.intellij.lang.javascript.validation.fixes.ChangeTypeFix;
import com.intellij.lang.javascript.validation.fixes.CreateClassOrInterfaceFix;
import com.intellij.lang.javascript.validation.fixes.CreateFlexMobileViewIntentionAndFix;
import com.intellij.lang.javascript.validation.fixes.CreateJSEventMethod;
import com.intellij.lang.javascript.validation.fixes.CreateJSFunctionIntentionAction;
import com.intellij.lang.javascript.validation.fixes.CreateJSPropertyAccessorIntentionAction;
import com.intellij.lang.javascript.validation.fixes.ImplementMethodsFix;
import com.intellij.lang.javascript.validation.fixes.JSAttributeListWrapper;
import com.intellij.lang.javascript.validation.fixes.RemoveASTNodeFix;
import com.intellij.lang.javascript.validation.fixes.SetElementVisibilityFix;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTagChild;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public class ActionScriptAnnotatingVisitor
extends TypedJSAnnotatingVisitor {
    private static final String[] EXTENSIONS_TO_CHECK = new String[]{"as", "js2", "es", "mxml", "fxg"};
    private static final List<TokenSet> ourModifiersList = Arrays.asList(TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.DYNAMIC_KEYWORD}), TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.STATIC_KEYWORD}), TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.FINAL_KEYWORD}), TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.OVERRIDE_KEYWORD}), TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.VIRTUAL_KEYWORD}));
    private static final String[] ourModifierFixIds = new String[]{"javascript.fix.remove.dynamic.modifier", "javascript.fix.remove.static.modifier", "javascript.fix.remove.final.modifier", "javascript.fix.remove.override.modifier", "javascript.fix.remove.virtual.modifier"};

    protected void initTypeCheckers(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/inspections/actionscript/ActionScriptAnnotatingVisitor", "initTypeCheckers"));
        }
        this.myProblemReporter = new JSAnnotatorProblemReporter(this.myHolder);
        this.myTypeChecker = new ActionScriptTypeChecker((JSProblemReporter<Annotation>)this.myProblemReporter);
        this.myFunctionSignatureChecker = new ActionScriptFunctionSignatureChecker(this.myTypeChecker, this.myProblemReporter);
    }

    public static void checkFileUnderSourceRoot(JSNamedElement aClass, JSAnnotatingVisitor.ErrorReportingClient client) {
        PsiFile containingFile;
        VirtualFile file;
        PsiElement nameIdentifier = aClass.getNameIdentifier();
        if (nameIdentifier == null) {
            nameIdentifier = aClass.getFirstChild();
        }
        if ((file = (containingFile = aClass.getContainingFile()).getVirtualFile()) == null) {
            return;
        }
        VirtualFile rootForFile = ProjectRootManager.getInstance((Project)containingFile.getProject()).getFileIndex().getSourceRootForFile(file);
        if (rootForFile == null) {
            client.reportError(nameIdentifier.getNode(), JSBundle.message((String)"javascript.validation.message.file.should.be.under.source.root", (Object[])new Object[0]), JSAnnotatingVisitor.ErrorReportingClient.ProblemKind.WARNING, new IntentionAction[0]);
        }
        if (!(aClass instanceof JSPackageStatement)) {
            VirtualFile parent = file.getParent();
            boolean found = false;
            for (String ext : EXTENSIONS_TO_CHECK) {
                String name = file.getNameWithoutExtension() + "." + ext;
                VirtualFile child = parent.findChild(name);
                if (child == null || !name.equals(child.getName())) continue;
                if (found) {
                    client.reportError(nameIdentifier.getNode(), JSBundle.message((String)"javascript.validation.message.more.than.one.named.object.in.package", (Object[])new Object[0]), JSAnnotatingVisitor.ErrorReportingClient.ProblemKind.ERROR, new IntentionAction[0]);
                    break;
                }
                found = true;
            }
        }
    }

    protected static ChangeSignatureFix createChangeBaseMethodSignatureFix(JSFunction superMethod, JSFunction override) {
        JSType type = override.getReturnType();
        String s = StringUtil.notNullize((String)(type != null ? type.getResolvedTypeText() : null));
        ChangeSignatureFix fix = new ChangeSignatureFix(superMethod, JSMethodDescriptor.getParameters((JSFunction)superMethod));
        fix.setOverriddenReturnType(s);
        return fix;
    }

    public void visitJSAttributeNameValuePair(JSAttributeNameValuePair attributeNameValuePair) {
        String baseClassFqns;
        boolean ok = this.checkReferences((PsiElement)attributeNameValuePair);
        if (!ok) {
            return;
        }
        if (attributeNameValuePair.getValueNode() == null) {
            return;
        }
        PsiElement parent = attributeNameValuePair.getParent();
        XmlElementDescriptor descriptor = parent instanceof JSAttributeImpl ? ((JSAttributeImpl)parent).getBackedDescriptor() : null;
        String attributeName = StringUtil.notNullize((String)attributeNameValuePair.getName(), (String)"_DEFAULT_");
        XmlAttributeDescriptor attributeDescriptor = descriptor == null ? null : descriptor.getAttributeDescriptor(attributeName, null);
        String string = baseClassFqns = attributeDescriptor == null ? null : attributeDescriptor.getDefaultValue();
        if (baseClassFqns != null && !StringUtil.isEmptyOrSpaces((String)baseClassFqns)) {
            PsiElement resolved;
            PsiReference[] references = attributeNameValuePair.getReferences();
            PsiReference lastReference = references.length > 0 ? references[0] : null;
            for (PsiReference reference : references) {
                if (reference.getRangeInElement().getEndOffset() <= lastReference.getRangeInElement().getEndOffset()) continue;
                lastReference = reference;
            }
            PsiElement psiElement = resolved = lastReference != null ? lastReference.resolve() : null;
            if (resolved instanceof JSClass) {
                boolean correctClass = false;
                ArrayList<String> resolvedBaseClasses = new ArrayList<String>();
                GlobalSearchScope scope = JSResolveUtil.getResolveScope((PsiElement)attributeNameValuePair);
                for (String baseClassFqn : StringUtil.split((String)baseClassFqns, (String)",")) {
                    if ("Object".equals(baseClassFqn)) {
                        correctClass = true;
                        break;
                    }
                    PsiElement baseClass = ActionScriptClassResolver.findClassByQNameStatic(baseClassFqn, (PsiElement)attributeNameValuePair);
                    if (!(baseClass instanceof JSClass)) continue;
                    resolvedBaseClasses.add(baseClassFqn);
                    if (!JSInheritanceUtil.isParentClass((JSClass)((JSClass)resolved), (JSClass)((JSClass)baseClass), (boolean)false, (GlobalSearchScope)scope)) continue;
                    correctClass = true;
                    break;
                }
                if (!correctClass) {
                    String classesForMessage = resolvedBaseClasses.isEmpty() ? StringUtil.replace((String)baseClassFqns, (String)",", (String)", ") : StringUtil.join(resolvedBaseClasses, (String)", ");
                    this.myHolder.createErrorAnnotation(ActionScriptAnnotatingVisitor.calcRangeForReferences((PsiReference)lastReference), JSBundle.message((String)"javascript.expected.class.or.descendant", (Object[])new Object[]{classesForMessage}));
                }
            } else if (resolved != attributeNameValuePair) {
                this.myHolder.createErrorAnnotation(attributeNameValuePair.getValueNode(), JSBundle.message((String)"javascript.qualified.class.name.expected", (Object[])new Object[0]));
            }
        }
    }

    public void visitJSIncludeDirective(JSIncludeDirective includeDirective) {
        this.checkReferences((PsiElement)includeDirective);
    }

    protected void checkImplementedMethods(JSClass jsClass, JSAnnotatingVisitor.ErrorReportingClient reportingClient) {
        ActionScriptAnnotatingVisitor.checkActionScriptImplementedMethods(jsClass, reportingClient);
    }

    public static void checkActionScriptImplementedMethods(JSClass jsClass, final JSAnnotatingVisitor.ErrorReportingClient reportingClient) {
        ImplementedMethodProcessor implementedMethodProcessor = new ImplementedMethodProcessor(jsClass){
            ImplementMethodsFix implementMethodsFix;
            {
                super(x0);
                this.implementMethodsFix = null;
            }

            protected void addNonimplementedFunction(JSFunction function) {
                ASTNode node = this.myJsClass.findNameIdentifier();
                if (node == null) {
                    return;
                }
                if (this.implementMethodsFix == null) {
                    this.implementMethodsFix = new ImplementMethodsFix(this.myJsClass);
                }
                this.implementMethodsFix.addElementToProcess((JSNamedElement)function);
                String messageId = function.isGetProperty() ? "javascript.validation.message.interface.method.not.implemented2" : (function.isSetProperty() ? "javascript.validation.message.interface.method.not.implemented3" : "javascript.validation.message.interface.method.not.implemented");
                String message = JSBundle.message((String)messageId, (Object[])new Object[]{function.getName(), ((JSClass)JSResolveUtil.findParent((PsiElement)function)).getQualifiedName()});
                reportingClient.reportError(node, message, JSAnnotatingVisitor.ErrorReportingClient.ProblemKind.ERROR, new IntentionAction[]{this.implementMethodsFix});
            }

            protected void addImplementedFunction(JSFunction interfaceFunction, JSFunction implementationFunction) {
                JSAnnotatingVisitor.SignatureMatchResult incompatibleSignature;
                JSAttributeList attributeList = implementationFunction.getAttributeList();
                if (attributeList == null || attributeList.getAccessType() != JSAttributeList.AccessType.PUBLIC) {
                    ASTNode node = ActionScriptAnnotatingVisitor.findElementForAccessModifierError((JSFunction)implementationFunction, (JSAttributeList)attributeList);
                    reportingClient.reportError(node, JSBundle.message((String)"javascript.validation.message.interface.method.invalid.access.modifier", (Object[])new Object[0]), JSAnnotatingVisitor.ErrorReportingClient.ProblemKind.ERROR, new IntentionAction[]{new SetElementVisibilityFix((JSAttributeListOwner)implementationFunction, JSAttributeList.AccessType.PUBLIC)});
                }
                if ((incompatibleSignature = ActionScriptAnnotatingVisitor.checkCompatibleSignature((JSFunction)implementationFunction, (JSFunction)interfaceFunction)) != JSAnnotatingVisitor.SignatureMatchResult.COMPATIBLE_SIGNATURE) {
                    PsiElement parent = JSResolveUtil.findParent((PsiElement)implementationFunction);
                    if (parent instanceof JSFile) {
                        parent = JSResolveUtil.getClassReferenceForXmlFromContext((PsiElement)parent);
                    }
                    if (parent != this.myJsClass) {
                        this.addNonimplementedFunction(interfaceFunction);
                        return;
                    }
                    if (incompatibleSignature == JSAnnotatingVisitor.SignatureMatchResult.PARAMETERS_DIFFERS) {
                        JSParameterList parameterList = implementationFunction.getParameterList();
                        JSParameterList expectedParameterList = interfaceFunction.getParameterList();
                        ChangeSignatureFix changeSignatureFix = new ChangeSignatureFix(interfaceFunction, parameterList, true);
                        reportingClient.reportError(parameterList.getNode(), JSBundle.message((String)"javascript.validation.message.interface.method.invalid.signature", (Object[])new Object[]{expectedParameterList != null ? expectedParameterList.getText() : "()"}), JSAnnotatingVisitor.ErrorReportingClient.ProblemKind.ERROR, new IntentionAction[]{new ChangeSignatureFix(implementationFunction, expectedParameterList, false){

                            @NotNull
                            public String getText() {
                                String string = JSBundle.message((String)"javascript.fix.message.change.parameters.to.expected", (Object[])new Object[0]);
                                if (string == null) {
                                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/actionscript/ActionScriptAnnotatingVisitor$1$1", "getText"));
                                }
                                return string;
                            }
                        }, changeSignatureFix});
                    } else if (incompatibleSignature == JSAnnotatingVisitor.SignatureMatchResult.RETURN_TYPE_DIFFERS) {
                        PsiElement implementationReturnTypeExpr = implementationFunction.getReturnTypeElement();
                        JSType type = interfaceFunction.getReturnType();
                        String interfaceReturnType = type != null ? type.getResolvedTypeText() : null;
                        String msg = JSBundle.message((String)"javascript.validation.message.interface.method.invalid.signature2", (Object[])new Object[]{StringUtil.notNullize((String)interfaceReturnType)});
                        reportingClient.reportError(implementationReturnTypeExpr != null ? implementationReturnTypeExpr.getNode() : implementationFunction.findNameIdentifier(), msg, JSAnnotatingVisitor.ErrorReportingClient.ProblemKind.ERROR, new IntentionAction[]{new ChangeTypeFix((JSNamedElement)implementationFunction, interfaceReturnType, "javascript.fix.message.change.return.type.to.expected"), ActionScriptAnnotatingVisitor.createChangeBaseMethodSignatureFix(interfaceFunction, implementationFunction)});
                    } else if (incompatibleSignature == JSAnnotatingVisitor.SignatureMatchResult.FUNCTION_KIND_DIFFERS) {
                        String msg = JSBundle.message((String)"javascript.validation.message.interface.method.invalid.signature3", (Object[])new Object[]{interfaceFunction.getKind()});
                        reportingClient.reportError(implementationFunction.findNameIdentifier(), msg, JSAnnotatingVisitor.ErrorReportingClient.ProblemKind.ERROR, new IntentionAction[0]);
                    }
                }
            }
        };
        JSResolveUtil.processInterfaceMethods((JSClass)jsClass, (JSResolveUtil.CollectMethodsToImplementProcessor)implementedMethodProcessor);
    }

    protected void checkFunction(JSFunction node) {
        ASTNode nameIdentifier = node.findNameIdentifier();
        if (nameIdentifier == null) {
            return;
        }
        PsiElement parent = node.getParent();
        if (parent instanceof JSFile) {
            parent = JSResolveUtil.getClassReferenceForXmlFromContext((PsiElement)parent);
            String name = node.getName();
            if (parent instanceof JSClass && name != null && name.equals(((JSClass)parent).getName()) && JavaScriptSupportLoader.isFlexMxmFile((PsiFile)parent.getContainingFile())) {
                Annotation annotation = this.myHolder.createErrorAnnotation(nameIdentifier, JSBundle.message((String)"javascript.validation.message.constructor.in.mxml.is.not.allowed", (Object[])new Object[0]));
                annotation.registerFix((IntentionAction)new RemoveASTNodeFix("javascript.fix.remove.constructor", node.getNode()));
            }
        }
        if (parent instanceof JSPackageStatement) {
            this.checkNamedObjectIsInCorrespondingFile((JSNamedElement)node);
        }
        if (parent instanceof JSClass && !node.isConstructor()) {
            JSAttributeList attributeList = node.getAttributeList();
            JSClass clazz = (JSClass)parent;
            if (attributeList == null || !attributeList.hasModifier(JSAttributeList.ModifierType.STATIC) && (attributeList.getAccessType() != JSAttributeList.AccessType.PRIVATE || attributeList.hasModifier(JSAttributeList.ModifierType.OVERRIDE))) {
                boolean hasOverride;
                Ref set;
                final String qName = clazz.getQualifiedName();
                boolean b = JSResolveUtil.iterateType((JSPsiElementBase)node, (PsiElement)parent, (String)qName, (JSResolveUtil.OverrideHandler)new JSResolveUtil.OverrideHandler(set = new Ref(), hasOverride = attributeList != null && attributeList.hasModifier(JSAttributeList.ModifierType.OVERRIDE), attributeList, nameIdentifier, node, clazz){
                    final /* synthetic */ Ref val$set;
                    final /* synthetic */ boolean val$hasOverride;
                    final /* synthetic */ JSAttributeList val$attributeList;
                    final /* synthetic */ ASTNode val$nameIdentifier;
                    final /* synthetic */ JSFunction val$node;
                    final /* synthetic */ JSClass val$clazz;
                    {
                        this.val$set = ref;
                        this.val$hasOverride = bl;
                        this.val$attributeList = jSAttributeList;
                        this.val$nameIdentifier = aSTNode;
                        this.val$node = jSFunction;
                        this.val$clazz = jSClass;
                    }

                    public boolean process(SinkResolveProcessor processor, PsiElement scope, String className) {
                        DialectOptionHolder holder;
                        if (qName == className || qName != null && qName.equals(className)) {
                            return true;
                        }
                        JSFunction value = (JSFunction)processor.getResult();
                        this.val$set.set((Object)value);
                        if ("Object".equals(className)) {
                            if (this.val$hasOverride && !this.val$attributeList.hasModifier(JSAttributeList.ModifierType.NATIVE)) {
                                ASTNode astNode = this.val$attributeList.getNode().findChildByType(JSTokenTypes.OVERRIDE_KEYWORD);
                                Annotation annotation = ActionScriptAnnotatingVisitor.this.myHolder.createErrorAnnotation(astNode, JSBundle.message((String)"javascript.validation.message.function.override.for.object.method", (Object[])new Object[0]));
                                annotation.registerFix((IntentionAction)new RemoveASTNodeFix("javascript.fix.remove.override.modifier", astNode));
                            }
                            return false;
                        }
                        if (!this.val$hasOverride && (holder = ActionScriptAnnotatingVisitor.this.myHighlighter.getDialectOptionsHolder()) != null && holder.isECMA4) {
                            Annotation annotation = ActionScriptAnnotatingVisitor.this.myHolder.createErrorAnnotation(this.val$nameIdentifier, JSBundle.message((String)"javascript.validation.message.function.override.without.override.modifier", (Object[])new Object[]{className}));
                            annotation.registerFix((IntentionAction)new AddOverrideIntentionAction(this.val$node));
                        } else {
                            JSAttributeList attrList = value.getAttributeList();
                            JSAttributeList parentAttrList = ((JSAttributeListOwner)scope).getAttributeList();
                            if (attrList != null && attrList.hasModifier(JSAttributeList.ModifierType.FINAL) || parentAttrList != null && parentAttrList.hasModifier(JSAttributeList.ModifierType.FINAL)) {
                                ActionScriptAnnotatingVisitor.this.myHolder.createErrorAnnotation(this.val$attributeList.getNode().findChildByType(JSTokenTypes.OVERRIDE_KEYWORD), JSBundle.message((String)"javascript.validation.message.can.not.override.final.method", (Object[])new Object[]{className}));
                            }
                        }
                        if (this.val$clazz.isInterface()) {
                            ActionScriptAnnotatingVisitor.this.myHolder.createErrorAnnotation(this.val$nameIdentifier, JSBundle.message((String)"javascript.validation.message.function.override.for.interface", (Object[])new Object[]{className}));
                        }
                        return false;
                    }
                });
                if (b && hasOverride) {
                    ASTNode astNode = attributeList.getNode().findChildByType(JSTokenTypes.OVERRIDE_KEYWORD);
                    Annotation annotation = this.myHolder.createErrorAnnotation(astNode, JSBundle.message((String)"javascript.validation.message.function.override.without.parent.method", (Object[])new Object[0]));
                    annotation.registerFix((IntentionAction)new RemoveASTNodeFix("javascript.fix.remove.override.modifier", astNode));
                }
                if (!b && hasOverride) {
                    JSAnnotatingVisitor.SignatureMatchResult incompatibleSignature;
                    JSFunction override = (JSFunction)set.get();
                    JSAttributeList overrideAttrList = override.getAttributeList();
                    String overrideNs = null;
                    if (attributeList.getAccessType() != overrideAttrList.getAccessType() || (overrideNs = JSResolveUtil.getNamespaceValue((JSAttributeList)overrideAttrList)) != null && !overrideNs.equals(JSResolveUtil.getNamespaceValue((JSAttributeList)attributeList))) {
                        SetElementVisibilityFix fix;
                        String newVisibility;
                        if (overrideNs != null) {
                            newVisibility = overrideNs;
                            fix = new SetElementVisibilityFix((JSAttributeListOwner)node, overrideNs);
                        } else {
                            newVisibility = JSFormatUtil.formatVisibility((JSAttributeList.AccessType)overrideAttrList.getAccessType());
                            fix = new SetElementVisibilityFix((JSAttributeListOwner)node, overrideAttrList.getAccessType());
                        }
                        Annotation annotation = this.myHolder.createErrorAnnotation(ActionScriptAnnotatingVisitor.findElementForAccessModifierError((JSFunction)node, (JSAttributeList)attributeList), JSBundle.message((String)"javascript.validation.message.function.override.incompatible.access.modifier", (Object[])new Object[]{newVisibility}));
                        annotation.registerFix((IntentionAction)fix);
                    }
                    if ((incompatibleSignature = ActionScriptAnnotatingVisitor.checkCompatibleSignature((JSFunction)node, (JSFunction)override)) == JSAnnotatingVisitor.SignatureMatchResult.PARAMETERS_DIFFERS) {
                        JSParameterList nodeParameterList = node.getParameterList();
                        JSParameterList overrideParameterList = override.getParameterList();
                        Annotation annotation = this.myHolder.createErrorAnnotation(nodeParameterList != null ? nodeParameterList.getNode() : node.findNameIdentifier(), JSBundle.message((String)"javascript.validation.message.function.override.incompatible.signature", (Object[])new Object[]{overrideParameterList != null ? overrideParameterList.getText() : "()"}));
                        annotation.registerFix((IntentionAction)new ChangeSignatureFix(node, overrideParameterList, false){

                            @NotNull
                            public String getText() {
                                String string = JSBundle.message((String)"javascript.fix.message.change.parameters.to.expected", (Object[])new Object[0]);
                                if (string == null) {
                                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/actionscript/ActionScriptAnnotatingVisitor$3", "getText"));
                                }
                                return string;
                            }
                        });
                        annotation.registerFix((IntentionAction)new ChangeSignatureFix(override, nodeParameterList, true));
                    } else if (incompatibleSignature == JSAnnotatingVisitor.SignatureMatchResult.RETURN_TYPE_DIFFERS) {
                        PsiElement returnTypeExpr = node.getReturnTypeElement();
                        JSType type = override.getReturnType();
                        String baseReturnType = type != null ? type.getResolvedTypeText() : null;
                        String msg = JSBundle.message((String)"javascript.validation.message.function.override.incompatible.signature2", (Object[])new Object[]{StringUtil.notNullize((String)baseReturnType)});
                        Annotation annotation = this.myHolder.createErrorAnnotation(returnTypeExpr != null ? returnTypeExpr.getNode() : node.findNameIdentifier(), msg);
                        annotation.registerFix((IntentionAction)new ChangeTypeFix((JSNamedElement)node, baseReturnType, "javascript.fix.message.change.return.type.to.expected"));
                        annotation.registerFix((IntentionAction)ActionScriptAnnotatingVisitor.createChangeBaseMethodSignatureFix(override, node));
                    } else if (incompatibleSignature == JSAnnotatingVisitor.SignatureMatchResult.FUNCTION_KIND_DIFFERS) {
                        String msg = JSBundle.message((String)"javascript.validation.message.function.override.incompatible.signature3", (Object[])new Object[]{override.getKind().toString()});
                        Annotation annotation = this.myHolder.createErrorAnnotation(node.findNameIdentifier(), msg);
                    }
                }
            } else if (attributeList.hasModifier(JSAttributeList.ModifierType.STATIC)) {
                if (clazz.isInterface()) {
                    this.reportStaticMethodProblem(attributeList, "javascript.validation.message.static.method.in.interface");
                }
                if (attributeList.hasModifier(JSAttributeList.ModifierType.OVERRIDE)) {
                    this.reportStaticMethodProblem(attributeList, "javascript.validation.message.static.method.with.override");
                }
            }
        }
        super.checkFunction(node);
    }

    private void reportStaticMethodProblem(JSAttributeList attributeList, String key) {
        ASTNode astNode = attributeList.getNode().findChildByType(JSTokenTypes.STATIC_KEYWORD);
        Annotation annotation = this.myHolder.createErrorAnnotation(astNode, JSBundle.message((String)key, (Object[])new Object[0]));
        annotation.registerFix((IntentionAction)new RemoveASTNodeFix("javascript.fix.remove.static.modifier", astNode));
    }

    public void visitJSPackageStatement(JSPackageStatement packageStatement) {
        ASTNode node;
        boolean injected;
        JSFile jsFile = (JSFile)PsiTreeUtil.getParentOfType((PsiElement)packageStatement, JSFile.class);
        PsiElement context = jsFile == null ? null : jsFile.getContext();
        boolean bl = injected = context instanceof XmlAttributeValue || context instanceof XmlText;
        if (injected) {
            this.myHolder.createErrorAnnotation(packageStatement.getFirstChild().getNode(), JSBundle.message((String)"javascript.validation.message.nested.packages.are.not.allowed", (Object[])new Object[0]));
            return;
        }
        for (PsiElement el = packageStatement.getPrevSibling(); el != null; el = el.getPrevSibling()) {
            if (el instanceof PsiWhiteSpace || el instanceof PsiComment) continue;
            this.myHolder.createErrorAnnotation(packageStatement.getFirstChild().getNode(), JSBundle.message((String)"javascript.validation.message.package.shouldbe.first.statement", (Object[])new Object[0]));
            break;
        }
        if ((node = packageStatement.findNameIdentifier()) == null) {
            this.checkPackageStatement(packageStatement);
        }
    }

    private void checkPackageStatement(final JSPackageStatement packageStatement) {
        String s = packageStatement.getQualifiedName();
        PsiFile containingFile = packageStatement.getContainingFile();
        final String expected = JSResolveUtil.getExpectedPackageNameFromFile((VirtualFile)containingFile.getVirtualFile(), (Project)containingFile.getProject());
        if (expected != null && (s == null && expected.length() != 0 || s != null && !expected.equals(s))) {
            ASTNode nameIdentifier = packageStatement.findNameIdentifier();
            Annotation annotation = this.myHolder.createErrorAnnotation(nameIdentifier != null ? nameIdentifier : packageStatement.getFirstChild().getNode(), JSBundle.message((String)"javascript.validation.message.incorrect.package.name", (Object[])new Object[]{s, expected}));
            annotation.registerFix(new IntentionAction(){

                @NotNull
                public String getText() {
                    String string = JSBundle.message((String)"javascript.fix.package.name", (Object[])new Object[]{expected});
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/actionscript/ActionScriptAnnotatingVisitor$4", "getText"));
                    }
                    return string;
                }

                @NotNull
                public String getFamilyName() {
                    String string = this.getText();
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/actionscript/ActionScriptAnnotatingVisitor$4", "getFamilyName"));
                    }
                    return string;
                }

                public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
                    if (project == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/inspections/actionscript/ActionScriptAnnotatingVisitor$4", "isAvailable"));
                    }
                    return packageStatement.isValid();
                }

                public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
                    if (project == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/inspections/actionscript/ActionScriptAnnotatingVisitor$4", "invoke"));
                    }
                    JSPackageStatementImpl.doChangeName((Project)project, (JSPackageStatement)packageStatement, (String)expected);
                }

                public boolean startInWriteAction() {
                    return true;
                }
            });
        }
        THashSet elements = new THashSet();
        for (JSSourceElement statement : packageStatement.getStatements()) {
            if (statement instanceof JSNamedElement && !(statement instanceof JSImportStatement)) {
                elements.add((JSNamedElement)statement);
                continue;
            }
            if (!(statement instanceof JSVarStatement)) continue;
            ContainerUtil.addAll((Collection)elements, (Object[])((JSVarStatement)statement).getVariables());
        }
        if (elements.size() > 1) {
            for (JSNamedElement el : elements) {
                JSAttributeList attributeList;
                if (!(el instanceof JSAttributeListOwner) || (attributeList = ((JSAttributeListOwner)el).getAttributeList()) != null && attributeList.getConditionalCompileVariableReference() != null) continue;
                ASTNode nameIdentifier = el.findNameIdentifier();
                this.myHolder.createErrorAnnotation(nameIdentifier != null ? nameIdentifier : el.getFirstChild().getNode(), JSBundle.message((String)"javascript.validation.message.more.than.one.externally.visible.symbol", (Object[])new Object[0])).registerFix((IntentionAction)new RemoveASTNodeFix("javascript.fix.remove.externally.visible.symbol", el.getNode()));
            }
        }
        ActionScriptAnnotatingVisitor.checkFileUnderSourceRoot((JSNamedElement)packageStatement, (JSAnnotatingVisitor.ErrorReportingClient)new JSAnnotatingVisitor.SimpleErrorReportingClient((JSAnnotatingVisitor)this));
    }

    public void visitJSReferenceExpression(JSReferenceExpression node) {
        JSNamedElement namedElement;
        ASTNode nameIdentifier;
        super.visitJSReferenceExpression(node);
        PsiElement parent = node.getParent();
        if (node.getQualifier() == null) {
            String nodeText = node.getText();
            if (!(parent instanceof JSCallExpression) && JSResolveUtil.isExprInStrictTypeContext((JSReferenceExpression)node) && "Vector".equals(nodeText)) {
                this.myHolder.createWarningAnnotation((PsiElement)node, JSBundle.message((String)"javascript.validation.message.vector.without.parameters", (Object[])new Object[0]));
            } else if (parent instanceof JSNewExpression && "Vector".equals(nodeText)) {
                this.myHolder.createWarningAnnotation((PsiElement)node, JSBundle.message((String)"javascript.validation.message.vector.without.parameters2", (Object[])new Object[0]));
            }
        }
        if (parent instanceof JSNamedElement && (nameIdentifier = (namedElement = (JSNamedElement)parent).findNameIdentifier()) != null && nameIdentifier.getPsi() == node) {
            if (parent instanceof JSPackageStatement) {
                this.checkPackageStatement((JSPackageStatement)parent);
            } else if (!(parent instanceof JSImportStatement) && parent.getParent() instanceof JSPackageStatement) {
                this.checkNamedObjectIsInCorrespondingFile(namedElement);
            } else if (parent instanceof JSVariable) {
                if (parent.getParent().getParent() instanceof JSPackageStatement) {
                    this.checkNamedObjectIsInCorrespondingFile((JSNamedElement)((JSVariable)parent));
                }
            } else if (parent instanceof JSNamespaceDeclaration) {
                DuplicatesCheckUtil.checkDuplicates((JSNamedElement)((JSNamespaceDeclaration)parent), (JSAnnotatorProblemReporter)this.myProblemReporter);
            }
            if (parent instanceof JSClass) {
                boolean clazzParentIsInjectedJsFile;
                JSClass jsClass = (JSClass)parent;
                JSFunction constructor = jsClass.getConstructor();
                if (constructor == null) {
                    this.checkMissedSuperCall(node, constructor, jsClass);
                }
                PsiElement clazzParent = jsClass.getParent();
                PsiElement context = clazzParent.getContext();
                boolean bl = clazzParentIsInjectedJsFile = clazzParent instanceof JSFile && (context instanceof XmlAttributeValue || context instanceof XmlText) && !XmlBackedJSClassImpl.isImplementsAttribute((JSFile)((JSFile)clazzParent));
                if (PsiTreeUtil.getParentOfType((PsiElement)jsClass, (Class[])new Class[]{JSFunction.class, JSClass.class}) != null || clazzParentIsInjectedJsFile) {
                    this.myHolder.createErrorAnnotation((PsiElement)node, JSBundle.message((String)"javascript.validation.message.nested.classes.are.not.allowed", (Object[])new Object[0]));
                }
                this.checkClass(jsClass);
            }
        }
    }

    private void checkClass(JSClass jsClass) {
        if (!jsClass.isInterface()) {
            this.checkIfExtendsFinalOrMultipleClasses(jsClass);
        }
        DuplicatesCheckUtil.checkDuplicates((JSNamedElement)jsClass, (JSAnnotatorProblemReporter)this.myProblemReporter);
    }

    private void checkIfExtendsFinalOrMultipleClasses(JSClass jsClass) {
        JSReferenceList extendsList = jsClass.getExtendsList();
        if (extendsList != null) {
            String[] extendsListTexts = extendsList.getReferenceTexts();
            if (extendsListTexts.length > 1) {
                this.myHolder.createErrorAnnotation(extendsList.getTextRange(), JSBundle.message((String)"javascript.validation.message.extend.multiple.classes", (Object[])new Object[0]));
            } else if (extendsListTexts.length == 1) {
                JSExpression[] referencesToSuper;
                JSAttributeList attributeList;
                JSClass[] superClasses = jsClass.getSuperClasses();
                JSAttributeList jSAttributeList = attributeList = superClasses.length > 0 ? superClasses[0].getAttributeList() : null;
                if (attributeList != null && attributeList.hasModifier(JSAttributeList.ModifierType.FINAL) && (referencesToSuper = extendsList.getExpressions()).length == 1) {
                    this.myHolder.createErrorAnnotation((PsiElement)referencesToSuper[0], JSBundle.message((String)"javascript.validation.message.extend.final.class", (Object[])new Object[]{superClasses[0].getQualifiedName()}));
                }
            }
        }
    }

    public void visitJSAttributeList(JSAttributeList attributeList) {
        JSReferenceExpression namespaceElement = attributeList.getNamespaceElement();
        PsiElement accessTypeElement = attributeList.findAccessTypeElement();
        JSReferenceExpression namespaceOrAccessModifierElement = namespaceElement;
        ASTNode[] children = attributeList.getNode().getChildren(JSAttributeListImpl.ourModifiersTypeSet);
        if (namespaceOrAccessModifierElement == null) {
            namespaceOrAccessModifierElement = accessTypeElement;
        } else if (accessTypeElement != null) {
            this.myHolder.createErrorAnnotation((PsiElement)namespaceOrAccessModifierElement, JSBundle.message((String)"javascript.validation.message.use.namespace.reference.or.access.modifier", (Object[])new Object[0])).registerFix((IntentionAction)new RemoveASTNodeFix("javascript.fix.remove.namespace.reference", namespaceOrAccessModifierElement.getNode()));
            this.myHolder.createErrorAnnotation(accessTypeElement, JSBundle.message((String)"javascript.validation.message.use.namespace.reference.or.access.modifier", (Object[])new Object[0])).registerFix((IntentionAction)new RemoveASTNodeFix("javascript.fix.remove.visibility.modifier", accessTypeElement.getNode()));
        }
        if (children.length > 1 && namespaceElement == null) {
            for (ASTNode astNode : children) {
                this.myHolder.createErrorAnnotation(astNode, JSBundle.message((String)"javascript.validation.message.one.visibility.modifier.allowed", (Object[])new Object[0])).registerFix((IntentionAction)new RemoveASTNodeFix("javascript.fix.remove.visibility.modifier", astNode));
            }
        }
        PsiElement element = attributeList.getParent();
        PsiElement parentForCheckingNsOrAccessModifier = JSResolveUtil.findParent((PsiElement)element);
        if (namespaceOrAccessModifierElement != null) {
            JSAttributeList.AccessType accessType;
            if (!(parentForCheckingNsOrAccessModifier instanceof JSClass)) {
                String typeElementText;
                boolean nodeUnderPackage = parentForCheckingNsOrAccessModifier instanceof JSPackageStatement;
                if (!((nodeUnderPackage || ActionScriptAnnotatingVisitor.hasQualifiedName(element) || parentForCheckingNsOrAccessModifier instanceof JSFile && attributeList.getAccessType() == JSAttributeList.AccessType.PACKAGE_LOCAL) && ("public".equals(typeElementText = namespaceOrAccessModifierElement.getText()) || "internal".equals(typeElementText)))) {
                    boolean nsRef = namespaceOrAccessModifierElement instanceof JSReferenceExpression;
                    String message = JSBundle.message((String)(nodeUnderPackage ? "javascript.validation.message.access.modifier.allowed.only.for.package.members" : (nsRef ? "javascript.validation.message.namespace.allowed.only.for.class.members" : "javascript.validation.message.access.modifier.allowed.only.for.class.members")), (Object[])new Object[0]);
                    Annotation annotation = parentForCheckingNsOrAccessModifier instanceof JSFile && !(element instanceof JSClass) ? this.myHolder.createWarningAnnotation((PsiElement)namespaceOrAccessModifierElement, message) : this.myHolder.createErrorAnnotation((PsiElement)namespaceOrAccessModifierElement, message);
                    annotation.registerFix((IntentionAction)new RemoveASTNodeFix(nsRef ? "javascript.fix.remove.namespace.reference" : "javascript.fix.remove.access.modifier", namespaceOrAccessModifierElement.getNode()));
                }
            } else if (((JSClass)parentForCheckingNsOrAccessModifier).isInterface()) {
                if (attributeList.getAccessType() != JSAttributeList.AccessType.PACKAGE_LOCAL || attributeList.getNode().findChildByType(JSTokenTypes.INTERNAL_KEYWORD) != null) {
                    ASTNode astNode = attributeList.getNode().findChildByType(JSTokenTypes.ACCESS_MODIFIERS);
                    String message = JSBundle.message((String)"javascript.validation.message.interface.members.cannot.have.access.modifiers", (Object[])new Object[0]);
                    String fixMessageKey = "javascript.fix.remove.access.modifier";
                    if (astNode == null) {
                        astNode = attributeList.getNode().findChildByType(JSElementTypes.REFERENCE_EXPRESSION);
                        message = JSBundle.message((String)"javascript.validation.message.interface.members.cannot.have.namespace.attributes", (Object[])new Object[0]);
                        fixMessageKey = "javascript.fix.remove.namespace.reference";
                    }
                    Annotation annotation = this.myHolder.createErrorAnnotation(astNode, message);
                    annotation.registerFix((IntentionAction)new RemoveASTNodeFix(fixMessageKey, astNode));
                }
            } else if (element instanceof JSFunction && ((JSFunction)element).isConstructor() && (accessType = attributeList.getAccessType()) != JSAttributeList.AccessType.PUBLIC) {
                this.myHolder.createErrorAnnotation(namespaceOrAccessModifierElement.getNode(), JSBundle.message((String)"javascript.validation.message.constructor.cannot.have.custom.visibility", (Object[])new Object[0]));
            }
        }
        if (attributeList.hasModifier(JSAttributeList.ModifierType.FINAL)) {
            PsiElement parent;
            if (element instanceof JSClass) {
                if (((JSClass)element).isInterface()) {
                    this.finalModifierProblem(attributeList, "javascript.validation.message.interface.cannot.be.final.modifiers");
                }
            } else if (parentForCheckingNsOrAccessModifier instanceof JSClass && ((JSClass)parentForCheckingNsOrAccessModifier).isInterface()) {
                this.finalModifierProblem(attributeList, "javascript.validation.message.interface.members.cannot.be.final.modifiers");
            } else if (!(element instanceof JSFunction) || (parent = element.getParent()) instanceof JSPackageStatement || parent instanceof JSFile && parent.getContext() == null) {
                this.finalModifierProblem(attributeList, "javascript.validation.message.final.modifier.allowed.only.for.methods");
            }
        }
        if (attributeList.hasExplicitModifier(JSAttributeList.ModifierType.STATIC)) {
            if (element instanceof JSFunction || element instanceof JSVarStatement) {
                if (!(parentForCheckingNsOrAccessModifier instanceof JSClass)) {
                    PsiElement modifierElement = attributeList.findModifierElement(JSAttributeList.ModifierType.STATIC);
                    String message = JSBundle.message((String)"javascript.validation.message.static.modifier.is.allowed.only.for.class.members", (Object[])new Object[0]);
                    Annotation annotation = parentForCheckingNsOrAccessModifier instanceof JSFile ? this.myHolder.createWarningAnnotation(modifierElement, message) : this.myHolder.createErrorAnnotation(modifierElement, message);
                    annotation.registerFix((IntentionAction)new RemoveASTNodeFix("javascript.fix.remove.static.modifier", modifierElement.getNode()));
                } else if (element instanceof JSFunction && ((JSFunction)element).isConstructor()) {
                    this.modifierProblem(attributeList, JSAttributeList.ModifierType.STATIC, "javascript.validation.message.constructor.cannot.be.static", "javascript.fix.remove.static.modifier");
                }
            } else if (element instanceof JSNamespaceDeclaration || element instanceof JSClass) {
                this.modifierProblem(attributeList, JSAttributeList.ModifierType.STATIC, "javascript.validation.message.static.modifier.is.allowed.only.for.class.members", "javascript.fix.remove.static.modifier");
            }
            if (attributeList.hasModifier(JSAttributeList.ModifierType.FINAL) && element instanceof JSFunction) {
                this.finalModifierProblem(attributeList, "javascript.validation.message.static.method.cannot.be.final");
            }
        }
        if (attributeList.hasModifier(JSAttributeList.ModifierType.OVERRIDE) && !(element instanceof JSFunction)) {
            this.modifierProblem(attributeList, JSAttributeList.ModifierType.OVERRIDE, "javascript.validation.message.override.can.be.applied.to.method", "javascript.fix.remove.override.modifier");
        }
        if (attributeList.hasModifier(JSAttributeList.ModifierType.DYNAMIC) && (!(element instanceof JSClass) || ((JSClass)element).isInterface())) {
            this.modifierProblem(attributeList, JSAttributeList.ModifierType.DYNAMIC, "javascript.validation.message.dynamic.can.be.applied.to.class", "javascript.fix.remove.dynamic.modifier");
        }
        this.checkMultipleModifiersProblem(attributeList);
    }

    private void finalModifierProblem(JSAttributeList attributeList, String messageKey) {
        this.modifierProblem(attributeList, JSAttributeList.ModifierType.FINAL, messageKey, "javascript.fix.remove.final.modifier");
    }

    private void modifierProblem(JSAttributeList attributeList, JSAttributeList.ModifierType modifierType, String messageKey, String removeFixNameKey) {
        PsiElement modifierElement = attributeList.findModifierElement(modifierType);
        String message = JSBundle.message((String)messageKey, (Object[])new Object[0]);
        Annotation annotation = this.myHolder.createErrorAnnotation(modifierElement, message);
        annotation.registerFix((IntentionAction)new RemoveASTNodeFix(removeFixNameKey, modifierElement.getNode()));
    }

    private static boolean hasQualifiedName(PsiElement element) {
        String qName = element instanceof JSQualifiedNamedElement ? ((JSQualifiedNamedElement)element).getQualifiedName() : null;
        return qName != null && qName.indexOf(46) != -1;
    }

    private void checkMultipleModifiersProblem(JSAttributeList attributeList) {
        ASTNode node = attributeList.getNode();
        for (int i = 0; i < ourModifiersList.size(); ++i) {
            ASTNode[] modifiers = node.getChildren(ourModifiersList.get(i));
            if (modifiers.length < 2) continue;
            String s = modifiers[0].getElementType().toString().toLowerCase(Locale.ENGLISH);
            String type = s.substring(s.indexOf(58) + 1, s.indexOf(95));
            for (ASTNode a : modifiers) {
                Annotation errorAnnotation = JSAnnotatorProblemReporter.createErrorAnnotation((PsiElement)a.getPsi(), (String)JSBundle.message((String)"javascript.validation.message.attribute.was.specified.multiple.times", (Object[])new Object[]{type}), (ProblemHighlightType)ProblemHighlightType.ERROR, (AnnotationHolder)this.myHolder);
                errorAnnotation.registerFix((IntentionAction)new RemoveASTNodeFix(ourModifierFixIds[i], a));
            }
        }
    }

    @Nullable
    protected LocalQuickFix getPreferredQuickFixForUnresolvedRef(final PsiElement nameIdentifier) {
        JSExpression[] params;
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)nameIdentifier);
        if (module == null || ModuleType.get((Module)module) != FlexModuleType.getInstance()) {
            return null;
        }
        String conditionalCompilerDefinitionName = ActionScriptAnnotatingVisitor.getPotentialConditionalCompilerDefinitionName(nameIdentifier);
        if (conditionalCompilerDefinitionName != null) {
            return new DeclareConditionalCompilerDefinitionFix(module, conditionalCompilerDefinitionName);
        }
        JSCallExpression callExpression = (JSCallExpression)PsiTreeUtil.getParentOfType((PsiElement)nameIdentifier, JSCallExpression.class);
        if (callExpression == null) {
            return null;
        }
        if (JSResolveUtil.isEventListenerCall((JSCallExpression)callExpression)) {
            final JSExpression[] params2 = callExpression.getArguments();
            if (params2.length >= 2 && PsiTreeUtil.isAncestor((PsiElement)params2[1], (PsiElement)nameIdentifier, (boolean)true)) {
                return new CreateJSEventMethod(nameIdentifier.getText(), new Computable<String>(){

                    public String compute() {
                        JSExpression responsibleElement = null;
                        if (params2[0] instanceof JSReferenceExpression) {
                            responsibleElement = ((JSReferenceExpression)params2[0]).getQualifier();
                        }
                        return responsibleElement == null ? "flash.events.Event" : responsibleElement.getText();
                    }
                });
            }
        } else if (ActionScriptAnnotatingVisitor.needsFlexMobileViewAsFirstArgument(callExpression) && (params = callExpression.getArguments()).length >= 1 && PsiTreeUtil.isAncestor((PsiElement)params[0], (PsiElement)nameIdentifier, (boolean)true)) {
            final String contextPackage = JSResolveUtil.getPackageNameFromPlace((PsiElement)callExpression);
            String fqn = StringUtil.getQualifiedName((String)contextPackage, (String)nameIdentifier.getText());
            CreateFlexMobileViewIntentionAndFix fix = new CreateFlexMobileViewIntentionAndFix(fqn, nameIdentifier, true);
            fix.setCreatedClassFqnConsumer(new Consumer<String>(){

                public void consume(String fqn) {
                    String packageName = StringUtil.getPackageName((String)fqn);
                    if (StringUtil.isNotEmpty((String)packageName) && !packageName.equals(contextPackage)) {
                        ImportUtils.doImport((PsiElement)nameIdentifier, (String)fqn, (boolean)true);
                    }
                }
            });
            return fix;
        }
        return null;
    }

    @Nullable
    private static String getPotentialConditionalCompilerDefinitionName(PsiElement identifier) {
        PsiElement parent3;
        PsiElement parent1 = identifier.getParent();
        PsiElement parent2 = parent1 == null ? null : parent1.getParent();
        PsiElement psiElement = parent3 = parent2 == null ? null : parent2.getParent();
        if (parent1 instanceof JSReferenceExpression && ((JSReferenceExpression)parent1).getQualifier() == null && parent2 instanceof JSE4XNamespaceReference && parent3 instanceof JSReferenceExpression && ((JSReferenceExpression)parent3).getQualifier() == null) {
            return ActionScriptAnnotatingVisitor.getNormalizedConditionalCompilerDefinitionName(parent3.getText());
        }
        return null;
    }

    @Nullable
    private static String getNormalizedConditionalCompilerDefinitionName(String name) {
        int colonsIndex = name.indexOf("::");
        if (colonsIndex > 0) {
            String first = name.substring(0, colonsIndex).trim();
            String second = name.substring(colonsIndex + "::".length()).trim();
            if (StringUtil.isJavaIdentifier((String)first) && StringUtil.isJavaIdentifier((String)second)) {
                return first + "::" + second;
            }
        }
        return null;
    }

    private static boolean needsFlexMobileViewAsFirstArgument(JSCallExpression callExpression) {
        JSExpression methodExpr = callExpression.getMethodExpression();
        PsiElement function = methodExpr instanceof JSReferenceExpression ? ((JSReferenceExpression)methodExpr).resolve() : null;
        PsiElement clazz = function instanceof JSFunction && ArrayUtil.contains((String)((JSFunction)function).getName(), (String[])new String[]{"pushView", "replaceView"}) ? function.getParent() : null;
        return clazz instanceof JSClass && "spark.components.ViewNavigator".equals(((JSClass)clazz).getQualifiedName());
    }

    public void visitJSAttribute(JSAttribute jsAttribute) {
        JSType type;
        JSVariable var;
        JSVarStatement varStatement;
        if (!(!"Embed".equals(jsAttribute.getName()) || (varStatement = (JSVarStatement)PsiTreeUtil.getParentOfType((PsiElement)jsAttribute, JSVarStatement.class)) == null || (var = (JSVariable)ArrayUtil.getFirstElement((Object[])varStatement.getVariables())) == null || (type = var.getType()) instanceof JSStringType || type instanceof JSTypeImpl && "Class".equals(type.getTypeText(JSType.TypeTextFormat.SIMPLE)))) {
            this.myHolder.createErrorAnnotation((PsiElement)jsAttribute, JSBundle.message((String)"javascript.validation.message.embed.annotation.used.with.var.of.wrong.type", (Object[])new Object[0]));
        }
        JSSemanticHighlightingUtil.highlight((JSAttribute)jsAttribute, (AnnotationHolder)this.myHolder);
        PsiReference psiReference = jsAttribute.getReference();
        if (psiReference != null && psiReference.resolve() == null) {
            this.myHolder.createWeakWarningAnnotation(jsAttribute.getNameIdentifier(), JSBundle.message((String)"javascript.validation.message.unknown.metadata.annotation.used", (Object[])new Object[0]));
        }
    }

    public void visitJSNamespaceDeclaration(JSNamespaceDeclaration namespaceDeclaration) {
        PsiElement resolve;
        PsiElement initializer = namespaceDeclaration.getInitializer();
        if (!(!(initializer instanceof JSExpression) || initializer instanceof JSLiteralExpression || initializer instanceof JSReferenceExpression && ((resolve = ((JSReferenceExpression)initializer).resolve()) instanceof JSNamespaceDeclaration || resolve instanceof JSVariable && "Namespace".equals(((JSVariable)resolve).getTypeString())))) {
            JSAnnotatorProblemReporter.createErrorAnnotation((PsiElement)initializer, (String)JSBundle.message((String)"javascript.namespace.initializer.should.be.string.or.another.namespace.reference", (Object[])new Object[0]), (ProblemHighlightType)ProblemHighlightType.ERROR, (AnnotationHolder)this.myHolder);
        }
    }

    private void checkNamedObjectIsInCorrespondingFile(JSNamedElement aClass) {
        ASTNode node;
        PsiFile containingFile = aClass.getContainingFile();
        if (containingFile.getContext() != null) {
            return;
        }
        VirtualFile file = containingFile.getVirtualFile();
        if (file != null && !file.getNameWithoutExtension().equals(aClass.getName()) && ProjectRootManager.getInstance((Project)containingFile.getProject()).getFileIndex().getSourceRootForFile(file) != null && (node = aClass.findNameIdentifier()) != null) {
            String name = aClass.getName();
            String nameWithExtension = name + "." + file.getExtension();
            final String message = JSBundle.message((String)(aClass instanceof JSClass ? "javascript.validation.message.class.should.be.in.file" : (aClass instanceof JSNamespaceDeclaration ? "javascript.validation.message.namespace.should.be.in.file" : (aClass instanceof JSVariable ? "javascript.validation.message.variable.should.be.in.file" : "javascript.validation.message.function.should.be.in.file"))), (Object[])new Object[]{name, nameWithExtension});
            Annotation annotation = this.myHolder.createErrorAnnotation(node, message);
            annotation.registerFix((IntentionAction)new RenameFileFix(nameWithExtension));
            annotation.registerFix((IntentionAction)new RenameElementFix((PsiNamedElement)aClass){
                final String text;
                final String familyName;
                {
                    super(arg0);
                    String term = message.substring(0, message.indexOf(32));
                    this.text = super.getText().replace("class", StringUtil.decapitalize((String)term));
                    this.familyName = super.getFamilyName().replace("Class", term);
                }

                @NotNull
                public String getText() {
                    String string = this.text;
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/actionscript/ActionScriptAnnotatingVisitor$7", "getText"));
                    }
                    return string;
                }

                @NotNull
                public String getFamilyName() {
                    String string = this.familyName;
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/actionscript/ActionScriptAnnotatingVisitor$7", "getFamilyName"));
                    }
                    return string;
                }
            });
        }
        ActionScriptAnnotatingVisitor.checkFileUnderSourceRoot(aClass, (JSAnnotatingVisitor.ErrorReportingClient)new JSAnnotatingVisitor.SimpleErrorReportingClient((JSAnnotatingVisitor)this));
    }

    protected void validateGetPropertyReturnType(ASTNode nameIdentifier, JSFunction function, JSType type) {
        if (type instanceof JSVoidType) {
            String typeString = type != null ? type.getTypeText(JSType.TypeTextFormat.PRESENTABLE) : "empty";
            this.myHolder.createErrorAnnotation(type != null ? function.getReturnTypeElement() : nameIdentifier.getPsi(), JSBundle.message((String)"javascript.validation.message.get.method.should.be.valid.type", (Object[])new Object[]{typeString}));
        } else {
            JSFunction setter;
            PsiElement element = JSResolveUtil.findParent((PsiElement)function);
            if (element instanceof JSClass && !ActionScriptAnnotatingVisitor.isBindable((JSClass)((JSClass)element)) && (setter = ((JSClass)element).findFunctionByNameAndKind(function.getName(), JSFunction.FunctionKind.SETTER)) != null) {
                JSType setterType;
                JSParameter[] setterParameters;
                JSParameterList setterParameterList = setter.getParameterList();
                JSParameter[] jSParameterArray = setterParameters = setterParameterList != null ? setterParameterList.getParameters() : JSParameter.EMPTY_ARRAY;
                if (!(setterParameters.length != 1 || (setterType = setterParameters[0].getType()) instanceof JSAnyType || type instanceof JSAnyType || JSTypeUtils.areTypesCompatible((JSType)setterType, (JSType)type, null, (PsiElement)function))) {
                    PsiElement typeElement = function.getReturnTypeElement();
                    this.myHolder.createErrorAnnotation(typeElement != null ? typeElement : function.findNameIdentifier().getPsi(), JSBundle.message((String)"javascript.validation.message.get.method.type.is.different.from.setter", (Object[])new Object[]{setterType != null ? setterType.getTypeText(JSType.TypeTextFormat.PRESENTABLE) : "empty"}));
                }
                this.checkAccessorAccessTypeMatch(function, setter, "javascript.validation.message.get.method.access.type.is.different.from.setter");
            }
        }
    }

    protected void validateRestParameterType(JSParameter parameter) {
        PsiElement typeElement = parameter.getTypeElement();
        if (typeElement != null && !"Array".equals(typeElement.getText())) {
            Pair nodesBefore = ActionScriptAnnotatingVisitor.getNodesBefore((PsiElement)typeElement, (IElementType)JSTokenTypes.COLON);
            this.myHolder.createErrorAnnotation(typeElement, JSBundle.message((String)"javascript.validation.message.unexpected.type.for.rest.parameter", (Object[])new Object[0])).registerFix((IntentionAction)JSFixFactory.getInstance().removeASTNodeFix("javascript.fix.remove.type.reference", false, (ASTNode)nodesBefore.first, (ASTNode)nodesBefore.second));
        }
    }

    protected boolean addCreateFromUsageFixes(JSReferenceExpression node, ResolveResult[] resolveResults, List<LocalQuickFix> fixes, boolean inTypeContext, boolean ecma) {
        PsiElement nodeParent = node.getParent();
        JSExpression qualifier = node.getQualifier();
        PsiElement nameIdentifier = node.getReferenceNameElement();
        String referencedName = nameIdentifier.getText();
        inTypeContext = super.addCreateFromUsageFixes(node, resolveResults, fixes, inTypeContext, ecma);
        if (!(nodeParent instanceof JSArgumentList) && nodeParent.getParent() instanceof JSCallExpression) {
            inTypeContext = true;
        }
        if (!inTypeContext) {
            boolean getter = !(node.getParent() instanceof JSDefinitionExpression);
            String invokedName = nameIdentifier.getText();
            fixes.add((LocalQuickFix)new CreateJSPropertyAccessorIntentionAction(invokedName, getter));
        }
        if (qualifier == null) {
            boolean canHaveTypeFix = false;
            JSClass contextClass = JSResolveUtil.getClassOfContext((PsiElement)node);
            if (nodeParent instanceof JSReferenceList) {
                canHaveTypeFix = true;
                fixes.add((LocalQuickFix)new CreateClassOrInterfaceFix(node, contextClass.isInterface() || node.getParent().getNode().getElementType() == JSStubElementTypes.IMPLEMENTS_LIST, null, null));
            } else if (!(nodeParent instanceof JSDefinitionExpression) && resolveResults.length == 0) {
                canHaveTypeFix = true;
                fixes.add((LocalQuickFix)new CreateClassOrInterfaceFix(node, false, null, null));
                fixes.add((LocalQuickFix)new CreateClassOrInterfaceFix(node, true, null, null));
            }
            if (!inTypeContext && JSReadWriteAccessDetector.ourInstance.getExpressionAccess((PsiElement)node) == ReadWriteAccessDetector.Access.Read) {
                canHaveTypeFix = true;
                fixes.add((LocalQuickFix)new CreateJSFunctionIntentionAction(referencedName, true));
            }
            if (canHaveTypeFix) {
                fixes.add(new AddImportECMAScriptClassOrFunctionAction(null, (PsiPolyVariantReference)node));
            }
        } else if (ActionScriptAnnotatingVisitor.canHaveImportTo(resolveResults)) {
            fixes.add(new AddImportECMAScriptClassOrFunctionAction(null, (PsiPolyVariantReference)node));
        }
        return inTypeContext;
    }

    protected void addCreateFromUsageFixesForCall(JSCallExpression node, JSReferenceExpression referenceExpression, ResolveResult[] resolveResults, List<LocalQuickFix> quickFixes) {
        if (ActionScriptAnnotatingVisitor.canHaveImportTo(resolveResults)) {
            quickFixes.add(new AddImportECMAScriptClassOrFunctionAction(null, (PsiPolyVariantReference)referenceExpression));
        }
        super.addCreateFromUsageFixesForCall(node, referenceExpression, resolveResults, quickFixes);
    }

    private static boolean canHaveImportTo(ResolveResult[] resolveResults) {
        if (resolveResults.length == 0) {
            return true;
        }
        for (ResolveResult r : resolveResults) {
            if (!r.isValidResult()) {
                if (!(r instanceof JSResolveResult) || ((JSResolveResult)r).getResolveProblemKey() != "javascript.qualified.name.is.not.imported.message") continue;
                return true;
            }
            PsiElement element = r.getElement();
            if (element instanceof JSClass) {
                return true;
            }
            if (!(element instanceof JSFunction) || !((JSFunction)element).isConstructor()) continue;
            return true;
        }
        return false;
    }

    public void visitJSBinaryExpression(JSBinaryExpression node) {
        super.visitJSBinaryExpression(node);
        IElementType sign = node.getOperationSign();
        JSExpression lOperand = node.getLOperand();
        if (lOperand == null) {
            return;
        }
        JSExpression rOperand = node.getROperand();
        if (rOperand == null) {
            return;
        }
        if (sign == JSTokenTypes.AS_KEYWORD || sign == JSTokenTypes.IS_KEYWORD) {
            if (rOperand instanceof JSReferenceExpression) {
                PsiElement resolve;
                ResolveResult[] results = ((JSReferenceExpression)rOperand).multiResolve(false);
                if (results.length > 0 && ((resolve = results[0].getElement()) instanceof JSVariable || resolve instanceof JSFunction)) {
                    this.checkIfProperTypeReference(rOperand);
                }
            } else {
                this.checkIfProperTypeReference(rOperand);
            }
        } else if (JSTokenTypes.MULTIPLICATIVE_OPERATIONS.contains(sign) || JSTokenTypes.SHIFT_OPERATIONS.contains(sign) || sign == JSTokenTypes.MINUS) {
            JSType numberType = JSNamedType.createType((String)"Number", (JSTypeSource)JSTypeSourceFactory.createTypeSource((PsiElement)lOperand, (boolean)true), (JSContext)JSContext.INSTANCE);
            this.myTypeChecker.checkExpressionIsAssignableToType(lOperand, numberType, "javascript.expression.type.implicitly.coerced.to.unrelated.type", null);
            this.myTypeChecker.checkExpressionIsAssignableToType(rOperand, numberType, "javascript.expression.type.implicitly.coerced.to.unrelated.type", null);
        }
    }

    private void checkIfProperTypeReference(JSExpression rOperand) {
        ValidateTypesUtil.checkTypeIs((JSExpression)rOperand, (PsiElement)rOperand, (JSAnnotatorProblemReporter)this.myProblemReporter, (String)"Class", (String)"javascript.binary.operand.type.mismatch");
    }

    public void visitJSThisExpression(JSThisExpression node) {
        this.checkClassReferenceInStaticContext((JSExpression)node, "javascript.validation.message.this.referenced.from.static.context");
    }

    protected boolean processMethodExpressionResolveResult(JSCallExpression callExpression, JSReferenceExpression methodExpression, PsiElement resolveResult, JSType type) {
        JSArgumentList argumentList;
        if (callExpression instanceof JSNewExpression) {
            if (resolveResult instanceof JSFunction && ((JSFunction)resolveResult).isConstructor()) {
                resolveResult = resolveResult.getParent();
            }
            if (resolveResult instanceof JSClass && ((JSClass)resolveResult).isInterface()) {
                PsiElement referenceNameElement = methodExpression.getReferenceNameElement();
                this.reportUnresolvedFunctionError(referenceNameElement, this.getUnresolvedReferenceHighlightType(methodExpression), JSBundle.message((String)"javascript.interface.can.not.be.instantiated.message", (Object[])new Object[0]), null);
                return false;
            }
        }
        if ((argumentList = callExpression.getArgumentList()) instanceof JSE4XFilterQueryArgumentList && (type != null && !(type instanceof JSAnyType) || resolveResult instanceof JSFunction && ((JSFunction)resolveResult).isGetProperty())) {
            this.checkE4XFilterQuery(callExpression, type.getTypeText(), argumentList);
            return false;
        }
        return true;
    }

    private void checkE4XFilterQuery(JSCallExpression node, String type, JSArgumentList argumentList) {
        if (!JSResolveUtil.isAssignableType((String)"XML", (String)type, (PsiElement)argumentList) && !JSResolveUtil.isAssignableType((String)"XMLList", (String)type, (PsiElement)argumentList)) {
            this.myTypeChecker.registerProblem((PsiElement)node.getMethodExpression(), JSBundle.message((String)"javascript.invalid.e4x.filter.query.receiver", (Object[])new Object[]{type}), ProblemHighlightType.GENERIC_ERROR, new LocalQuickFix[0]);
            return;
        }
        this.myFunctionSignatureChecker.reportProblemIfNotExpectedCountOfParameters(node, 1, "one");
        JSExpression[] arguments = argumentList.getArguments();
        if (arguments.length >= 1) {
            this.myTypeChecker.checkExpressionIsAssignableToType(arguments[0], "Boolean", "javascript.argument.type.mismatch", null);
        }
    }

    @Nullable
    protected JSType getResolveResultType(JSExpression qualifier, PsiElement resultElement) {
        if (resultElement instanceof JSVariable) {
            return ((JSVariable)resultElement).getType();
        }
        return super.getResolveResultType(qualifier, resultElement);
    }

    @Nullable
    public ProblemHighlightType getUnresolvedReferenceHighlightType(@NotNull JSReferenceExpression node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/inspections/actionscript/ActionScriptAnnotatingVisitor", "getUnresolvedReferenceHighlightType"));
        }
        JSExpression qualifier = ((JSReferenceExpressionImpl)node).getResolveQualifier();
        if (qualifier != null) {
            PsiFile containingFile = node.getContainingFile();
            JSType type = null;
            boolean checkType = false;
            if (qualifier instanceof JSReferenceExpression) {
                ResolveResult[] results = ((JSReferenceExpression)qualifier).multiResolve(false);
                if (results.length != 0) {
                    PsiElement resultElement = results[0].getElement();
                    if (resultElement instanceof JSPackageWrapper) {
                        return ProblemHighlightType.ERROR;
                    }
                    type = this.getResolveResultType(qualifier, resultElement);
                    checkType = true;
                }
            } else {
                type = JSResolveUtil.getExpressionJSType((JSExpression)qualifier);
                checkType = true;
            }
            if (checkType && (type instanceof JSAnyType || type == null)) {
                return ProblemHighlightType.LIKE_UNKNOWN_SYMBOL;
            }
            JSClass jsClass = JSResolveUtil.findClassOfQualifier((JSExpression)qualifier, (PsiFile)containingFile);
            if (jsClass == null) {
                return ProblemHighlightType.ERROR;
            }
            JSAttributeList attributeList = jsClass.getAttributeList();
            if (attributeList == null || !attributeList.hasModifier(JSAttributeList.ModifierType.DYNAMIC)) {
                return ProblemHighlightType.ERROR;
            }
            String qualifiedName = jsClass.getQualifiedName();
            if ("Error".equals(qualifiedName) || "Date".equals(qualifiedName)) {
                return ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
            }
        }
        return super.getUnresolvedReferenceHighlightType(node);
    }

    private void checkClassReferenceInStaticContext(JSExpression node, @PropertyKey(resourceBundle="com.intellij.lang.javascript.JavaScriptBundle") String key) {
        JSFunction function;
        JSAttributeList attributeList;
        PsiElement element = PsiTreeUtil.getParentOfType((PsiElement)node, (Class[])new Class[]{JSExecutionScope.class, JSClass.class, JSObjectLiteralExpression.class});
        if (element instanceof JSFunction && (attributeList = (function = (JSFunction)element).getAttributeList()) != null && attributeList.hasModifier(JSAttributeList.ModifierType.STATIC)) {
            this.myHolder.createErrorAnnotation((PsiElement)node, JSBundle.message((String)key, (Object[])new Object[0]));
            return;
        }
        if (node instanceof JSSuperExpression) {
            if (element instanceof JSObjectLiteralExpression) {
                element = PsiTreeUtil.getParentOfType((PsiElement)node, (Class[])new Class[]{JSExecutionScope.class, JSClass.class});
            }
            if (element == null || !(element instanceof JSClass) && !(JSResolveUtil.findParent((PsiElement)element) instanceof JSClass)) {
                String message = JSBundle.message((String)"javascript.validation.message.super.referenced.without.class.instance.context", (Object[])new Object[0]);
                this.myHolder.createErrorAnnotation((PsiElement)node, message);
            }
        }
    }

    public void visitJSSuperExpression(JSSuperExpression node) {
        this.checkClassReferenceInStaticContext((JSExpression)node, "javascript.validation.message.super.referenced.from.static.context");
    }

    public void visitJSReturnStatement(JSReturnStatement node) {
        JSExpression returnedExpr;
        super.visitJSReturnStatement(node);
        PsiElement element = PsiTreeUtil.getParentOfType((PsiElement)node, (Class[])new Class[]{JSFunction.class, XmlTagChild.class, XmlAttributeValue.class, JSFile.class});
        if (element instanceof JSFunction && (returnedExpr = node.getExpression()) != null && ((JSFunction)element).isConstructor() && JSResolveUtil.findParent((PsiElement)element) instanceof JSClass) {
            String message = FlexBundle.message("javascript.validation.message.no.return.value.required.for.constructor", new Object[0]);
            this.myHolder.createErrorAnnotation((PsiElement)returnedExpr, message);
        }
    }

    public void visitJSForInStatement(JSForInStatement node) {
        super.visitJSForInStatement(node);
        ValidateTypesUtil.checkTypesInForIn((JSForInStatement)node, (JSAnnotatorProblemReporter)this.myProblemReporter);
    }

    private static class AddOverrideIntentionAction
    implements IntentionAction {
        private final JSFunction myNode;

        public AddOverrideIntentionAction(JSFunction node) {
            this.myNode = node;
        }

        @NotNull
        public String getText() {
            String string = JSBundle.message((String)"javascript.fix.add.override.modifier", (Object[])new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/actionscript/ActionScriptAnnotatingVisitor$AddOverrideIntentionAction", "getText"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/actionscript/ActionScriptAnnotatingVisitor$AddOverrideIntentionAction", "getFamilyName"));
            }
            return string;
        }

        public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/inspections/actionscript/ActionScriptAnnotatingVisitor$AddOverrideIntentionAction", "isAvailable"));
            }
            return this.myNode.isValid();
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/inspections/actionscript/ActionScriptAnnotatingVisitor$AddOverrideIntentionAction", "invoke"));
            }
            if (!FileModificationService.getInstance().prepareFileForWrite(file)) {
                return;
            }
            JSAttributeListWrapper w = new JSAttributeListWrapper(this.myNode.getAttributeList());
            w.overrideModifier(JSAttributeList.ModifierType.OVERRIDE, true);
            w.applyTo((JSAttributeListOwner)this.myNode);
        }

        public boolean startInWriteAction() {
            return true;
        }
    }
}

