/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.config;

import com.intellij.javaee.model.xml.ParamValue;
import com.intellij.openapi.util.TextRange;
import com.intellij.patterns.DomPatterns;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.patterns.XmlPatterns;
import com.intellij.patterns.XmlTagPattern;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.impl.source.resolve.reference.impl.manipulators.XmlTagManipulator;
import com.intellij.psi.xml.XmlTag;
import com.intellij.spring.model.utils.resources.SpringResourcesBuilder;
import com.intellij.spring.model.utils.resources.SpringResourcesUtil;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.text.StringTokenizer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SpringWebConfigLocationReferenceProvider
extends PsiReferenceProvider {
    @NonNls
    private static final String CONTEXT_PARAM = "context-param";
    @NonNls
    private static final String INIT_PARAM = "init-param";

    public static void register(PsiReferenceRegistrar registrar) {
        registrar.registerReferenceProvider((ElementPattern)((XmlTagPattern.Capture)XmlPatterns.xmlTag().withLocalName("param-value")).withParent(StandardPatterns.or((ElementPattern[])new ElementPattern[]{DomPatterns.tagWithDom((String)CONTEXT_PARAM, ParamValue.class), DomPatterns.tagWithDom((String)INIT_PARAM, ParamValue.class)})), (PsiReferenceProvider)new SpringWebConfigLocationReferenceProvider());
    }

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        TextRange[] ranges;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/web/config/SpringWebConfigLocationReferenceProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/web/config/SpringWebConfigLocationReferenceProvider", "getReferencesByElement"));
        }
        XmlTag tag = (XmlTag)element;
        XmlTag parent = tag.getParentTag();
        if (parent == null || !parent.getName().equals(CONTEXT_PARAM) && !parent.getName().equals(INIT_PARAM)) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/config/SpringWebConfigLocationReferenceProvider", "getReferencesByElement"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        XmlTag nameTag = parent.findFirstSubTag("param-name");
        if (nameTag == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/config/SpringWebConfigLocationReferenceProvider", "getReferencesByElement"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        String name = ElementManipulators.getValueText((PsiElement)nameTag);
        if (!name.equals("contextConfigLocation")) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/config/SpringWebConfigLocationReferenceProvider", "getReferencesByElement"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        if (SpringWebConfigLocationReferenceProvider.isAnnotationConfig(parent)) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/config/SpringWebConfigLocationReferenceProvider", "getReferencesByElement"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        Object[] result = PsiReference.EMPTY_ARRAY;
        for (TextRange range : ranges = XmlTagManipulator.getValueRanges((XmlTag)tag)) {
            String text = range.substring(element.getText());
            StringTokenizer tokenizer = new StringTokenizer(text, ",; \n\t");
            while (tokenizer.hasMoreTokens()) {
                String s = tokenizer.nextToken();
                int end = tokenizer.getCurrentPosition();
                int offset = end - s.length() + range.getStartOffset();
                SpringResourcesBuilder builder = SpringResourcesBuilder.create((PsiElement)element, (String)s).fromRoot(true).offset(offset).soft(false);
                Object[] references = SpringResourcesUtil.getInstance().getReferences(builder);
                result = (PsiReference[])ArrayUtil.mergeArrays((Object[])result, (Object[])references, (ArrayFactory)PsiReference.ARRAY_FACTORY);
            }
        }
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/config/SpringWebConfigLocationReferenceProvider", "getReferencesByElement"));
        }
        return result;
    }

    private static boolean isAnnotationConfig(@NotNull XmlTag contextParamTag) {
        if (contextParamTag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextParamTag", "com/intellij/spring/web/config/SpringWebConfigLocationReferenceProvider", "isAnnotationConfig"));
        }
        XmlTag parentTag = contextParamTag.getParentTag();
        if (parentTag != null) {
            if ("web-app".equals(parentTag.getName())) {
                return SpringWebConfigLocationReferenceProvider.hasAnnotationConfigDefined(parentTag.findSubTags(CONTEXT_PARAM));
            }
            if ("servlet".equals(parentTag.getName())) {
                return SpringWebConfigLocationReferenceProvider.hasAnnotationConfigDefined(parentTag.findSubTags(INIT_PARAM));
            }
        }
        return false;
    }

    private static boolean hasAnnotationConfigDefined(XmlTag[] contextParams) {
        for (XmlTag contextParam : contextParams) {
            XmlTag valueTag;
            String name;
            XmlTag nameTag = contextParam.findFirstSubTag("param-name");
            if (nameTag == null || !(name = ElementManipulators.getValueText((PsiElement)nameTag)).equals("contextClass") || (valueTag = contextParam.findFirstSubTag("param-value")) == null) continue;
            return "org.springframework.web.context.support.AnnotationConfigWebApplicationContext".equals(ElementManipulators.getValueText((PsiElement)valueTag));
        }
        return false;
    }
}

