/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.config;

import com.intellij.javaee.model.xml.ParamValue;
import com.intellij.javaee.model.xml.web.Servlet;
import com.intellij.javaee.model.xml.web.WebApp;
import com.intellij.javaee.web.WebUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.jsp.WebDirectoryElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PackageScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlElement;
import com.intellij.spring.SpringModelProvider;
import com.intellij.spring.SpringModificationTrackersManager;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.SpringFacetConfiguration;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.model.jam.SpringJamModel;
import com.intellij.spring.model.jam.stereotype.SpringConfiguration;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.web.config.AnnotationServletFileSet;
import com.intellij.spring.web.config.ServletFileSet;
import com.intellij.spring.web.config.XmlServletFileSet;
import com.intellij.spring.web.mvc.SpringMvcBundle;
import com.intellij.util.SmartList;
import com.intellij.util.text.StringTokenizer;
import com.intellij.util.xml.DomUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringWebModelProvider
implements SpringModelProvider {
    @NonNls
    private static final String APPLICATION_CONTEXT_FILESET = "web application context";
    @NonNls
    private static final String SERVLET_CONTEXT_POSTFIX = " servlet context";

    @NotNull
    public List<SpringFileSet> getFilesets(final @NotNull SpringFacet springFacet) {
        if (springFacet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "springFacet", "com/intellij/spring/web/config/SpringWebModelProvider", "getFilesets"));
        }
        final Module module = springFacet.getModule();
        if (WebFacet.getInstances((Module)module).isEmpty()) {
            List<SpringFileSet> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/config/SpringWebModelProvider", "getFilesets"));
            }
            return list;
        }
        final Project project = module.getProject();
        if (DumbService.isDumb((Project)project)) {
            List<SpringFileSet> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/config/SpringWebModelProvider", "getFilesets"));
            }
            return list;
        }
        List list = (List)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)springFacet, (CachedValueProvider)new CachedValueProvider<List<SpringFileSet>>(){

            @Nullable
            public CachedValueProvider.Result<List<SpringFileSet>> compute() {
                boolean springMVCFound = SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.web.servlet.DispatcherServlet") != null;
                List fileSets = springMVCFound ? SpringWebModelProvider.getWebFileSets(WebFacet.getInstances((Module)module), springFacet) : Collections.emptyList();
                return CachedValueProvider.Result.create((Object)fileSets, (Object[])new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT, ProjectRootManager.getInstance((Project)project), SpringModificationTrackersManager.getInstance((Project)project).getProfilesModificationTracker(), SpringModificationTrackersManager.getInstance((Project)project).getMultipleContextsModificationTracker(), springFacet.getConfiguration()});
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/config/SpringWebModelProvider", "getFilesets"));
        }
        return list;
    }

    private static List<SpringFileSet> getWebFileSets(Collection<WebFacet> webFacets, SpringFacet springFacet) {
        ArrayList<SpringFileSet> result = new ArrayList<SpringFileSet>(webFacets.size());
        for (WebFacet webFacet : webFacets) {
            List<ServletFileSet> servletSets = SpringWebModelProvider.getServletSets(webFacet, springFacet);
            if (servletSets.isEmpty()) continue;
            WebApp webApp = webFacet.getRoot();
            assert (webApp != null);
            VirtualFile webInf = SpringWebModelProvider.getWebInf(webFacet);
            assert (webInf != null);
            ServletFileSet appContext = null;
            String filesetName = SpringMvcBundle.message("mvc.application.context.autodetected", new Object[0]);
            ParamValue param = (ParamValue)DomUtil.findByName((Collection)webApp.getContextParams(), (String)"contextConfigLocation");
            if (param != null) {
                boolean isAnnotationConfig = SpringWebModelProvider.isAnnotationConfig(webApp.getContextParams());
                appContext = SpringWebModelProvider.createFileSet(webInf.getParent(), param, APPLICATION_CONTEXT_FILESET, filesetName, springFacet, null, isAnnotationConfig);
            } else {
                VirtualFile file = webInf.findChild("applicationContext.xml");
                if (file != null) {
                    appContext = SpringWebModelProvider.createServletFileSet(APPLICATION_CONTEXT_FILESET, filesetName, springFacet, null, false);
                    appContext.addFile(file);
                }
            }
            if (appContext != null) {
                result.add((SpringFileSet)appContext);
                for (SpringFileSet springFileSet : servletSets) {
                    springFileSet.addDependency((SpringFileSet)appContext);
                }
            }
            result.addAll(servletSets);
        }
        return result;
    }

    private static boolean isAnnotationConfig(List<? extends ParamValue> paramValues) {
        ParamValue param = (ParamValue)DomUtil.findByName(paramValues, (String)"contextClass");
        if (param != null) {
            return "org.springframework.web.context.support.AnnotationConfigWebApplicationContext".equals(param.getParamValue().getStringValue());
        }
        return false;
    }

    @Nullable
    private static VirtualFile getWebInf(WebFacet facet) {
        WebDirectoryElement webInf = WebUtil.getWebUtil().findWebDirectoryElement("/WEB-INF/", facet);
        return webInf == null ? null : webInf.getVirtualFile();
    }

    @NotNull
    public static List<ServletFileSet> getServletSets(WebFacet facet, @NotNull SpringFacet springFacet) {
        if (springFacet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "springFacet", "com/intellij/spring/web/config/SpringWebModelProvider", "getServletSets"));
        }
        WebApp app = facet.getRoot();
        if (app == null) {
            List<ServletFileSet> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/config/SpringWebModelProvider", "getServletSets"));
            }
            return list;
        }
        VirtualFile webInf = SpringWebModelProvider.getWebInf(facet);
        if (webInf == null) {
            List<ServletFileSet> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/config/SpringWebModelProvider", "getServletSets"));
            }
            return list;
        }
        VirtualFile root = webInf.getParent();
        SmartList result = new SmartList();
        for (Servlet servlet : app.getServlets()) {
            ServletFileSet springFileSet;
            String servletClass = servlet.getServletClass().getStringValue();
            String servletName = (String)servlet.getServletName().getValue();
            if (servletClass == null || servletName == null || !InheritanceUtil.isInheritor((PsiClass)((PsiClass)servlet.getServletClass().getValue()), (String)"org.springframework.web.servlet.DispatcherServlet")) continue;
            ParamValue param = (ParamValue)DomUtil.findByName((Collection)servlet.getInitParams(), (String)"contextConfigLocation");
            String id = "web " + servletName + SERVLET_CONTEXT_POSTFIX;
            String name = SpringMvcBundle.message("mvc.servlet.context.autodetected", servletName);
            if (param != null) {
                springFileSet = SpringWebModelProvider.createFileSet(root, param, id, name, springFacet, servlet, SpringWebModelProvider.isAnnotationConfig(servlet.getInitParams()));
            } else {
                springFileSet = SpringWebModelProvider.createServletFileSet(id, name, springFacet, servlet, false);
                springFileSet.addFile(webInf.getUrl() + "/" + SpringWebModelProvider.getServletContextFileName(servletName));
            }
            result.add(springFileSet);
        }
        SmartList smartList = result;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/config/SpringWebModelProvider", "getServletSets"));
        }
        return smartList;
    }

    @NotNull
    private static ServletFileSet createFileSet(VirtualFile root, ParamValue param, String id, String name, @NotNull SpringFacet springFacet, @Nullable Servlet servlet, boolean isAnnotationConfig) {
        if (springFacet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "springFacet", "com/intellij/spring/web/config/SpringWebModelProvider", "createFileSet"));
        }
        ServletFileSet fileSet = SpringWebModelProvider.createServletFileSet(id, name, springFacet, servlet, isAnnotationConfig);
        if (isAnnotationConfig) {
            String paramValue = param.getParamValue().getStringValue();
            if (StringUtil.isEmptyOrSpaces((String)paramValue)) {
                ServletFileSet servletFileSet = fileSet;
                if (servletFileSet == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/config/SpringWebModelProvider", "createFileSet"));
                }
                return servletFileSet;
            }
            Module module = springFacet.getModule();
            JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)module.getProject());
            GlobalSearchScope moduleScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module, (boolean)false);
            StringTokenizer tokenizer = new StringTokenizer(paramValue, " ,;");
            while (tokenizer.hasMoreElements()) {
                String configText = tokenizer.nextElement().trim();
                if (StringUtil.isEmptyOrSpaces((String)configText)) continue;
                PsiPackage psiPackage = javaPsiFacade.findPackage(configText);
                if (psiPackage != null) {
                    GlobalSearchScope searchScope = moduleScope.intersectWith(PackageScope.packageScope((PsiPackage)psiPackage, (boolean)true));
                    List springConfigurations = SpringJamModel.getModel((Module)module).getConfigurations(searchScope);
                    for (SpringConfiguration springConfiguration : springConfigurations) {
                        SpringWebModelProvider.addInFileset(fileSet, springConfiguration.getContainingFile());
                    }
                    ((AnnotationServletFileSet)fileSet).addComponentScanPackage(psiPackage.getQualifiedName());
                    continue;
                }
                PsiClass psiClass = javaPsiFacade.findClass(configText, moduleScope);
                if (psiClass == null) continue;
                SpringWebModelProvider.addInFileset(fileSet, psiClass.getContainingFile());
            }
        } else {
            XmlElement tag = param.getParamValue().getXmlElement();
            if (tag != null) {
                PsiReference[] references;
                for (PsiReference reference : references = tag.getReferences()) {
                    if (!(reference instanceof FileReference) || !((FileReference)reference).isLast()) continue;
                    ResolveResult[] results = ((FileReference)reference).multiResolve(false);
                    boolean resolved = false;
                    for (ResolveResult resolveResult : results) {
                        VirtualFile virtualFile;
                        PsiElement element = resolveResult.getElement();
                        if (!(element instanceof PsiFileSystemItem) || ((PsiFileSystemItem)element).isDirectory() || (virtualFile = ((PsiFileSystemItem)element).getVirtualFile()) == null) continue;
                        fileSet.addFile(virtualFile);
                        resolved = true;
                    }
                    if (resolved) continue;
                    fileSet.addFile(root.getUrl() + "/" + ((FileReference)reference).getText());
                }
            }
        }
        ServletFileSet servletFileSet = fileSet;
        if (servletFileSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/config/SpringWebModelProvider", "createFileSet"));
        }
        return servletFileSet;
    }

    private static void addInFileset(ServletFileSet fileSet, @Nullable PsiFile containingFile) {
        VirtualFile file;
        if (containingFile != null && (file = containingFile.getVirtualFile()) != null) {
            fileSet.addFile(file);
        }
    }

    @NonNls
    static String getServletContextFileName(String servletName) {
        return servletName + "-servlet.xml";
    }

    private static ServletFileSet createServletFileSet(@NonNls String id, String name, @NotNull SpringFacet springFacet, @Nullable Servlet servlet, boolean isAnnotated) {
        if (springFacet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "springFacet", "com/intellij/spring/web/config/SpringWebModelProvider", "createServletFileSet"));
        }
        ServletFileSet set = isAnnotated ? new AnnotationServletFileSet(id, name, servlet, springFacet) : new XmlServletFileSet(id, name, servlet, springFacet);
        SpringFacetConfiguration configuration = (SpringFacetConfiguration)springFacet.getConfiguration();
        configuration.registerAutodetectedFileSet((SpringFileSet)set);
        return set;
    }
}

