/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc.jam;

import com.intellij.jam.JamService;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.spring.web.mvc.jam.SpringMVCModelAttribute;
import com.intellij.spring.web.mvc.jam.SpringMVCRequestMapping;
import com.intellij.util.SmartList;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringMVCJamModel {
    private static final TObjectHashingStrategy<SpringMVCModelAttribute> HASHING_STRATEGY = new TObjectHashingStrategy<SpringMVCModelAttribute>(){

        public int computeHashCode(SpringMVCModelAttribute object) {
            String name = object.getName();
            return name == null ? 0 : name.hashCode();
        }

        public boolean equals(SpringMVCModelAttribute o1, SpringMVCModelAttribute o2) {
            return Comparing.equal((String)o1.getName(), (String)o2.getName()) && Comparing.equal((Object)o1.getType(), (Object)o2.getType());
        }
    };
    private final Module myModule;
    private final JamService jamService;
    private static final Key<CachedValue<List<SpringMVCRequestMapping>>> INCLUDE_CLASSES = Key.create((String)"INCLUDE_CLASSES");
    private static final Key<CachedValue<List<SpringMVCRequestMapping>>> WITHOUT_CLASSES = Key.create((String)"WITHOUT_CLASSES");

    public static SpringMVCJamModel getModel(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/web/mvc/jam/SpringMVCJamModel", "getModel"));
        }
        return (SpringMVCJamModel)ModuleServiceManager.getService((Module)module, SpringMVCJamModel.class);
    }

    public SpringMVCJamModel(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/web/mvc/jam/SpringMVCJamModel", "<init>"));
        }
        this.myModule = module;
        this.jamService = JamService.getJamService((Project)module.getProject());
    }

    public List<SpringMVCRequestMapping> getRequestMappings(final boolean includeClasses) {
        Key<CachedValue<List<SpringMVCRequestMapping>>> key = includeClasses ? INCLUDE_CLASSES : WITHOUT_CLASSES;
        return (List)CachedValuesManager.getManager((Project)this.myModule.getProject()).getCachedValue((UserDataHolder)this.myModule, key, (CachedValueProvider)new CachedValueProvider<List<SpringMVCRequestMapping>>(){

            @Nullable
            public CachedValueProvider.Result<List<SpringMVCRequestMapping>> compute() {
                GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)SpringMVCJamModel.this.myModule);
                SmartList result = new SmartList();
                if (includeClasses) {
                    result.addAll(SpringMVCJamModel.this.jamService.getJamClassElements(SpringMVCRequestMapping.ClassMapping.META, "org.springframework.web.bind.annotation.RequestMapping", scope));
                }
                result.addAll(SpringMVCJamModel.this.jamService.getJamMethodElements(SpringMVCRequestMapping.MethodMapping.META, "org.springframework.web.bind.annotation.RequestMapping", scope));
                return CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
            }
        }, false);
    }

    public Collection<SpringMVCModelAttribute> getModelAttributes() {
        List<SpringMVCRequestMapping> list = this.getRequestMappings(true);
        THashSet attributes = new THashSet(HASHING_STRATEGY);
        for (SpringMVCRequestMapping mapping : list) {
            attributes.addAll(mapping.getModelAttributes());
        }
        return attributes;
    }
}

