/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc.model;

import com.intellij.javaee.model.xml.web.Servlet;
import com.intellij.javaee.web.CommonServletMapping;
import com.intellij.javaee.web.ServletMappingInfo;
import com.intellij.javaee.web.WebUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringManager;
import com.intellij.spring.SpringModificationTrackersManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.jam.JamSpringBeanPointer;
import com.intellij.spring.model.jam.stereotype.SpringController;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.web.config.ServletFileSet;
import com.intellij.spring.web.config.SpringWebModelProvider;
import com.intellij.spring.web.mvc.SpringControllerClassInfo;
import com.intellij.spring.web.mvc.jam.RequestMethod;
import com.intellij.spring.web.mvc.model.SpringMVCRequestMappings;
import com.intellij.spring.web.mvc.model.SpringMVCRequestMappingsCollector;
import com.intellij.spring.web.mvc.views.ViewResolver;
import com.intellij.spring.web.mvc.views.ViewResolverFactory;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.xml.util.PsiElementPointer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringMVCModel {
    private static final Key<CachedValue<SpringMVCModel>> KEY = Key.create((String)"spring mvc model");
    private static final Function<SpringMVCRequestMappings.PatternMapping, Variant> MAPPING = new Function<SpringMVCRequestMappings.PatternMapping, Variant>(){

        public Variant fun(SpringMVCRequestMappings.PatternMapping patternMapping) {
            String s = patternMapping.getUrl();
            int i = s.indexOf(42);
            if (i >= 0) {
                s = s.substring(0, i);
            }
            return new Variant(patternMapping.getMapping(), s, true, patternMapping.getOriginalUrl());
        }
    };
    private final WebFacet myWebFacet;
    private final SpringFacet mySpringFacet;
    private final NotNullLazyValue<Collection<SpringModel>> myModels;
    private boolean myHasUnknownResolvers;
    private final NotNullLazyValue<List<ViewResolver>> myResolvers;
    private final NotNullLazyValue<SpringMVCRequestMappings> myRequestMappings;

    @Nullable
    public static SpringMVCModel getModel(final @NotNull WebFacet facet, final @NotNull SpringFacet springFacet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/intellij/spring/web/mvc/model/SpringMVCModel", "getModel"));
        }
        if (springFacet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "springFacet", "com/intellij/spring/web/mvc/model/SpringMVCModel", "getModel"));
        }
        final Project project = facet.getModule().getProject();
        return (SpringMVCModel)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)facet, KEY, (CachedValueProvider)new CachedValueProvider<SpringMVCModel>(){

            public CachedValueProvider.Result<SpringMVCModel> compute() {
                return CachedValueProvider.Result.create((Object)new SpringMVCModel(facet, springFacet), (Object[])new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT, ProjectRootManager.getInstance((Project)project), SpringModificationTrackersManager.getInstance((Project)project).getProfilesModificationTracker(), SpringModificationTrackersManager.getInstance((Project)project).getMultipleContextsModificationTracker(), springFacet.getConfiguration()});
            }
        }, false);
    }

    @Nullable
    public static SpringMVCModel getModel(PsiElement element) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (module == null) {
            return null;
        }
        SpringFacet springFacet = SpringFacet.getInstance((Module)module);
        if (springFacet == null) {
            return null;
        }
        WebFacet webFacet = WebUtil.getWebFacet((PsiElement)element);
        return webFacet == null ? null : SpringMVCModel.getModel(webFacet, springFacet);
    }

    private SpringMVCModel(@NotNull WebFacet facet, @NotNull SpringFacet springFacet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/intellij/spring/web/mvc/model/SpringMVCModel", "<init>"));
        }
        if (springFacet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "springFacet", "com/intellij/spring/web/mvc/model/SpringMVCModel", "<init>"));
        }
        this.myModels = new NotNullLazyValue<Collection<SpringModel>>(){

            @NotNull
            protected Collection<SpringModel> compute() {
                List<ServletFileSet> fileSets = SpringWebModelProvider.getServletSets(SpringMVCModel.this.myWebFacet, SpringMVCModel.this.mySpringFacet);
                List list = ContainerUtil.mapNotNull(fileSets, (Function)new NullableFunction<SpringFileSet, SpringModel>(){

                    public SpringModel fun(SpringFileSet springFileSet) {
                        Module module = SpringMVCModel.this.myWebFacet.getModule();
                        Set allModels = SpringManager.getInstance((Project)module.getProject()).getAllModels(module);
                        for (SpringModel model : allModels) {
                            if (!springFileSet.equals((Object)model.getFileSet())) continue;
                            return model;
                        }
                        return null;
                    }
                });
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/model/SpringMVCModel$3", "compute"));
                }
                return list;
            }
        };
        this.myResolvers = new NotNullLazyValue<List<ViewResolver>>(){

            @NotNull
            protected List<ViewResolver> compute() {
                Module module = SpringMVCModel.this.myWebFacet.getModule();
                PsiClass viewResolver = SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.web.servlet.ViewResolver");
                if (viewResolver == null) {
                    List<ViewResolver> list = Collections.emptyList();
                    if (list == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/model/SpringMVCModel$4", "compute"));
                    }
                    return list;
                }
                SpringModelSearchParameters.BeanClass searchParameters = SpringModelSearchParameters.byClass((PsiClass)viewResolver).withInheritors(GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module));
                SmartList resolvers = new SmartList();
                SpringMVCModel.this.myHasUnknownResolvers = false;
                for (SpringModel model : SpringMVCModel.this.getServletModels()) {
                    List pointers = SpringModelSearchers.findBeans((CommonSpringModel)model, (SpringModelSearchParameters.BeanClass)searchParameters);
                    block1: for (SpringBeanPointer pointer : pointers) {
                        CommonSpringBean springBean = pointer.getSpringBean();
                        PsiClass beanClass = springBean.getBeanClass();
                        for (ViewResolverFactory factory : ViewResolverFactory.getAllFactories()) {
                            Set<ViewResolver> factoryResolvers = factory.createResolvers(springBean, beanClass, model);
                            if (factoryResolvers.size() <= 0) continue;
                            resolvers.addAll(factoryResolvers);
                            continue block1;
                        }
                        SpringMVCModel.this.myHasUnknownResolvers = true;
                    }
                }
                SmartList smartList = resolvers;
                if (smartList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/model/SpringMVCModel$4", "compute"));
                }
                return smartList;
            }
        };
        this.myRequestMappings = new NotNullLazyValue<SpringMVCRequestMappings>(){

            @NotNull
            protected SpringMVCRequestMappings compute() {
                Collection<SpringModel> models = SpringMVCModel.this.getServletModels();
                SpringMVCRequestMappingsCollector collector = new SpringMVCRequestMappingsCollector(SpringMVCModel.this.myWebFacet.getModule(), models);
                SpringMVCRequestMappings springMVCRequestMappings = collector.collect();
                if (springMVCRequestMappings == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/model/SpringMVCModel$5", "compute"));
                }
                return springMVCRequestMappings;
            }
        };
        this.myWebFacet = facet;
        this.mySpringFacet = springFacet;
    }

    @NotNull
    public WebFacet getWebFacet() {
        WebFacet webFacet = this.myWebFacet;
        if (webFacet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/model/SpringMVCModel", "getWebFacet"));
        }
        return webFacet;
    }

    public List<Variant> getAllUrls() {
        SpringMVCRequestMappings requestMappings = (SpringMVCRequestMappings)this.myRequestMappings.getValue();
        ArrayList<Variant> variants = new ArrayList<Variant>();
        MultiMap<String, SpringMVCRequestMappings.Mapping> urls = requestMappings.getUrls();
        for (Map.Entry entry : urls.entrySet()) {
            for (SpringMVCRequestMappings.Mapping mapping : (Collection)entry.getValue()) {
                variants.add(new Variant(mapping, (String)entry.getKey(), false, (String)entry.getKey()));
            }
        }
        variants.addAll(ContainerUtil.map(requestMappings.getPatterns(), MAPPING));
        return variants;
    }

    public Collection<SpringModel> getAllModels() {
        return (Collection)this.myModels.getValue();
    }

    public Collection<SpringModel> getServletModels() {
        Collection models = (Collection)this.myModels.getValue();
        return ContainerUtil.mapNotNull((Collection)models, (Function)new NullableFunction<SpringModel, SpringModel>(){

            public SpringModel fun(SpringModel springModel) {
                return SpringMVCModel.getServlet(springModel) == null ? null : springModel;
            }
        });
    }

    @Nullable
    public ServletMappingInfo getServletMappingInfo() {
        Collection models = (Collection)this.myModels.getValue();
        for (SpringModel model : models) {
            Servlet servlet = SpringMVCModel.getServlet(model);
            if (servlet == null) continue;
            List mappings = this.myWebFacet.getWebModel().getServletMappings();
            for (CommonServletMapping mapping : mappings) {
                List mappingInfos;
                if (mapping.getServlet() != servlet || (mappingInfos = ServletMappingInfo.createMappingInfos((CommonServletMapping)mapping)).isEmpty()) continue;
                return (ServletMappingInfo)mappingInfos.get(0);
            }
        }
        return null;
    }

    public boolean processVariables(PsiElement element, Processor<PsiVariable> processor) {
        PsiFile psiFile = element.getContainingFile().getOriginalFile();
        List<ViewResolver> resolvers = this.getViewResolvers();
        for (SpringBeanPointer pointer : this.getControllers()) {
            PsiClass beanClass = pointer.getBeanClass();
            if (beanClass == null || beanClass instanceof PsiCompiledElement) continue;
            SpringControllerClassInfo info = SpringControllerClassInfo.getInfo(beanClass);
            MultiMap<String, PsiVariable> controllerVariables = info.getVariables();
            for (String view : controllerVariables.keySet()) {
                for (ViewResolver resolver : resolvers) {
                    Collection variables;
                    PsiElement resolvedView = resolver.resolveFinalView(view, this);
                    if (!psiFile.equals(resolvedView) || ContainerUtil.process((Iterable)(variables = controllerVariables.get((Object)view)), processor)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Nullable
    private static Servlet getServlet(SpringModel model) {
        ServletFileSet fileSet = (ServletFileSet)model.getFileSet();
        assert (fileSet != null);
        return fileSet.getServlet();
    }

    @Nullable
    public Collection<PsiElement> resolveUrl(String url, @NotNull ServletMappingInfo info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/spring/web/mvc/model/SpringMVCModel", "resolveUrl"));
        }
        return ((SpringMVCRequestMappings)this.myRequestMappings.getValue()).resolve(url, info);
    }

    public List<ViewResolver> getViewResolvers() {
        return (List)this.myResolvers.getValue();
    }

    public boolean hasUnknownResolvers() {
        this.myResolvers.getValue();
        return this.myHasUnknownResolvers;
    }

    public List<SpringBeanPointer> getControllers() {
        PsiClass servletMvcController = SpringCommonUtils.findLibraryClass((Module)this.myWebFacet.getModule(), (String)"org.springframework.web.servlet.mvc.Controller");
        SpringModelSearchParameters.BeanClass searchParameters = servletMvcController == null ? null : SpringModelSearchParameters.byClass((PsiClass)servletMvcController).withInheritors();
        ArrayList<SpringBeanPointer> pointers = new ArrayList<SpringBeanPointer>();
        for (SpringModel springModel : this.getAllModels()) {
            if (searchParameters != null) {
                pointers.addAll(SpringModelSearchers.findBeans((CommonSpringModel)springModel, (SpringModelSearchParameters.BeanClass)searchParameters));
            }
            for (SpringBeanPointer pointer : springModel.getAllCommonBeans()) {
                CommonSpringBean bean;
                if (!(pointer instanceof JamSpringBeanPointer) || !((bean = pointer.getSpringBean()) instanceof SpringController)) continue;
                pointers.add(pointer);
            }
        }
        return pointers;
    }

    public static class Variant {
        public final PsiElementPointer psiElementPointer;
        public final String lookupString;
        public final boolean isPattern;
        public final String presentation;
        public final RequestMethod[] method;

        public Variant(SpringMVCRequestMappings.Mapping mapping, String lookupString, boolean pattern, String presentation) {
            this.psiElementPointer = mapping.pointer;
            this.lookupString = lookupString;
            this.isPattern = pattern;
            this.presentation = presentation;
            this.method = mapping.method;
        }

        public String toString() {
            return this.lookupString + " (" + this.presentation + ")";
        }
    }
}

