/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc.toolWindow;

import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.spring.SpringPresentationProvider;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.jam.JamSpringBeanPointer;
import com.intellij.spring.web.mvc.jam.SpringMVCRequestMapping;
import com.intellij.spring.web.mvc.toolWindow.SpringMvcRequestMappingsPanel;
import com.intellij.spring.web.mvc.toolWindow.SpringMvcViewUtils;
import com.intellij.ui.FinderRecursivePanel;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringMvcControllerPanel
extends FinderRecursivePanel<SpringBeanPointer> {
    private final Module[] myModules;
    private static final Function<String, String> URL_TEXT = new Function<String, String>(){

        public String fun(String s) {
            if (StringUtil.endsWithChar((CharSequence)s, (char)'/')) {
                return s + "*";
            }
            return s + "/*";
        }
    };

    public SpringMvcControllerPanel(Project project) {
        super(project, "SpringMvcController");
        this.myModules = ModuleManager.getInstance((Project)project).getModules();
    }

    public SpringMvcControllerPanel(FinderRecursivePanel<Module> parent, @NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/web/mvc/toolWindow/SpringMvcControllerPanel", "<init>"));
        }
        super(parent);
        this.myModules = new Module[]{module};
    }

    @NotNull
    protected List<SpringBeanPointer> getListItems() {
        CommonProcessors.CollectUniquesProcessor processor = new CommonProcessors.CollectUniquesProcessor();
        for (Module module : this.myModules) {
            SpringMvcViewUtils.processControllers(module, (Processor<SpringBeanPointer>)processor);
        }
        ArrayList<SpringBeanPointer> pointers = new ArrayList<SpringBeanPointer>(processor.getResults());
        Collections.sort(pointers, new Comparator<SpringBeanPointer>(){

            @Override
            public int compare(SpringBeanPointer o1, SpringBeanPointer o2) {
                return SpringMvcControllerPanel.this.getItemText(o1).compareTo(SpringMvcControllerPanel.this.getItemText(o2));
            }
        });
        ArrayList<SpringBeanPointer> arrayList = pointers;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/toolWindow/SpringMvcControllerPanel", "getListItems"));
        }
        return arrayList;
    }

    @NotNull
    protected String getItemText(SpringBeanPointer springBeanPointer) {
        String string = springBeanPointer.isValid() ? SpringPresentationProvider.getSpringBeanName((SpringBeanPointer)springBeanPointer) : "<invalid>";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/toolWindow/SpringMvcControllerPanel", "getItemText"));
        }
        return string;
    }

    @Nullable
    protected Icon getItemIcon(SpringBeanPointer springBeanPointer) {
        return springBeanPointer.isValid() ? SpringPresentationProvider.getSpringIcon((Object)springBeanPointer) : null;
    }

    protected boolean hasChildren(SpringBeanPointer springBeanPointer) {
        return true;
    }

    @Nullable
    protected VirtualFile getContainingFile(SpringBeanPointer springBeanPointer) {
        return springBeanPointer.isValid() ? springBeanPointer.getContainingFile().getVirtualFile() : null;
    }

    protected boolean performEditAction() {
        SpringBeanPointer springBeanPointer = (SpringBeanPointer)this.getSelectedValue();
        if (springBeanPointer == null) {
            return true;
        }
        PsiElement navigationElement = springBeanPointer.getPsiElement();
        if (navigationElement != null) {
            NavigationUtil.activateFileWithPsiElement((PsiElement)navigationElement);
        }
        return true;
    }

    protected void doCustomizeCellRenderer(SimpleColoredComponent comp, JList list, SpringBeanPointer value, int index, boolean selected, boolean hasFocus) {
        if (!value.isValid()) {
            return;
        }
        comp.clear();
        comp.setIcon(this.getItemIcon(value));
        if (value instanceof JamSpringBeanPointer) {
            this.renderController(comp, value);
        } else {
            comp.append(this.getItemText(value));
            comp.append(" (" + value.getContainingFile().getName() + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
    }

    private void renderController(SimpleColoredComponent comp, SpringBeanPointer springBeanPointer) {
        PsiClass controllerClass = springBeanPointer.getSpringBean().getBeanClass();
        if (controllerClass != null) {
            SpringMVCRequestMapping.ClassMapping classMapping = (SpringMVCRequestMapping.ClassMapping)SpringMVCRequestMapping.ClassMapping.META.getJamElement((PsiModifierListOwner)controllerClass);
            if (classMapping != null) {
                comp.append(StringUtil.join(classMapping.getUrls(), URL_TEXT, (String)", "), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            } else {
                comp.append(this.getItemText(springBeanPointer));
            }
            String packageName = controllerClass.getQualifiedName();
            comp.append(" (" + packageName + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
    }

    @Nullable
    protected JComponent createRightComponent(SpringBeanPointer springBeanPointer) {
        return new SpringMvcRequestMappingsPanel(this, springBeanPointer);
    }
}

