/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc.toolWindow;

import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.ProjectScope;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.jam.JamSpringBeanPointer;
import com.intellij.spring.model.pom.SpringBeanPomTargetUtils;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.spring.web.mvc.jam.RequestMethod;
import com.intellij.spring.web.mvc.model.SpringMVCModel;
import com.intellij.util.Processor;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

class SpringMvcViewUtils {
    SpringMvcViewUtils() {
    }

    static boolean isViewAvailable(Project project) {
        return JavaPsiFacade.getInstance((Project)project).findClass("org.springframework.web.servlet.DispatcherServlet", ProjectScope.getLibrariesScope((Project)project)) != null;
    }

    static boolean processControllers(Module module, Processor<SpringBeanPointer> processor) {
        for (WebFacet webFacet : WebFacet.getInstances((Module)module)) {
            SpringMVCModel springMVCModel;
            SpringFacet springFacet = SpringFacet.getInstance((Module)module);
            if (springFacet == null || (springMVCModel = SpringMVCModel.getModel(webFacet, springFacet)) == null) continue;
            for (SpringBeanPointer pointer : springMVCModel.getControllers()) {
                if (processor.process((Object)pointer)) continue;
                return false;
            }
        }
        return true;
    }

    static boolean processUrls(Module module, @Nullable SpringBeanPointer controllerSpringBeanPointer, Set<RequestMethod> requestMethods, Processor<SpringMVCModel.Variant> processor) {
        boolean foundMatch = false;
        for (WebFacet webFacet : WebFacet.getInstances((Module)module)) {
            SpringFacet springFacet = SpringFacet.getInstance((Module)module);
            assert (springFacet != null);
            SpringMVCModel model = SpringMVCModel.getModel(webFacet, springFacet);
            if (model == null) continue;
            for (SpringMVCModel.Variant variant : model.getAllUrls()) {
                if (!SpringMvcViewUtils.matchesSelectedController(controllerSpringBeanPointer, variant) || !SpringMvcViewUtils.matchesRequestMethod(requestMethods, variant)) continue;
                foundMatch = true;
                if (processor.process((Object)variant)) continue;
                return false;
            }
        }
        return !foundMatch;
    }

    private static boolean matchesSelectedController(@Nullable SpringBeanPointer controllerSpringBeanPointer, SpringMVCModel.Variant variant) {
        if (controllerSpringBeanPointer == null) {
            return true;
        }
        PsiElement variantElement = variant.psiElementPointer.getPsiElement();
        if (variantElement != null && controllerSpringBeanPointer instanceof JamSpringBeanPointer && variantElement.getContainingFile().equals(controllerSpringBeanPointer.getContainingFile())) {
            return true;
        }
        CommonSpringBean targetBean = SpringBeanPomTargetUtils.getSpringBean((PsiElement)variantElement);
        return targetBean instanceof DomSpringBean && Comparing.equal((Object)targetBean, (Object)controllerSpringBeanPointer.getSpringBean());
    }

    private static boolean matchesRequestMethod(Set<RequestMethod> requestMethods, SpringMVCModel.Variant variant) {
        if (variant.method.length == 0) {
            return true;
        }
        for (RequestMethod method : variant.method) {
            if (!requestMethods.contains((Object)method)) continue;
            return true;
        }
        return false;
    }
}

