/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc.views;

import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.beans.SpringPropertyDefinition;
import com.intellij.spring.web.mvc.views.UrlBasedViewResolver;
import com.intellij.spring.web.mvc.views.ViewResolver;
import com.intellij.spring.web.mvc.views.ViewResolverFactory;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class TemplateViewResolverFactory
extends ViewResolverFactory {
    private final String myBeanClass;
    private final String myConfigurerClass;
    private final String myLoaderProperty;

    TemplateViewResolverFactory(String beanClass, String configurerClass, String loaderProperty) {
        this.myBeanClass = beanClass;
        this.myConfigurerClass = configurerClass;
        this.myLoaderProperty = loaderProperty;
    }

    @Override
    public String getBeanClass() {
        return this.myBeanClass;
    }

    @Override
    public Set<ViewResolver> doCreate(CommonSpringBean bean, SpringModel model) {
        Module module;
        UrlBasedViewResolver resolver = new UrlBasedViewResolver(bean);
        Module module2 = module = model.getModule() != null ? model.getModule() : bean.getModule();
        if (module == null) {
            return Collections.emptySet();
        }
        PsiClass configurerClass = SpringCommonUtils.findLibraryClass((Module)module, (String)this.myConfigurerClass);
        if (configurerClass == null) {
            return Collections.singleton(resolver);
        }
        GlobalSearchScope inheritorsSearchScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
        SpringModelSearchParameters.BeanClass searchParameters = SpringModelSearchParameters.byClass((PsiClass)configurerClass).withInheritors(inheritorsSearchScope).effectiveBeanTypes();
        List configurers = SpringModelSearchers.findBeans((CommonSpringModel)model, (SpringModelSearchParameters.BeanClass)searchParameters);
        if (configurers.isEmpty()) {
            return Collections.singleton(resolver);
        }
        CommonSpringBean configurer = ((SpringBeanPointer)configurers.get(0)).getSpringBean();
        if (configurer instanceof SpringBean) {
            String value;
            SpringPropertyDefinition property = ((SpringBean)configurer).getProperty(this.myLoaderProperty);
            if (property != null && (value = property.getValueAsString()) != null) {
                return Collections.singleton(new UrlBasedViewResolver(value + resolver.myPrefix, resolver.mySuffix));
            }
        } else {
            return Collections.singleton(this.handleCustomConfigurer(configurer, resolver));
        }
        return Collections.singleton(resolver);
    }

    @NotNull
    protected ViewResolver handleCustomConfigurer(CommonSpringBean configurer, UrlBasedViewResolver resolver) {
        UrlBasedViewResolver urlBasedViewResolver = resolver;
        if (urlBasedViewResolver == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/views/TemplateViewResolverFactory", "handleCustomConfigurer"));
        }
        return urlBasedViewResolver;
    }
}

