/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc.views;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.javaee.web.WebUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.jsp.WebDirectoryElement;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.utils.SpringPropertyUtils;
import com.intellij.spring.web.mvc.model.SpringMVCModel;
import com.intellij.spring.web.mvc.views.ViewResolver;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UrlBasedViewResolver
extends ViewResolver {
    @NotNull
    final String myPrefix;
    @NotNull
    final String mySuffix;

    public UrlBasedViewResolver(CommonSpringBean bean) {
        this(SpringPropertyUtils.getPropertyStringValue((CommonSpringBean)bean, (String)"prefix"), SpringPropertyUtils.getPropertyStringValue((CommonSpringBean)bean, (String)"suffix"));
    }

    public UrlBasedViewResolver(String prefix, String suffix) {
        this.myPrefix = prefix == null ? "" : prefix;
        this.mySuffix = suffix == null ? "" : suffix;
    }

    @Override
    public PsiElement resolveView(String viewName, SpringMVCModel springMVCModel) {
        String path = this.myPrefix + viewName + this.mySuffix;
        WebDirectoryElement element = WebUtil.getWebUtil().findWebDirectoryElement(path, springMVCModel.getWebFacet());
        return element == null ? null : element.getOriginalFile();
    }

    @Override
    public List<LookupElement> getAllViews(SpringMVCModel context) {
        WebDirectoryElement element = WebUtil.getWebUtil().findWebDirectoryElement(this.myPrefix, context.getWebFacet());
        if (element == null) {
            return Collections.emptyList();
        }
        return ContainerUtil.mapNotNull((Object[])element.getChildren(), (Function)new NullableFunction<WebDirectoryElement, LookupElement>(){

            public LookupElement fun(WebDirectoryElement webDirectoryElement) {
                String name = webDirectoryElement.getName();
                if (!name.endsWith(UrlBasedViewResolver.this.mySuffix)) {
                    return null;
                }
                name = name.substring(0, name.length() - UrlBasedViewResolver.this.mySuffix.length());
                return LookupElementBuilder.create((String)name).withIcon(webDirectoryElement.getIcon(0)).withTailText(" (" + webDirectoryElement.getPath() + ")", true);
            }
        });
    }

    @Override
    public String bindToElement(PsiElement element) {
        if (!(element instanceof PsiFile)) {
            return null;
        }
        WebDirectoryElement webDirectoryElement = WebUtil.findWebDirectoryByFile((PsiFileSystemItem)((PsiFile)element));
        if (webDirectoryElement == null) {
            return null;
        }
        String path = webDirectoryElement.getPath();
        if (path.startsWith(this.myPrefix) && path.endsWith(this.mySuffix)) {
            return path.substring(this.myPrefix.length(), path.length() - this.mySuffix.length());
        }
        return path;
    }

    @Override
    @NotNull
    public String handleElementRename(String path) {
        if (path.endsWith(this.mySuffix)) {
            path = path.substring(0, path.length() - this.mySuffix.length());
        }
        String string = path;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/views/UrlBasedViewResolver", "handleElementRename"));
        }
        return string;
    }

    @Nullable
    WebDirectoryElement getRoot(SpringMVCModel model) {
        return WebUtil.getWebUtil().findWebDirectoryElement(this.myPrefix, model.getWebFacet());
    }

    @Nullable
    String encode(String name) {
        if (name.length() > this.mySuffix.length()) {
            return name.substring(0, name.length() - this.mySuffix.length());
        }
        return null;
    }

    String decode(String name) {
        return name + this.mySuffix;
    }
}

