/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc.views;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.spring.web.mvc.model.SpringMVCModel;
import com.intellij.spring.web.mvc.views.ViewResolver;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class ViewReference
extends PsiReferenceBase<PsiElement>
implements EmptyResolveMessageProvider {
    private ViewResolver myResolver;
    private final List<ViewResolver> myResolvers;
    private static final Logger LOG = Logger.getInstance(ViewReference.class);

    public ViewReference(PsiElement element, List<ViewResolver> resolvers, TextRange range, boolean soft) {
        super(element, range, soft);
        this.myResolvers = resolvers;
    }

    public PsiElement resolve() {
        SpringMVCModel model = SpringMVCModel.getModel(this.getElement());
        if (model == null) {
            return null;
        }
        String viewName = this.getCanonicalText();
        for (ViewResolver resolver : this.myResolvers) {
            PsiElement psiElement = resolver.resolveView(viewName, model);
            if (psiElement == null) continue;
            this.myResolver = resolver;
            return psiElement;
        }
        return null;
    }

    @NotNull
    public Object[] getVariants() {
        SpringMVCModel model = SpringMVCModel.getModel(this.getElement());
        if (model == null) {
            if (EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/views/ViewReference", "getVariants"));
            }
            return EMPTY_ARRAY;
        }
        ArrayList<LookupElement> allViews = new ArrayList<LookupElement>();
        for (ViewResolver resolver : this.myResolvers) {
            allViews.addAll(resolver.getAllViews(model));
        }
        Object[] objectArray = ArrayUtil.toObjectArray(allViews);
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/views/ViewReference", "getVariants"));
        }
        return objectArray;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/web/mvc/views/ViewReference", "bindToElement"));
        }
        LOG.assertTrue(this.myResolver != null, (Object)("Trying to bind a non-resolved reference? Resolvers: " + this.myResolvers + ", element: " + element));
        String newName = this.myResolver.bindToElement(element);
        return newName == null ? this.getElement() : ElementManipulators.getManipulator((PsiElement)this.getElement()).handleContentChange(this.getElement(), newName);
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        return super.handleElementRename(this.myResolver.handleElementRename(newElementName));
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        String string = this.myResolvers.isEmpty() ? "No view resolvers found" : "Cannot resolve MVC View ''{0}''";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/views/ViewReference", "getUnresolvedMessagePattern"));
        }
        return string;
    }
}

