/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.completion;

import com.intellij.codeInsight.completion.PrefixMatcher;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CucumberPrefixMatcher
extends PrefixMatcher {
    private final List<String> prefixWords;

    protected CucumberPrefixMatcher(String prefix) {
        super(prefix);
        this.prefixWords = CucumberPrefixMatcher.getSignificantWords(prefix);
    }

    public boolean prefixMatches(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/cucumber/completion/CucumberPrefixMatcher", "prefixMatches"));
        }
        List<String> nameWords = CucumberPrefixMatcher.getSignificantWords(name);
        int j = 0;
        for (int i = 0; i < this.prefixWords.size(); ++i) {
            while (j < nameWords.size() && !nameWords.get(j).contains(this.prefixWords.get(i))) {
                ++j;
            }
            if (j < nameWords.size()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public PrefixMatcher cloneWithPrefix(@NotNull String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "org/jetbrains/plugins/cucumber/completion/CucumberPrefixMatcher", "cloneWithPrefix"));
        }
        CucumberPrefixMatcher cucumberPrefixMatcher = new CucumberPrefixMatcher(prefix);
        if (cucumberPrefixMatcher == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/completion/CucumberPrefixMatcher", "cloneWithPrefix"));
        }
        return cucumberPrefixMatcher;
    }

    private static boolean isWordToCount(String word) {
        return word.matches(".*[()\\\\#0-9].*");
    }

    private static List<String> getSignificantWords(String source) {
        String[] words;
        ArrayList<String> result = new ArrayList<String>();
        for (String word : words = source.split(" ")) {
            if (CucumberPrefixMatcher.isWordToCount(word)) continue;
            result.add(word.toLowerCase());
        }
        return result;
    }
}

