/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.cucumber.CucumberBundle;
import org.jetbrains.plugins.cucumber.inspections.CucumberCreateExamplesSectionFix;
import org.jetbrains.plugins.cucumber.inspections.GherkinInspection;
import org.jetbrains.plugins.cucumber.psi.GherkinElementVisitor;
import org.jetbrains.plugins.cucumber.psi.GherkinScenarioOutline;
import org.jetbrains.plugins.cucumber.psi.impl.GherkinExamplesBlockImpl;

public class CucumberMissedExamplesInspection
extends GherkinInspection {
    public boolean isEnabledByDefault() {
        return true;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = CucumberBundle.message("inspection.missed.example.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/inspections/CucumberMissedExamplesInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("CucumberMissedExamples" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/inspections/CucumberMissedExamplesInspection", "getShortName"));
        }
        return "CucumberMissedExamples";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/plugins/cucumber/inspections/CucumberMissedExamplesInspection", "buildVisitor"));
        }
        GherkinElementVisitor gherkinElementVisitor = new GherkinElementVisitor(){

            @Override
            public void visitScenarioOutline(GherkinScenarioOutline outline) {
                PsiElement descriptionLine;
                super.visitScenarioOutline(outline);
                GherkinExamplesBlockImpl block = (GherkinExamplesBlockImpl)PsiTreeUtil.getChildOfType((PsiElement)outline, GherkinExamplesBlockImpl.class);
                if (block == null && (descriptionLine = outline.getShortDescriptionText()) != null) {
                    holder.registerProblem((PsiElement)outline, new TextRange(0, descriptionLine.getTextRange().getEndOffset() - outline.getTextOffset()), CucumberBundle.message("inspection.missed.example.msg.name", new Object[0]), new LocalQuickFix[]{new CucumberCreateExamplesSectionFix()});
                }
            }
        };
        if (gherkinElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/inspections/CucumberMissedExamplesInspection", "buildVisitor"));
        }
        return gherkinElementVisitor;
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/inspections/CucumberMissedExamplesInspection", "getDefaultLevel"));
        }
        return highlightDisplayLevel;
    }
}

