/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.psi;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import java.io.InputStream;
import org.jetbrains.plugins.cucumber.psi.GherkinKeywordProvider;
import org.jetbrains.plugins.cucumber.psi.PlainGherkinKeywordProvider;
import org.jetbrains.plugins.cucumber.psi.i18n.JsonGherkinKeywordProvider;

public class CucumberLanguageService {
    private GherkinKeywordProvider myKeywordProvider;

    public static CucumberLanguageService getInstance(Project project) {
        return (CucumberLanguageService)ServiceManager.getService((Project)project, CucumberLanguageService.class);
    }

    public CucumberLanguageService(Project project) {
    }

    public GherkinKeywordProvider getKeywordProvider() {
        if (this.myKeywordProvider == null) {
            InputStream inputStream;
            ClassLoader classLoader = CucumberLanguageService.class.getClassLoader();
            if (classLoader != null && (inputStream = classLoader.getResourceAsStream("i18n.json")) != null) {
                this.myKeywordProvider = new JsonGherkinKeywordProvider(inputStream);
            }
            if (this.myKeywordProvider == null) {
                this.myKeywordProvider = new PlainGherkinKeywordProvider();
            }
        }
        return this.myKeywordProvider;
    }
}

