/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.psi;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.psi.CucumberLanguageService;
import org.jetbrains.plugins.cucumber.psi.GherkinElementType;
import org.jetbrains.plugins.cucumber.psi.GherkinFile;
import org.jetbrains.plugins.cucumber.psi.GherkinKeywordProvider;
import org.jetbrains.plugins.cucumber.psi.GherkinTokenTypes;
import org.jetbrains.plugins.cucumber.psi.impl.GherkinFileImpl;

public class GherkinKeywordTable {
    private Map<IElementType, Collection<String>> myType2KeywordsTable = new HashMap<IElementType, Collection<String>>();

    public GherkinKeywordTable() {
        for (IElementType type : GherkinTokenTypes.KEYWORDS.getTypes()) {
            this.myType2KeywordsTable.put(type, new ArrayList());
        }
    }

    public void putAllKeywordsInto(Map<String, IElementType> target) {
        for (IElementType type : this.getTypes()) {
            Collection<String> keywords = this.getKeywords(type);
            if (keywords == null) continue;
            for (String keyword : keywords) {
                target.put(keyword, type);
            }
        }
    }

    public void put(IElementType type, String keyword) {
        if (GherkinTokenTypes.KEYWORDS.contains(type)) {
            Collection<String> keywords = this.getKeywords(type);
            if (keywords == null) {
                keywords = new ArrayList<String>(1);
                this.myType2KeywordsTable.put(type, keywords);
            }
            keywords.add(keyword);
        }
    }

    public Collection<String> getStepKeywords() {
        Collection<String> keywords = this.getKeywords(GherkinTokenTypes.STEP_KEYWORD);
        assert (keywords != null);
        return keywords;
    }

    public Collection<String> getScenarioKeywords() {
        return this.getKeywords(GherkinTokenTypes.SCENARIO_KEYWORD);
    }

    public Collection<String> getScenarioLikeKeywords() {
        HashSet<String> keywords = new HashSet<String>();
        Collection<String> scenarios = this.getKeywords(GherkinTokenTypes.SCENARIO_KEYWORD);
        assert (scenarios != null);
        keywords.addAll(scenarios);
        Collection<String> scenarioOutline = this.getKeywords(GherkinTokenTypes.SCENARIO_OUTLINE_KEYWORD);
        assert (scenarioOutline != null);
        keywords.addAll(scenarioOutline);
        return keywords;
    }

    public String getScenarioOutlineKeyword() {
        return this.getScenarioOutlineKeywords().iterator().next();
    }

    public Collection<String> getScenarioOutlineKeywords() {
        Collection<String> scenarioOutline = this.getKeywords(GherkinTokenTypes.SCENARIO_OUTLINE_KEYWORD);
        assert (scenarioOutline != null);
        return scenarioOutline;
    }

    public Collection<String> getBackgroundKeywords() {
        Collection<String> bg = this.getKeywords(GherkinTokenTypes.BACKGROUND_KEYWORD);
        assert (bg != null);
        return bg;
    }

    public String getExampleSectionKeyword() {
        return this.getExampleSectionKeywords().iterator().next();
    }

    public Collection<String> getExampleSectionKeywords() {
        Collection<String> keywords = this.getKeywords(GherkinTokenTypes.EXAMPLES_KEYWORD);
        assert (keywords != null);
        return keywords;
    }

    public String getFeatureSectionKeyword() {
        return this.getFeaturesSectionKeywords().iterator().next();
    }

    public Collection<String> getFeaturesSectionKeywords() {
        Collection<String> keywords = this.getKeywords(GherkinTokenTypes.FEATURE_KEYWORD);
        assert (keywords != null);
        return keywords;
    }

    @NotNull
    public static GherkinKeywordTable getKeywordsTable(PsiFile originalFile, Project project) {
        GherkinKeywordProvider provider = CucumberLanguageService.getInstance(project).getKeywordProvider();
        String language = GherkinKeywordTable.getFeatureLanguage(originalFile);
        GherkinKeywordTable gherkinKeywordTable = provider.getKeywordsTable(language);
        if (gherkinKeywordTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/psi/GherkinKeywordTable", "getKeywordsTable"));
        }
        return gherkinKeywordTable;
    }

    @NotNull
    public static String getFeatureLanguage(PsiFile originalFile) {
        String string = originalFile instanceof GherkinFile ? ((GherkinFile)originalFile).getLocaleLanguage() : GherkinFileImpl.getDefaultLocale();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/psi/GherkinKeywordTable", "getFeatureLanguage"));
        }
        return string;
    }

    public Collection<IElementType> getTypes() {
        return this.myType2KeywordsTable.keySet();
    }

    @Nullable
    public Collection<String> getKeywords(IElementType type) {
        return this.myType2KeywordsTable.get(type);
    }

    public boolean tableContainsKeyword(GherkinElementType type, String keyword) {
        Collection<String> alreadyKnownKeywords = this.getKeywords(type);
        return null != alreadyKnownKeywords && alreadyKnownKeywords.contains(keyword);
    }
}

