/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.psi;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiParser;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.cucumber.psi.CucumberLanguageService;
import org.jetbrains.plugins.cucumber.psi.GherkinElementTypes;
import org.jetbrains.plugins.cucumber.psi.GherkinLexer;
import org.jetbrains.plugins.cucumber.psi.GherkinParser;
import org.jetbrains.plugins.cucumber.psi.GherkinTableCellImpl;
import org.jetbrains.plugins.cucumber.psi.GherkinTokenTypes;
import org.jetbrains.plugins.cucumber.psi.PlainGherkinKeywordProvider;
import org.jetbrains.plugins.cucumber.psi.impl.GherkinExamplesBlockImpl;
import org.jetbrains.plugins.cucumber.psi.impl.GherkinFeatureHeaderImpl;
import org.jetbrains.plugins.cucumber.psi.impl.GherkinFeatureImpl;
import org.jetbrains.plugins.cucumber.psi.impl.GherkinFileImpl;
import org.jetbrains.plugins.cucumber.psi.impl.GherkinPystringImpl;
import org.jetbrains.plugins.cucumber.psi.impl.GherkinScenarioImpl;
import org.jetbrains.plugins.cucumber.psi.impl.GherkinScenarioOutlineImpl;
import org.jetbrains.plugins.cucumber.psi.impl.GherkinStepImpl;
import org.jetbrains.plugins.cucumber.psi.impl.GherkinStepParameterImpl;
import org.jetbrains.plugins.cucumber.psi.impl.GherkinTableHeaderRowImpl;
import org.jetbrains.plugins.cucumber.psi.impl.GherkinTableImpl;
import org.jetbrains.plugins.cucumber.psi.impl.GherkinTableRowImpl;
import org.jetbrains.plugins.cucumber.psi.impl.GherkinTagImpl;

public class GherkinParserDefinition
implements ParserDefinition {
    private static final TokenSet WHITESPACE = TokenSet.create((IElementType[])new IElementType[]{TokenType.WHITE_SPACE});
    private static final TokenSet COMMENTS = TokenSet.create((IElementType[])new IElementType[]{GherkinTokenTypes.COMMENT});

    @NotNull
    public Lexer createLexer(Project project) {
        CucumberLanguageService instance = CucumberLanguageService.getInstance(project);
        GherkinLexer gherkinLexer = new GherkinLexer(instance == null ? new PlainGherkinKeywordProvider() : instance.getKeywordProvider());
        if (gherkinLexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/psi/GherkinParserDefinition", "createLexer"));
        }
        return gherkinLexer;
    }

    public PsiParser createParser(Project project) {
        return new GherkinParser();
    }

    public IFileElementType getFileNodeType() {
        return GherkinElementTypes.GHERKIN_FILE;
    }

    @NotNull
    public TokenSet getWhitespaceTokens() {
        TokenSet tokenSet = WHITESPACE;
        if (tokenSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/psi/GherkinParserDefinition", "getWhitespaceTokens"));
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        TokenSet tokenSet = COMMENTS;
        if (tokenSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/psi/GherkinParserDefinition", "getCommentTokens"));
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        TokenSet tokenSet = TokenSet.EMPTY;
        if (tokenSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/psi/GherkinParserDefinition", "getStringLiteralElements"));
        }
        return tokenSet;
    }

    @NotNull
    public PsiElement createElement(ASTNode node) {
        if (node.getElementType() == GherkinElementTypes.FEATURE) {
            GherkinFeatureImpl gherkinFeatureImpl = new GherkinFeatureImpl(node);
            if (gherkinFeatureImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/psi/GherkinParserDefinition", "createElement"));
            }
            return gherkinFeatureImpl;
        }
        if (node.getElementType() == GherkinElementTypes.FEATURE_HEADER) {
            GherkinFeatureHeaderImpl gherkinFeatureHeaderImpl = new GherkinFeatureHeaderImpl(node);
            if (gherkinFeatureHeaderImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/psi/GherkinParserDefinition", "createElement"));
            }
            return gherkinFeatureHeaderImpl;
        }
        if (node.getElementType() == GherkinElementTypes.SCENARIO) {
            GherkinScenarioImpl gherkinScenarioImpl = new GherkinScenarioImpl(node);
            if (gherkinScenarioImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/psi/GherkinParserDefinition", "createElement"));
            }
            return gherkinScenarioImpl;
        }
        if (node.getElementType() == GherkinElementTypes.STEP) {
            GherkinStepImpl gherkinStepImpl = new GherkinStepImpl(node);
            if (gherkinStepImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/psi/GherkinParserDefinition", "createElement"));
            }
            return gherkinStepImpl;
        }
        if (node.getElementType() == GherkinElementTypes.SCENARIO_OUTLINE) {
            GherkinScenarioOutlineImpl gherkinScenarioOutlineImpl = new GherkinScenarioOutlineImpl(node);
            if (gherkinScenarioOutlineImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/psi/GherkinParserDefinition", "createElement"));
            }
            return gherkinScenarioOutlineImpl;
        }
        if (node.getElementType() == GherkinElementTypes.EXAMPLES_BLOCK) {
            GherkinExamplesBlockImpl gherkinExamplesBlockImpl = new GherkinExamplesBlockImpl(node);
            if (gherkinExamplesBlockImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/psi/GherkinParserDefinition", "createElement"));
            }
            return gherkinExamplesBlockImpl;
        }
        if (node.getElementType() == GherkinElementTypes.TABLE) {
            GherkinTableImpl gherkinTableImpl = new GherkinTableImpl(node);
            if (gherkinTableImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/psi/GherkinParserDefinition", "createElement"));
            }
            return gherkinTableImpl;
        }
        if (node.getElementType() == GherkinElementTypes.TABLE_ROW) {
            GherkinTableRowImpl gherkinTableRowImpl = new GherkinTableRowImpl(node);
            if (gherkinTableRowImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/psi/GherkinParserDefinition", "createElement"));
            }
            return gherkinTableRowImpl;
        }
        if (node.getElementType() == GherkinElementTypes.TABLE_CELL) {
            GherkinTableCellImpl gherkinTableCellImpl = new GherkinTableCellImpl(node);
            if (gherkinTableCellImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/psi/GherkinParserDefinition", "createElement"));
            }
            return gherkinTableCellImpl;
        }
        if (node.getElementType() == GherkinElementTypes.TABLE_HEADER_ROW) {
            GherkinTableHeaderRowImpl gherkinTableHeaderRowImpl = new GherkinTableHeaderRowImpl(node);
            if (gherkinTableHeaderRowImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/psi/GherkinParserDefinition", "createElement"));
            }
            return gherkinTableHeaderRowImpl;
        }
        if (node.getElementType() == GherkinElementTypes.TAG) {
            GherkinTagImpl gherkinTagImpl = new GherkinTagImpl(node);
            if (gherkinTagImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/psi/GherkinParserDefinition", "createElement"));
            }
            return gherkinTagImpl;
        }
        if (node.getElementType() == GherkinElementTypes.STEP_PARAMETER) {
            GherkinStepParameterImpl gherkinStepParameterImpl = new GherkinStepParameterImpl(node);
            if (gherkinStepParameterImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/psi/GherkinParserDefinition", "createElement"));
            }
            return gherkinStepParameterImpl;
        }
        if (node.getElementType() == GherkinElementTypes.PYSTRING) {
            GherkinPystringImpl gherkinPystringImpl = new GherkinPystringImpl(node);
            if (gherkinPystringImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/psi/GherkinParserDefinition", "createElement"));
            }
            return gherkinPystringImpl;
        }
        PsiElement psiElement = PsiUtilCore.NULL_PSI_ELEMENT;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/psi/GherkinParserDefinition", "createElement"));
        }
        return psiElement;
    }

    public PsiFile createFile(FileViewProvider viewProvider) {
        return new GherkinFileImpl(viewProvider);
    }

    public ParserDefinition.SpaceRequirements spaceExistanceTypeBetweenTokens(ASTNode left, ASTNode right) {
        IElementType leftElementType = left.getElementType();
        if (leftElementType == GherkinTokenTypes.COMMENT) {
            return ParserDefinition.SpaceRequirements.MUST_LINE_BREAK;
        }
        if (right.getElementType() == GherkinTokenTypes.EXAMPLES_KEYWORD) {
            return ParserDefinition.SpaceRequirements.MUST_LINE_BREAK;
        }
        return ParserDefinition.SpaceRequirements.MAY;
    }
}

