/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.psi.refactoring.rename;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ReadOnlyFragmentModificationException;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.actionSystem.ReadonlyFragmentModificationHandler;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.rename.RenameDialog;
import com.intellij.refactoring.rename.RenameProcessor;
import java.awt.GridBagConstraints;
import java.util.EnumSet;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.intellij.lang.regexp.RegExpCapability;
import org.intellij.lang.regexp.RegExpLexer;
import org.intellij.lang.regexp.RegExpTT;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.CucumberBundle;
import org.jetbrains.plugins.cucumber.psi.refactoring.rename.CucumberStepRenameProcessor;
import org.jetbrains.plugins.cucumber.steps.AbstractStepDefinition;
import org.jetbrains.plugins.cucumber.steps.reference.CucumberStepReference;

public class CucumberStepRenameDialog
extends RenameDialog {
    private AbstractStepDefinition myStepDefinition;

    public CucumberStepRenameDialog(@NotNull Project project, @NotNull PsiElement psiElement, @Nullable PsiElement nameSuggestionContext, Editor editor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/cucumber/psi/refactoring/rename/CucumberStepRenameDialog", "<init>"));
        }
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "org/jetbrains/plugins/cucumber/psi/refactoring/rename/CucumberStepRenameDialog", "<init>"));
        }
        super(project, psiElement, nameSuggestionContext, editor);
    }

    protected RenameProcessor createRenameProcessor(String newName) {
        return new RenameProcessor(this.getProject(), this.getPsiElement(), newName, this.isSearchInComments(), this.isSearchInNonJavaFiles());
    }

    protected String getFullName() {
        return CucumberBundle.message("cucumber.step", new Object[0]);
    }

    protected void createNewNameComponent() {
        super.createNewNameComponent();
        Runnable guardRunnable = new Runnable(){

            @Override
            public void run() {
                Editor editor = CucumberStepRenameDialog.this.getNameSuggestionsField().getEditor();
                if (editor != null) {
                    editor.getSelectionModel().removeSelection();
                    editor.getCaretModel().moveToOffset(0);
                    Document document = editor.getDocument();
                    EditorActionManager.getInstance().setReadonlyFragmentModificationHandler(document, new ReadonlyFragmentModificationHandler(){

                        public void handle(ReadOnlyFragmentModificationException e) {
                        }
                    });
                    CucumberStepRenameDialog.guardRegexpSpecialSymbols(editor);
                }
            }
        };
        SwingUtilities.invokeLater(guardRunnable);
    }

    private AbstractStepDefinition getStepDefinition() {
        CucumberStepReference ref;
        if (this.myStepDefinition == null && (ref = CucumberStepRenameProcessor.getCucumberStepReference(this.getPsiElement())) != null) {
            this.myStepDefinition = ref.resolveToDefinition();
        }
        return this.myStepDefinition;
    }

    private static void guardRegexpSpecialSymbols(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/plugins/cucumber/psi/refactoring/rename/CucumberStepRenameDialog", "guardRegexpSpecialSymbols"));
        }
        String text = editor.getDocument().getText();
        RegExpLexer lexer = new RegExpLexer(EnumSet.noneOf(RegExpCapability.class));
        lexer.start((CharSequence)text);
        while (lexer.getTokenType() != null) {
            if (lexer.getTokenType() != RegExpTT.CHARACTER) {
                editor.getDocument().createGuardedBlock(lexer.getTokenStart(), lexer.getTokenEnd());
            }
            lexer.advance();
        }
    }

    public String[] getSuggestedNames() {
        String result;
        AbstractStepDefinition stepDefinition = this.getStepDefinition();
        if (stepDefinition != null && (result = stepDefinition.getCucumberRegex()) != null) {
            if (result.startsWith("^")) {
                result = result.substring(1);
            }
            if (result.endsWith("$")) {
                result = result.substring(0, result.length() - 1);
            }
            return new String[]{result};
        }
        return super.getSuggestedNames();
    }

    protected void processNewNameChanged() {
        this.getPreviewAction().setEnabled(true);
        this.getRefactorAction().setEnabled(true);
    }

    protected void createCheckboxes(JPanel panel, GridBagConstraints gbConstraints) {
        super.createCheckboxes(panel, gbConstraints);
        this.getCbSearchInComments().setVisible(false);
    }
}

