/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.composite;

import com.intellij.codeInsight.daemon.Validator;
import com.intellij.jsf.composite.CompositeUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.meta.PsiWritableMetaData;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlElementDescriptorAwareAboutChildren;
import com.intellij.xml.XmlElementsGroup;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.impl.schema.AnyXmlAttributeDescriptor;
import com.intellij.xml.impl.schema.AnyXmlElementDescriptor;
import java.util.HashSet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompositeComponentDescriptor
implements XmlElementDescriptor,
PsiWritableMetaData,
Validator<XmlTag>,
XmlElementDescriptorAwareAboutChildren {
    private XmlFile myFile;
    private String myNamespacePrefix;
    private String ID_ATTR_NAME;

    public CompositeComponentDescriptor(@NotNull XmlFile file, @NotNull String prefix) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/jsf/composite/CompositeComponentDescriptor", "<init>"));
        }
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/jsf/composite/CompositeComponentDescriptor", "<init>"));
        }
        this.ID_ATTR_NAME = "id";
        this.myFile = file;
        this.myNamespacePrefix = prefix;
    }

    public String getQualifiedName() {
        return this.getDefaultName();
    }

    public String getDefaultName() {
        String nameWithoutExtension = FileUtil.getNameWithoutExtension((String)this.myFile.getName());
        return this.myNamespacePrefix + ":" + nameWithoutExtension;
    }

    public XmlElementDescriptor[] getElementsDescriptors(XmlTag context) {
        return new XmlElementDescriptor[0];
    }

    public XmlElementDescriptor getElementDescriptor(XmlTag childTag, XmlTag contextTag) {
        return new AnyXmlElementDescriptor((XmlElementDescriptor)this, this.getNSDescriptor());
    }

    public XmlAttributeDescriptor[] getAttributesDescriptors(@Nullable XmlTag context) {
        HashSet<Object> descriptors = new HashSet<Object>();
        descriptors.addAll(CompositeUtil.getCompositeComponentXmlAttributeDescriptors(this.myFile));
        descriptors.add(this.createIdXmlAttributeDescriptor());
        return descriptors.toArray(new XmlAttributeDescriptor[descriptors.size()]);
    }

    public XmlAttributeDescriptor getAttributeDescriptor(@NonNls String attributeName, @Nullable XmlTag context) {
        if (this.ID_ATTR_NAME.equals(attributeName)) {
            return this.createIdXmlAttributeDescriptor();
        }
        for (XmlAttributeDescriptor attributeDescriptor : CompositeUtil.getCompositeComponentXmlAttributeDescriptors(this.myFile)) {
            if (!attributeName.equals(attributeDescriptor.getName())) continue;
            return attributeDescriptor;
        }
        return null;
    }

    private AnyXmlAttributeDescriptor createIdXmlAttributeDescriptor() {
        return new AnyXmlAttributeDescriptor(this.ID_ATTR_NAME);
    }

    public XmlAttributeDescriptor getAttributeDescriptor(XmlAttribute attribute) {
        for (XmlAttributeDescriptor attributeDescriptor : (XmlAttributeDescriptor[])ArrayUtil.toObjectArray(CompositeUtil.getCompositeComponentXmlAttributeDescriptors(this.myFile), XmlAttributeDescriptor.class)) {
            if (!attribute.getName().equals(attributeDescriptor.getName())) continue;
            return attributeDescriptor;
        }
        if (this.ID_ATTR_NAME.equals(attribute.getName())) {
            return this.createIdXmlAttributeDescriptor();
        }
        return null;
    }

    public XmlNSDescriptor getNSDescriptor() {
        return null;
    }

    public XmlElementsGroup getTopGroup() {
        return null;
    }

    public int getContentType() {
        return 1;
    }

    public String getDefaultValue() {
        return null;
    }

    public PsiElement getDeclaration() {
        return this.myFile;
    }

    public String getName(PsiElement context) {
        return this.getDefaultName();
    }

    public String getName() {
        return this.getDefaultName();
    }

    public void init(PsiElement element) {
    }

    public Object[] getDependences() {
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public void validate(@NotNull XmlTag context, @NotNull Validator.ValidationHost host) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/jsf/composite/CompositeComponentDescriptor", "validate"));
        }
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/jsf/composite/CompositeComponentDescriptor", "validate"));
        }
    }

    public void setName(String name) throws IncorrectOperationException {
    }

    public boolean allowElementsFromNamespace(String namespace, XmlTag context) {
        return true;
    }
}

