/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.composite.references;

import com.intellij.jsf.composite.CompositeUtil;
import com.intellij.jsf.references.JsfXmlAttributeReferencesProvider;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ProcessingContext;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractCompositeVariantsReferenceProvider
extends JsfXmlAttributeReferencesProvider {
    private static final String NAME_ATTRIBUTE = "name";
    private final Function<XmlFile, Map<String, PsiElement>>[] myVariantsMapFunction;
    protected static final Function<XmlFile, Map<String, PsiElement>> VALUE_HOLDERS_FUNCTION = new Function<XmlFile, Map<String, PsiElement>>(){

        public Map<String, PsiElement> fun(XmlFile xmlFile) {
            return AbstractCompositeVariantsReferenceProvider.getValueHoldersByNameMap(xmlFile);
        }
    };
    protected static final Function<XmlFile, Map<String, PsiElement>> ACTION_SOURCE_HOLDERS_FUNCTION = new Function<XmlFile, Map<String, PsiElement>>(){

        public Map<String, PsiElement> fun(XmlFile xmlFile) {
            return AbstractCompositeVariantsReferenceProvider.getActionSourcesByNameMap(xmlFile);
        }
    };

    protected AbstractCompositeVariantsReferenceProvider(Function<XmlFile, Map<String, PsiElement>> ... variantsMap) {
        this.myVariantsMapFunction = variantsMap;
    }

    @Override
    protected PsiReference[] createReferences(@NotNull XmlAttributeValue xmlAttributeValue, ProcessingContext context) {
        if (xmlAttributeValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlAttributeValue", "com/intellij/jsf/composite/references/AbstractCompositeVariantsReferenceProvider", "createReferences"));
        }
        return new PsiReference[]{this.createCompositeComponentValueHolderReference(xmlAttributeValue, context)};
    }

    private PsiReference createCompositeComponentValueHolderReference(final XmlAttributeValue xmlAttributeValue, ProcessingContext context) {
        return new PsiReferenceBase<PsiElement>((PsiElement)xmlAttributeValue){

            public PsiElement resolve() {
                String value = xmlAttributeValue.getValue();
                if (StringUtil.isEmptyOrSpaces((String)value)) {
                    return null;
                }
                XmlFile file = AbstractCompositeVariantsReferenceProvider.this.getCompositeComponentXmlFile((PsiElement)xmlAttributeValue);
                if (file == null) {
                    return null;
                }
                return (PsiElement)AbstractCompositeVariantsReferenceProvider.this.getVariansMap(file).get(value);
            }

            public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
                return super.handleElementRename(newElementName);
            }

            @NotNull
            public Object[] getVariants() {
                XmlFile file = AbstractCompositeVariantsReferenceProvider.this.getCompositeComponentXmlFile((PsiElement)xmlAttributeValue);
                if (file == null) {
                    if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/composite/references/AbstractCompositeVariantsReferenceProvider$3", "getVariants"));
                    }
                    return ArrayUtil.EMPTY_OBJECT_ARRAY;
                }
                Set set = AbstractCompositeVariantsReferenceProvider.this.getVariansMap(file).keySet();
                Object[] objectArray = ArrayUtil.toStringArray(set);
                if (objectArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/composite/references/AbstractCompositeVariantsReferenceProvider$3", "getVariants"));
                }
                return objectArray;
            }

            public boolean isSoft() {
                return AbstractCompositeVariantsReferenceProvider.this.isSoftRefrence();
            }
        };
    }

    @NotNull
    private Map<String, PsiElement> getVariansMap(@NotNull XmlFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/jsf/composite/references/AbstractCompositeVariantsReferenceProvider", "getVariansMap"));
        }
        HashMap<String, PsiElement> results = new HashMap<String, PsiElement>();
        for (Function<XmlFile, Map<String, PsiElement>> xmlFileMapFunction : this.myVariantsMapFunction) {
            results.putAll((Map)xmlFileMapFunction.fun((Object)file));
        }
        HashMap<String, PsiElement> hashMap = results;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/composite/references/AbstractCompositeVariantsReferenceProvider", "getVariansMap"));
        }
        return hashMap;
    }

    protected boolean isSoftRefrence() {
        return false;
    }

    @NotNull
    private static Map<String, PsiElement> getValueHoldersByNameMap(@NotNull XmlFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/jsf/composite/references/AbstractCompositeVariantsReferenceProvider", "getValueHoldersByNameMap"));
        }
        HashMap<String, PsiElement> map = new HashMap<String, PsiElement>();
        Set<XmlTag> tags = CompositeUtil.getValueHolderCompositeComponentInterfaceTags(file);
        for (XmlTag tag : tags) {
            String value;
            XmlAttribute attribute = tag.getAttribute(NAME_ATTRIBUTE);
            if (attribute == null || StringUtil.isEmptyOrSpaces((String)(value = attribute.getValue()))) continue;
            map.put(value, (PsiElement)attribute.getValueElement());
        }
        HashMap<String, PsiElement> hashMap = map;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/composite/references/AbstractCompositeVariantsReferenceProvider", "getValueHoldersByNameMap"));
        }
        return hashMap;
    }

    @NotNull
    private static Map<String, PsiElement> getActionSourcesByNameMap(@NotNull XmlFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/jsf/composite/references/AbstractCompositeVariantsReferenceProvider", "getActionSourcesByNameMap"));
        }
        HashMap<String, PsiElement> map = new HashMap<String, PsiElement>();
        Set<XmlTag> tags = CompositeUtil.getActionSourceCompositeComponentInterfaceTags(file);
        for (XmlTag tag : tags) {
            String value;
            XmlAttribute attribute = tag.getAttribute(NAME_ATTRIBUTE);
            if (attribute == null || StringUtil.isEmptyOrSpaces((String)(value = attribute.getValue()))) continue;
            map.put(value, (PsiElement)attribute.getValueElement());
        }
        HashMap<String, PsiElement> hashMap = map;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/composite/references/AbstractCompositeVariantsReferenceProvider", "getActionSourcesByNameMap"));
        }
        return hashMap;
    }

    @Nullable
    protected abstract XmlFile getCompositeComponentXmlFile(PsiElement var1);
}

