/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.el;

import com.intellij.jsf.el.JsfELContextProvider;
import com.intellij.jsf.model.xml.FacesDomModelManager;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.jsp.el.ELContextProvider;
import com.intellij.psi.impl.source.jsp.el.ELLanguage;
import com.intellij.psi.impl.source.jsp.el.ELUtil;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlText;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FacesConfigElProvider
implements MultiHostInjector {
    public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement host) {
        List ranges;
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/jsf/el/FacesConfigElProvider", "getLanguagesToInject"));
        }
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/jsf/el/FacesConfigElProvider", "getLanguagesToInject"));
        }
        PsiElement originalElement = host.getOriginalElement();
        PsiFile psiFile = originalElement.getContainingFile();
        if (psiFile instanceof XmlFile && !(psiFile instanceof JspFile) && FacesConfigElProvider.isElContainerFile((XmlFile)psiFile) && (ranges = ELUtil.getELTextRanges((PsiElement)originalElement, (String)"#{", (String)"}")).size() > 0) {
            for (TextRange textRange : ranges) {
                registrar.startInjecting(ELLanguage.INSTANCE).addPlace(null, null, (PsiLanguageInjectionHost)originalElement, textRange).doneInjecting();
            }
            originalElement.putUserData(ELContextProvider.ourContextProviderKey, (Object)new JsfELContextProvider());
        }
    }

    private static boolean isElContainerFile(@NotNull XmlFile xmlFile) {
        if (xmlFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlFile", "com/intellij/jsf/el/FacesConfigElProvider", "isElContainerFile"));
        }
        Project project = xmlFile.getProject();
        return !project.isDefault() && FacesDomModelManager.getInstance(project).isFacesConfig(xmlFile);
    }

    @NotNull
    public List<? extends Class<? extends PsiElement>> elementsToInjectIn() {
        List<Class> list = Arrays.asList(XmlAttributeValue.class, XmlText.class);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/el/FacesConfigElProvider", "elementsToInjectIn"));
        }
        return list;
    }
}

