/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.el.contibutors;

import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.jsf.el.ELVariableProcessingContext;
import com.intellij.jsf.el.contibutors.JsfElVariablesContributor;
import com.intellij.jsf.model.xml.FacesDomModel;
import com.intellij.jsf.model.xml.FacesDomModelManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.source.jsp.el.impl.CustomJsfVariableResolverProvider;
import com.intellij.psi.util.CachedValue;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomVariableResolversContributor
extends JsfElVariablesContributor {
    private static final Key<CachedValue<List<PsiVariable>>> CUSTOM_RESOLVERS_VARS = Key.create((String)"custom resolvers el vars");

    @Override
    @NotNull
    public List<PsiVariable> getVariables(ELVariableProcessingContext context) {
        ArrayList<PsiVariable> vars = new ArrayList<PsiVariable>();
        List<String> variableResolverClasses = CustomVariableResolversContributor.getCustomVariableResolverClasses(context);
        if (variableResolverClasses.size() > 0) {
            CustomJsfVariableResolverProvider[] providers = (CustomJsfVariableResolverProvider[])Extensions.getExtensions((ExtensionPointName)CustomJsfVariableResolverProvider.EP_NAME);
            for (String resolverClass : variableResolverClasses) {
                for (CustomJsfVariableResolverProvider provider : providers) {
                    if (!provider.acceptVariableResolver(resolverClass, context.getModule())) continue;
                    provider.addVars(vars, context.getModule());
                }
            }
        }
        ArrayList<PsiVariable> arrayList = vars;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/el/contibutors/CustomVariableResolversContributor", "getVariables"));
        }
        return arrayList;
    }

    @Override
    public Key<CachedValue<List<PsiVariable>>> getKey() {
        return CUSTOM_RESOLVERS_VARS;
    }

    private static List<String> getCustomVariableResolverClasses(ELVariableProcessingContext context) {
        ArrayList<String> classes = new ArrayList<String>();
        for (WebFacet webFacet : WebFacet.getInstances((Module)context.getModule())) {
            List<FacesDomModel> models = FacesDomModelManager.getInstance(context.getProject()).getAllModels(webFacet);
            for (FacesDomModel facesDomModel : models) {
                CustomVariableResolversContributor.addNotNull(classes, facesDomModel.getFacesConfig().getApplication().getVariableResolver().getStringValue());
                CustomVariableResolversContributor.addNotNull(classes, facesDomModel.getFacesConfig().getApplication().getElResolver().getStringValue());
            }
        }
        return classes;
    }

    private static void addNotNull(@NotNull List<String> classes, @Nullable String aClass) {
        if (classes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classes", "com/intellij/jsf/el/contibutors/CustomVariableResolversContributor", "addNotNull"));
        }
        if (!StringUtil.isEmptyOrSpaces((String)aClass)) {
            classes.add(aClass);
        }
    }
}

