/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.flows.references;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.jsf.flows.FlowsCommonUtils;
import com.intellij.jsf.flows.FlowsPresentationUtils;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.Processor;
import com.intellij.util.containers.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlowPsiReference
extends PsiReferenceBase<PsiElement> {
    public FlowPsiReference(PsiElement element) {
        super(element, true);
    }

    @Nullable
    public PsiElement resolve() {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.getElement());
        if (module == null) {
            return null;
        }
        Pair<PsiElement, String> definitionByName = FlowsCommonUtils.findFlowDefinitionByName(module, this.getValue());
        return definitionByName == null ? null : (PsiElement)definitionByName.first;
    }

    @NotNull
    public Object[] getVariants() {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.getElement());
        if (module == null) {
            if (EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/flows/references/FlowPsiReference", "getVariants"));
            }
            return EMPTY_ARRAY;
        }
        HashSet elements = new HashSet();
        FlowsCommonUtils.processAllFlows(new Processor<Pair<PsiElement, String>>((Set)elements){
            final /* synthetic */ Set val$elements;
            {
                this.val$elements = set;
            }

            public boolean process(Pair<PsiElement, String> pair) {
                PsiElement resolved = (PsiElement)pair.first;
                if (resolved instanceof XmlElement) {
                    this.val$elements.add(FlowsPresentationUtils.createExplicitFlowLookupElement((String)pair.second));
                } else if (resolved instanceof PsiDirectory) {
                    this.val$elements.add(FlowsPresentationUtils.createImplicitFlowLookupElement((PsiDirectory)resolved));
                } else {
                    this.val$elements.add(FlowsPresentationUtils.createAnnotatedFlowLookupElement((String)pair.second));
                }
                return true;
            }
        }, module);
        Object[] objectArray = elements.toArray(new LookupElement[elements.size()]);
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/flows/references/FlowPsiReference", "getVariants"));
        }
        return objectArray;
    }
}

